/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.ia.model.BuiltAffGroup;
import com.ibm.cics.ia.model.Transaction;
import java.util.HashMap;

class CPSMInputTreeViewerNode {
    private HashMap<String, Object> data;
    private CPSMInputTreeViewerNode parentNode;
    private CPSMInputTreeViewerNode[] childNodes;
    private Type type;
    private boolean checked = false;

    public CPSMInputTreeViewerNode() {
    }

    public CPSMInputTreeViewerNode(Type type, Object data, CPSMInputTreeViewerNode parentNode) {
        this();
        this.data = new HashMap();
        this.data.put(null, data);
        this.parentNode = parentNode;
        this.type = type;
        this.childNodes = new CPSMInputTreeViewerNode[0];
    }

    public Object getData() {
        return this.data.get(null);
    }

    public Object getData(String key) {
        return this.data.get(key);
    }

    public void setData(Object data) {
        this.data.put(null, data);
    }

    public void setData(String key, Object data) {
        this.data.put(key, data);
    }

    public CPSMInputTreeViewerNode getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(CPSMInputTreeViewerNode parentNode) {
        this.parentNode = parentNode;
    }

    public CPSMInputTreeViewerNode[] getChildNodes() {
        return this.childNodes;
    }

    public void setChildNodes(CPSMInputTreeViewerNode[] childNodes) {
        this.childNodes = childNodes;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        BuiltAffGroup affGroup;
        this.checked = checked;
        if (this.getType().equals((Object)Type.RemoveTrangrp)) {
            affGroup = (BuiltAffGroup)this.getData();
            affGroup.setDoRemove(checked);
        } else if (this.getType().equals((Object)Type.CreateTrangrp)) {
            affGroup = (BuiltAffGroup)this.getData();
            affGroup.setDoCreate(checked);
        } else if (this.getType().equals((Object)Type.CreateDtringrp)) {
            affGroup = (BuiltAffGroup)this.getParentNode().getData();
            Transaction transaction = (Transaction)this.getData();
            affGroup.setCreateTransaction(transaction, Boolean.valueOf(checked));
        }
        CPSMInputTreeViewerNode[] cPSMInputTreeViewerNodeArray = this.childNodes;
        int n = this.childNodes.length;
        int n2 = 0;
        while (n2 < n) {
            CPSMInputTreeViewerNode node = cPSMInputTreeViewerNodeArray[n2];
            node.setChecked(checked);
            ++n2;
        }
    }

    public boolean updateCheckedState() {
        boolean allChecked = true;
        boolean noneChecked = true;
        CPSMInputTreeViewerNode[] cPSMInputTreeViewerNodeArray = this.childNodes;
        int n = this.childNodes.length;
        int n2 = 0;
        while (n2 < n) {
            CPSMInputTreeViewerNode node = cPSMInputTreeViewerNodeArray[n2];
            if (node.isChecked()) {
                noneChecked = false;
            } else {
                allChecked = false;
            }
            ++n2;
        }
        if (!this.checked && allChecked) {
            this.checked = true;
            return true;
        }
        if (this.checked && noneChecked) {
            this.checked = false;
            return true;
        }
        return false;
    }

    static enum Type {
        Context,
        RemoveTrangrp,
        CreateTrangrp,
        CreateDtringrp,
        Dummy;

    }
}

