/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.ia.model.AffinityBuilderOutput;
import com.ibm.cics.ia.model.BuiltAffGroup;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.CPSMInputTreeViewerNode;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

class CPSMInputTreeContentProvider
implements ITreeContentProvider {
    private AffinityBuilderOutput output;
    CPSMInputTreeViewerNode[] rootNodes = new CPSMInputTreeViewerNode[0];

    CPSMInputTreeContentProvider() {
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof AffinityBuilderOutput) {
            this.output = (AffinityBuilderOutput)newInput;
            List groupsList = this.output.getAffinityGroups();
            BuiltAffGroup[] groups = new BuiltAffGroup[groupsList.size()];
            int i = 0;
            while (i < groupsList.size()) {
                groups[i] = (BuiltAffGroup)groupsList.get(i);
                ++i;
            }
            if (groups.length == 0) {
                this.rootNodes = new CPSMInputTreeViewerNode[1];
                this.rootNodes[0] = new CPSMInputTreeViewerNode(CPSMInputTreeViewerNode.Type.Dummy, null, null);
                return;
            }
            this.rootNodes = new CPSMInputTreeViewerNode[groups.length * 2 + 1];
            this.rootNodes[0] = new CPSMInputTreeViewerNode(CPSMInputTreeViewerNode.Type.Context, this.output.getContext(), null);
            this.rootNodes[0].setChecked(IAUtilities.hasContent((String)this.output.getContext()));
            i = 0;
            while (i < groups.length) {
                this.rootNodes[i * 2 + 1] = new CPSMInputTreeViewerNode(CPSMInputTreeViewerNode.Type.RemoveTrangrp, groups[i], null);
                this.rootNodes[i * 2 + 1].setChecked(groups[i].isDoRemove());
                this.rootNodes[i * 2 + 2] = new CPSMInputTreeViewerNode(CPSMInputTreeViewerNode.Type.CreateTrangrp, groups[i], null);
                this.rootNodes[i * 2 + 2].setChecked(groups[i].isDoCreate());
                this.rootNodes[i * 2 + 2].setData("OUTPUT", this.output);
                Transaction[] transactions = groups[i].getTransactions().toArray(new Transaction[0]);
                CPSMInputTreeViewerNode[] dtringroupNodes = new CPSMInputTreeViewerNode[transactions.length];
                this.rootNodes[i * 2 + 2].setChildNodes(dtringroupNodes);
                int j = 0;
                while (j < transactions.length) {
                    dtringroupNodes[j] = new CPSMInputTreeViewerNode(CPSMInputTreeViewerNode.Type.CreateDtringrp, transactions[j], this.rootNodes[i * 2 + 2]);
                    dtringroupNodes[j].setChecked(groups[i].getCreateTransaction(transactions[j]));
                    ++j;
                }
                ++i;
            }
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.rootNodes;
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children = ((CPSMInputTreeViewerNode)parentElement).getChildNodes();
        return children;
    }

    public Object getParent(Object element) {
        return ((CPSMInputTreeViewerNode)element).getParentNode();
    }

    public boolean hasChildren(Object element) {
        return ((CPSMInputTreeViewerNode)element).getChildNodes().length > 0;
    }
}

