/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.ia.model.AffinityBuilderOutput;
import com.ibm.cics.ia.model.BuiltAffGroup;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.ui.CPSMInputTreeViewerNode;
import com.ibm.cics.ia.ui.Messages;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

class CPSMInputCellLabelProvider
extends StyledCellLabelProvider {
    private static String CONTEXT = "CONTEXT ";
    private static String REMOVE_TRANGRP_NAME = "REMOVE TRANGRP NAME(";
    private static String CREATE_TRANGRP = "CREATE TRANGRP NAME(";
    private static String AFFINITY = ") AFFINITY(";
    private static String AFFLIFE = ") AFFLIFE(";
    private static String AFFAUTO = ") AFFAUTO(YES";
    private static String MATCH = ") MATCH(";
    private static String STATE = ") STATE(";
    private static String CREATE_DTRINGRP = "CREATE DTRINGRP TRANGRP(";
    private static String TRANID = ") TRANID(";
    private static Color hilightColor = new Color((Device)Display.getDefault(), 42, 0, 255);
    private static Color disabledColor = Display.getDefault().getSystemColor(33);

    CPSMInputCellLabelProvider() {
    }

    public void update(ViewerCell cell) {
        CPSMInputTreeViewerNode node = (CPSMInputTreeViewerNode)cell.getElement();
        if (node.getType().equals((Object)CPSMInputTreeViewerNode.Type.Dummy)) {
            cell.setText(Messages.getString("AffinityBuildEditor.TransactionGroups.Dummy.Text"));
        } else if (node.getType().equals((Object)CPSMInputTreeViewerNode.Type.Context)) {
            String context = (String)node.getData();
            if (!node.isChecked()) {
                String text = CONTEXT;
                cell.setText(text);
                StyleRange disabledRange = new StyleRange(0, text.length(), disabledColor, null);
                StyleRange[] ranges = new StyleRange[]{disabledRange};
                cell.setStyleRanges(ranges);
            } else {
                String text = String.valueOf(CONTEXT) + context + ";";
                cell.setText(text);
                StyleRange contextRange = new StyleRange(CONTEXT.length(), context.length(), hilightColor, null, 1);
                StyleRange[] ranges = new StyleRange[]{contextRange};
                cell.setStyleRanges(ranges);
            }
        } else if (node.getType().equals((Object)CPSMInputTreeViewerNode.Type.RemoveTrangrp)) {
            String trangroup = ((BuiltAffGroup)node.getData()).getTranGroup().toString();
            String text = String.valueOf(REMOVE_TRANGRP_NAME) + trangroup + "); ";
            cell.setText(text);
            if (!node.isChecked()) {
                StyleRange disabledRange = new StyleRange(0, text.length(), disabledColor, null);
                StyleRange[] ranges = new StyleRange[]{disabledRange};
                cell.setStyleRanges(ranges);
            } else {
                StyleRange trangroupRange = new StyleRange(REMOVE_TRANGRP_NAME.length(), trangroup.length(), hilightColor, null, 1);
                StyleRange[] ranges = new StyleRange[]{trangroupRange};
                cell.setStyleRanges(ranges);
            }
        } else if (node.getType().equals((Object)CPSMInputTreeViewerNode.Type.CreateTrangrp)) {
            BuiltAffGroup affGroup = (BuiltAffGroup)node.getData();
            AffinityBuilderOutput affinityBuilderOutput = (AffinityBuilderOutput)node.getData("OUTPUT");
            String affinity = affGroup.getAffinity().toString();
            String lifetime = affGroup.getLifetime().toString();
            String match = affGroup.getMatch();
            String state = affGroup.getState();
            String tranGroup = affGroup.getTranGroup();
            String text = String.valueOf(CREATE_TRANGRP) + tranGroup + AFFINITY + affinity + AFFLIFE + lifetime + AFFAUTO + MATCH + match + STATE + state + ");";
            cell.setText(text);
            if (!node.isChecked()) {
                StyleRange disabledRange = new StyleRange(0, text.length(), disabledColor, null);
                StyleRange[] ranges = new StyleRange[]{disabledRange};
                cell.setStyleRanges(ranges);
            } else {
                StyleRange affGroupStyleRange = new StyleRange(CREATE_TRANGRP.length(), tranGroup.length(), hilightColor, null, 1);
                StyleRange affinityStyleRange = new StyleRange(CREATE_TRANGRP.length() + tranGroup.length() + AFFINITY.length(), affinity.length(), hilightColor, null, 1);
                StyleRange lifetimeStyleRange = new StyleRange(CREATE_TRANGRP.length() + tranGroup.length() + AFFINITY.length() + affinity.length() + AFFLIFE.length(), lifetime.length(), hilightColor, null, 1);
                StyleRange matchStyleRange = new StyleRange(CREATE_TRANGRP.length() + tranGroup.length() + AFFINITY.length() + affinity.length() + AFFLIFE.length() + AFFAUTO.length() + lifetime.length() + MATCH.length(), match.length(), hilightColor, null, 1);
                StyleRange stateStyleRange = new StyleRange(CREATE_TRANGRP.length() + tranGroup.length() + AFFINITY.length() + affinity.length() + AFFLIFE.length() + AFFAUTO.length() + lifetime.length() + MATCH.length() + match.length() + STATE.length(), state.length(), hilightColor, null, 1);
                StyleRange[] ranges = new StyleRange[]{affGroupStyleRange, affinityStyleRange, lifetimeStyleRange, matchStyleRange, stateStyleRange};
                cell.setStyleRanges(ranges);
            }
        } else if (node.getType().equals((Object)CPSMInputTreeViewerNode.Type.CreateDtringrp)) {
            BuiltAffGroup affGroup = (BuiltAffGroup)node.getParentNode().getData();
            Transaction transaction = (Transaction)node.getData();
            String tranGroup = affGroup.getTranGroup();
            String transactionName = transaction.getName();
            String text = String.valueOf(CREATE_DTRINGRP) + tranGroup + TRANID + transactionName + ");";
            cell.setText(text);
            if (!node.isChecked()) {
                StyleRange disabledRange = new StyleRange(0, text.length(), disabledColor, null);
                StyleRange[] ranges = new StyleRange[]{disabledRange};
                cell.setStyleRanges(ranges);
            } else {
                StyleRange dtringrpStyleRange = new StyleRange(CREATE_DTRINGRP.length(), tranGroup.length(), hilightColor, null, 1);
                StyleRange transactionStyleRange = new StyleRange(CREATE_DTRINGRP.length() + tranGroup.length() + TRANID.length(), transactionName.length(), hilightColor, null, 1);
                StyleRange[] ranges = new StyleRange[]{dtringrpStyleRange, transactionStyleRange};
                cell.setStyleRanges(ranges);
            }
        }
        super.update(cell);
    }
}

