/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.ia.model.AffinityBuilderOutput;
import com.ibm.cics.ia.model.BuiltAffGroup;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.ui.BuildTreeViewerNode;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

class BuilderTreeContentProvider
implements ITreeContentProvider {
    private AffinityBuilderOutput output;
    BuildTreeViewerNode[] rootNodes = new BuildTreeViewerNode[0];

    BuilderTreeContentProvider() {
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof AffinityBuilderOutput) {
            this.output = (AffinityBuilderOutput)newInput;
            List groupsList = this.output.getAffinityGroups();
            BuiltAffGroup[] groups = new BuiltAffGroup[groupsList.size()];
            int i = 0;
            while (i < groupsList.size()) {
                groups[i] = (BuiltAffGroup)groupsList.get(i);
                ++i;
            }
            if (groups.length == 0) {
                this.rootNodes = new BuildTreeViewerNode[1];
                this.rootNodes[0] = new BuildTreeViewerNode(BuildTreeViewerNode.Type.Dummy, null, null);
                return;
            }
            this.rootNodes = new BuildTreeViewerNode[groups.length];
            i = 0;
            while (i < groups.length) {
                this.rootNodes[i] = new BuildTreeViewerNode(BuildTreeViewerNode.Type.Group, groups[i], null);
                Transaction[] transactions = groups[i].getTransactions().toArray(new Transaction[0]);
                String[] merges = groups[i].getDerivedFrom().keySet().toArray(new String[0]);
                BuildTreeViewerNode[] rootNodeChildren = new BuildTreeViewerNode[6];
                this.rootNodes[i].setChildNodes(rootNodeChildren);
                rootNodeChildren[0] = new BuildTreeViewerNode(BuildTreeViewerNode.Type.Affinity, groups[i].getAffinity(), this.rootNodes[i]);
                rootNodeChildren[1] = new BuildTreeViewerNode(BuildTreeViewerNode.Type.Lifetime, groups[i].getLifetime(), this.rootNodes[i]);
                rootNodeChildren[2] = new BuildTreeViewerNode(BuildTreeViewerNode.Type.Match, groups[i].getMatch(), this.rootNodes[i]);
                rootNodeChildren[3] = new BuildTreeViewerNode(BuildTreeViewerNode.Type.State, groups[i].getState(), this.rootNodes[i]);
                rootNodeChildren[4] = new BuildTreeViewerNode(BuildTreeViewerNode.Type.Transactions, transactions, this.rootNodes[i]);
                BuildTreeViewerNode[] transactionNodes = new BuildTreeViewerNode[transactions.length];
                rootNodeChildren[4].setChildNodes(transactionNodes);
                rootNodeChildren[5] = new BuildTreeViewerNode(BuildTreeViewerNode.Type.Merges, groups[i].getDerivedFrom(), this.rootNodes[i]);
                BuildTreeViewerNode[] mergedReportsNodes = new BuildTreeViewerNode[merges.length];
                rootNodeChildren[5].setChildNodes(mergedReportsNodes);
                int j = 0;
                while (j < transactions.length) {
                    transactionNodes[j] = new BuildTreeViewerNode(BuildTreeViewerNode.Type.Transaction, transactions[j], rootNodeChildren[4]);
                    ++j;
                }
                j = 0;
                while (j < merges.length) {
                    mergedReportsNodes[j] = new BuildTreeViewerNode(BuildTreeViewerNode.Type.MergedReport, merges[j], rootNodeChildren[5]);
                    List mergedGroups = (List)groups[i].getDerivedFrom().get(merges[j]);
                    BuildTreeViewerNode[] mergedGroupNodes = new BuildTreeViewerNode[mergedGroups.size()];
                    mergedReportsNodes[j].setChildNodes(mergedGroupNodes);
                    int k = 0;
                    while (k < mergedGroups.size()) {
                        mergedGroupNodes[k] = new BuildTreeViewerNode(BuildTreeViewerNode.Type.MergedGroup, mergedGroups.get(k), mergedReportsNodes[j]);
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.rootNodes;
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children = ((BuildTreeViewerNode)parentElement).getChildNodes();
        return children;
    }

    public Object getParent(Object element) {
        return ((BuildTreeViewerNode)element).getParentNode();
    }

    public boolean hasChildren(Object element) {
        return ((BuildTreeViewerNode)element).getChildNodes().length > 0;
    }
}

