/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.eclipse.common.editor.EditorHelper;
import com.ibm.cics.ia.ui.BuildAffinityReportsWizard;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.ReportManager;
import com.ibm.cics.ia.ui.UIUtilities;
import com.ibm.cics.ia.ui.actions.Messages;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class BuildAffinityReportsSelectionPage
extends WizardPage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2013, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private BuildAffinityReportsWizard wizard;
    private static final String PAGE_NAME = "BUILD_REPORTS_SELECTION";
    private static final Logger logger = Logger.getLogger(BuildAffinityReportsSelectionPage.class.getPackage().getName());
    private Tree tree;
    private Text newFileText;
    private IContainer container = null;
    private String fileName = null;
    private ReportManager reportManager;
    private ArrayList<IResource> resources = new ArrayList();

    protected BuildAffinityReportsSelectionPage(BuildAffinityReportsWizard wizard, ArrayList<IResource> resources) {
        super(PAGE_NAME);
        this.wizard = wizard;
        this.resources = resources;
        this.setTitle(Messages.getString("BuildReportsWizard.Selection.title"));
        this.setDescription(Messages.getString("BuildReportsWizard.Selection.description"));
        this.setImageDescriptor(ImageDescriptor.createFromImage((Image)ImageFactory.getBuilderWizardImage()));
    }

    public void createControl(Composite parent) {
        Debug.enter((Logger)logger, (String)BuildAffinityReportsSelectionPage.class.getName(), (String)"createControl", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(6, false);
        gridLayout.marginLeft = 10;
        gridLayout.marginRight = 10;
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)gridLayout);
        Label reportsLabel = new Label(composite, 0);
        reportsLabel.setText(Messages.getString("BuildReportsWizard.Selection.Label.Reports"));
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 6;
        reportsLabel.setLayoutData((Object)gridData);
        FormToolkit toolkit = EditorHelper.getFormToolkit();
        this.tree = new Tree(composite, 2080);
        this.reportManager = ReportManager.createReportManager(ReportManager.Type.affinityFilesAndFolders);
        this.reportManager.setTree(this.tree);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 6;
        gridData.heightHint = 350;
        this.tree.setLayoutData((Object)gridData);
        this.tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem item;
                if (e.detail == 32 && (item = (TreeItem)e.item) != null) {
                    BuildAffinityReportsSelectionPage.this.setCheckedRecursively(item, item.getChecked());
                    if (item.getChecked()) {
                        while (item.getParentItem() != null) {
                            boolean allSiblingsSelected = true;
                            TreeItem[] treeItemArray = item.getParentItem().getItems();
                            int n = treeItemArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TreeItem sibling = treeItemArray[n2];
                                if (!(allSiblingsSelected &= sibling.getChecked())) break;
                                ++n2;
                            }
                            if (!allSiblingsSelected) break;
                            item.getParentItem().setChecked(true);
                            item = item.getParentItem();
                        }
                    }
                    BuildAffinityReportsSelectionPage.this.setPageComplete(BuildAffinityReportsSelectionPage.this.canFlipToNextPage());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label contextLabel = new Label(composite, 0);
        contextLabel.setText(Messages.getString("BuildReportsWizard.Selection.Label.Context"));
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 1;
        contextLabel.setLayoutData((Object)gridData);
        final Text contextText = new Text(composite, 2048);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 1;
        contextText.setLayoutData((Object)gridData);
        contextText.setTextLimit(8);
        contextText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (contextText.getText().length() > 0) {
                    BuildAffinityReportsSelectionPage.this.wizard.setContext(contextText.getText());
                    BuildAffinityReportsSelectionPage.this.setPageComplete(BuildAffinityReportsSelectionPage.this.canFlipToNextPage());
                } else {
                    BuildAffinityReportsSelectionPage.this.wizard.setContext("");
                    BuildAffinityReportsSelectionPage.this.setPageComplete(BuildAffinityReportsSelectionPage.this.canFlipToNextPage());
                }
            }
        });
        Group matchGroup = new Group(composite, 16);
        matchGroup.setText(Messages.getString("BuildReportsWizard.Selection.Label.Match"));
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        matchGroup.setLayoutData((Object)gridData);
        matchGroup.setLayout((Layout)new GridLayout(2, false));
        Button lunameButton = new Button((Composite)matchGroup, 16);
        lunameButton.setText(Match.LUNAME.toString());
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalAlignment = 16384;
        gridData.horizontalSpan = 1;
        lunameButton.setLayoutData((Object)gridData);
        lunameButton.setSelection(true);
        this.wizard.setMatch(Match.LUNAME.toString());
        lunameButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                BuildAffinityReportsSelectionPage.this.wizard.setMatch(Match.LUNAME.toString());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button useridButton = new Button((Composite)matchGroup, 16);
        useridButton.setText(Match.USERID.toString());
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalAlignment = 16384;
        gridData.horizontalSpan = 1;
        useridButton.setLayoutData((Object)gridData);
        useridButton.setSelection(false);
        useridButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                BuildAffinityReportsSelectionPage.this.wizard.setMatch(Match.USERID.toString());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Group stateGroup = new Group(composite, 16);
        stateGroup.setText(Messages.getString("BuildReportsWizard.Selection.Label.State"));
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        stateGroup.setLayoutData((Object)gridData);
        stateGroup.setLayout((Layout)new GridLayout(2, false));
        Button activeButton = new Button((Composite)stateGroup, 16);
        activeButton.setText(State.ACTIVE.toString());
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalAlignment = 16384;
        gridData.horizontalSpan = 1;
        activeButton.setLayoutData((Object)gridData);
        activeButton.setSelection(true);
        this.wizard.setState(State.ACTIVE.toString());
        activeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                BuildAffinityReportsSelectionPage.this.wizard.setState(State.ACTIVE.toString());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button dormantButton = new Button((Composite)stateGroup, 16);
        dormantButton.setText(State.DORMANT.toString());
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalAlignment = 16384;
        gridData.horizontalSpan = 1;
        dormantButton.setLayoutData((Object)gridData);
        dormantButton.setSelection(false);
        dormantButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                BuildAffinityReportsSelectionPage.this.wizard.setState(State.DORMANT.toString());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.refresh();
        ArrayList<IResource> resourcesCopy = new ArrayList<IResource>(this.resources);
        for (IResource resource : resourcesCopy) {
            TreeItem treeItem = this.reportManager.getTreeItem(resource);
            if (treeItem == null) continue;
            this.setCheckedRecursively(treeItem, true);
        }
        this.setControl((Control)composite);
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)parent, "com.ibm.cics.ia.help.affinity_build_wizard");
        Debug.exit((Logger)logger, (String)BuildAffinityReportsSelectionPage.class.getName(), (String)"createControl", (Object)("Thread ID: " + Thread.currentThread().getId()));
    }

    private void setCheckedRecursively(TreeItem item, boolean checked) {
        item.setChecked(checked);
        IResource resource = (IResource)item.getData("IRESOURCE");
        if (checked && resource instanceof IFile && !this.resources.contains(resource)) {
            this.resources.add(resource);
        } else if (!checked && resource instanceof IFile && this.resources.contains(resource)) {
            this.resources.remove(resource);
        }
        TreeItem[] treeItemArray = item.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem child = treeItemArray[n2];
            this.setCheckedRecursively(child, checked);
            ++n2;
        }
    }

    private void refresh() {
        this.tree.removeAll();
        this.reportManager.refresh();
        UIUtilities.expandTree(this.tree, true);
    }

    private IContainer getCurrentContainer() {
        Debug.enter((Logger)logger, (String)BuildAffinityReportsSelectionPage.class.getName(), (String)"getCurrentContainer", (Object)("Thread ID: " + Thread.currentThread().getId()));
        TreeItem[] items = this.tree.getSelection();
        if (items.length == 0) {
            return (IContainer)this.tree.getData("IRESOURCE");
        }
        TreeItem item = items[0];
        IResource resource = (IResource)item.getData("IRESOURCE");
        Debug.exit((Logger)logger, (String)BuildAffinityReportsSelectionPage.class.getName(), (String)"getCurrentContainer", (Object)("Thread ID: " + Thread.currentThread().getId()));
        return resource instanceof IFolder ? (IContainer)resource : resource.getParent();
    }

    public boolean canFlipToNextPage() {
        boolean can = this.resources.size() > 0;
        return can;
    }

    public void dispose() {
        ReportManager.removeReportManager(this.reportManager);
        super.dispose();
    }

    private static enum Match {
        LUNAME,
        USERID;

    }

    private static enum State {
        ACTIVE,
        DORMANT;

    }
}

