/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.eclipse.common.ui.TextInput;
import com.ibm.cics.ia.commands.GetApplicationInfoCommand;
import com.ibm.cics.ia.ui.TreeContentProvider;
import com.ibm.cics.ia.ui.TreeLabelProvider;
import com.ibm.cics.ia.ui.TreeNodeFilter;
import com.ibm.cics.ia.ui.composites.Messages;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;

public class ApplicationSelectionDialog
extends TrayDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ApplicationSelectionDialog.class.getPackage().getName());
    private final String title = Messages.getString("CollectorOptionsEditor.ApplicationSelectionDialog.title");
    private TreeViewer viewer;
    private Button okButton;
    private final List<GetApplicationInfoCommand.ApplicationInfo> applications;
    private GetApplicationInfoCommand.ApplicationInfo selected;

    public ApplicationSelectionDialog(Shell shell, List<GetApplicationInfoCommand.ApplicationInfo> applications) {
        super(shell);
        this.applications = applications;
    }

    protected Control createDialogArea(Composite parent) {
        Debug.enter((Logger)logger, (String)ApplicationSelectionDialog.class.getName(), (String)"createDialogArea", (Object)("Thread ID: " + Thread.currentThread().getId()));
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        final Text searchText = new Text(parent, 2176);
        searchText.setToolTipText(Messages.getString("CollectorOptionsEditor.ApplicationSelection.SearchBox.Tooltip"));
        TextInput.setAccessibleLabel((Text)searchText, (String)searchText.getToolTipText());
        searchText.setLayoutData((Object)new GridData(768));
        this.createViewer(parent);
        final TreeNodeFilter filter = new TreeNodeFilter();
        searchText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                filter.setSearchText(searchText.getText());
                ApplicationSelectionDialog.this.viewer.refresh();
                ApplicationSelectionDialog.this.viewer.expandAll();
                if (ApplicationSelectionDialog.this.viewer.getTree().getSelection().length == 0) {
                    ApplicationSelectionDialog.this.okButton.setEnabled(false);
                }
            }
        });
        this.viewer.addFilter((ViewerFilter)filter);
        Debug.exit((Logger)logger, (String)ApplicationSelectionDialog.class.getName(), (String)"createDialogArea");
        return parent;
    }

    private void resizeAndMoveToCenter(Shell shell) {
        Debug.enter((Logger)logger, (String)ApplicationSelectionDialog.class.getName(), (String)"resizeAndMoveToCenter", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Rectangle monitorArea = shell.getDisplay().getPrimaryMonitor().getBounds();
        shell.setSize(monitorArea.width / 3, monitorArea.height / 2);
        Rectangle shellArea = shell.getBounds();
        int x = monitorArea.x + (monitorArea.width - shellArea.width) / 2;
        int y = monitorArea.y + (monitorArea.height - shellArea.height) / 2;
        shell.setLocation(x, y);
        Debug.exit((Logger)logger, (String)ApplicationSelectionDialog.class.getName(), (String)"enclosing_method");
    }

    private void createViewer(Composite parent) {
        Debug.enter((Logger)logger, (String)ApplicationSelectionDialog.class.getName(), (String)"createViewer", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.viewer = new TreeViewer(parent, 68356);
        this.viewer.getTree().addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TreeItem item = (TreeItem)e.item;
                if (item.getItemCount() == 0) {
                    ApplicationSelectionDialog.this.viewer.getTree().select(item);
                    ApplicationSelectionDialog.this.processSelection();
                } else {
                    ApplicationSelectionDialog.this.viewer.getTree().deselect(item);
                    ApplicationSelectionDialog.this.okButton.setEnabled(false);
                }
            }
        });
        this.viewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.viewer.setUseHashlookup(true);
        this.viewer.setInput(this.applications);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        this.viewer.getControl().setLayoutData((Object)gridData);
        Debug.exit((Logger)logger, (String)ApplicationSelectionDialog.class.getName(), (String)"enclosing_method");
    }

    private void processSelection() {
        Debug.enter((Logger)logger, (String)ApplicationSelectionDialog.class.getName(), (String)"processSelection", (Object)("Thread ID: " + Thread.currentThread().getId()));
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        this.selected = (GetApplicationInfoCommand.ApplicationInfo)sel.getFirstElement();
        this.okButton.setEnabled(true);
        Debug.exit((Logger)logger, (String)ApplicationSelectionDialog.class.getName(), (String)"enclosing_method");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Debug.enter((Logger)logger, (String)ApplicationSelectionDialog.class.getName(), (String)"createButtonsForButtonBar", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        Debug.exit((Logger)logger, (String)ApplicationSelectionDialog.class.getName(), (String)"enclosing_method");
    }

    public GetApplicationInfoCommand.ApplicationInfo getSelected() {
        return this.selected;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
        this.resizeAndMoveToCenter(shell);
    }

    protected boolean isResizable() {
        return true;
    }
}

