/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.AffinityReport;
import com.ibm.cics.ia.ui.AffinityReportEditor;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.TrangroupTreeCellLabelProvider;
import com.ibm.cics.ia.ui.TrangroupTreeContentProvider;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class AffinityReportTrangroupsEditorPage
extends FormPage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private AffinityReportEditor editor;
    private AffinityReport report;
    private Tree trangroupTree;
    private TreeViewer trangroupViewer;
    private TrangroupTreeContentProvider treeContentProvider;
    private TrangroupTreeCellLabelProvider treeCellLabelProvider;
    private static final Logger logger = Logger.getLogger(AffinityReportTrangroupsEditorPage.class.getPackage().getName());

    public AffinityReportTrangroupsEditorPage(FormEditor editor, AffinityReport report) {
        super(editor, "com.ibm.cics.ia.affinity.report.trangroups.page", Messages.getString("AffinityReportEditor.TransactionGroups.Title"));
        this.editor = (AffinityReportEditor)editor;
        this.report = report;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        IWorkbenchHelpSystem helpSystem = this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)parent, "com.ibm.cics.ia.help.affinity_report_editor");
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        Debug.enter((Logger)logger, (String)AffinityReportTrangroupsEditorPage.class.getName(), (String)"createFormContent", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Form form = managedForm.getForm().getForm();
        form.setText(Messages.getString("AffinityReportEditor.TransactionGroups.Title"));
        form.setImage(this.getEditor().getTitleImage());
        managedForm.getToolkit().decorateFormHeading(form);
        Composite parent = form.getBody();
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 6;
        layout.marginHeight = 12;
        parent.setLayout((Layout)layout);
        GridData trangroupData = new GridData(1808);
        trangroupData.horizontalSpan = 1;
        Section trangroupSection = toolkit.createSection(parent, 256);
        trangroupSection.setText(Messages.getString("AffinityReportEditor.TransactionGroups.TrangroupSection.Text"));
        trangroupSection.setLayoutData((Object)trangroupData);
        Composite trangroupClient = toolkit.createComposite((Composite)trangroupSection, 64);
        trangroupClient.setLayout((Layout)layout);
        GridData trangroupChildrenData = new GridData(1808);
        this.trangroupTree = toolkit.createTree(trangroupClient, 2048);
        this.trangroupTree.setLayoutData((Object)trangroupChildrenData);
        this.trangroupViewer = new TreeViewer(this.trangroupTree);
        this.treeContentProvider = new TrangroupTreeContentProvider();
        this.trangroupViewer.setContentProvider((IContentProvider)this.treeContentProvider);
        this.treeCellLabelProvider = new TrangroupTreeCellLabelProvider();
        this.trangroupViewer.setLabelProvider((IBaseLabelProvider)this.treeCellLabelProvider);
        trangroupSection.setClient((Control)trangroupClient);
        this.refresh();
        Debug.exit((Logger)logger, (String)AffinityReportTrangroupsEditorPage.class.getName(), (String)"createFormContent", (Object)("Thread ID: " + Thread.currentThread().getId()));
    }

    private void refresh() {
        this.trangroupViewer.setInput((Object)this.report);
        this.trangroupViewer.expandAll();
        TreeColumn[] treeColumnArray = this.trangroupTree.getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            column.pack();
            ++n2;
        }
    }
}

