/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.AffCommand;
import com.ibm.cics.ia.model.AffGroup;
import com.ibm.cics.ia.model.AffinityReport;
import com.ibm.cics.ia.model.AffinityType;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.AffinityReportEditor;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.ResourceRenderer;
import com.ibm.cics.ia.ui.ResourceTypeRenderer;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class AffinityReportOverviewEditorPage
extends FormPage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private AffinityReportEditor editor;
    private AffinityReport report;
    private Tree trangroupTree;
    private Table commandsTable;
    private SashForm trangroupSash;
    private static final Logger logger = Logger.getLogger(AffinityReportOverviewEditorPage.class.getPackage().getName());

    public AffinityReportOverviewEditorPage(FormEditor editor, AffinityReport report) {
        super(editor, "com.ibm.cics.ia.affinity.report.overview.page", Messages.getString("AffinityReportEditor.Overview.Title"));
        this.editor = (AffinityReportEditor)editor;
        this.report = report;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        IWorkbenchHelpSystem helpSystem = this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)parent, "com.ibm.cics.ia.help.affinity_report_editor");
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        Debug.enter((Logger)logger, (String)AffinityReportOverviewEditorPage.class.getName(), (String)"createFormContent", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId()});
        Form form = managedForm.getForm().getForm();
        form.setText(Messages.getString("AffinityReportEditor.Overview.Title"));
        form.setImage(this.getEditor().getTitleImage());
        managedForm.getToolkit().decorateFormHeading(form);
        Composite parent = form.getBody();
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 6;
        layout.marginHeight = 12;
        parent.setLayout((Layout)layout);
        GridData headerData = new GridData(768);
        headerData.horizontalSpan = 2;
        Section headerSection = toolkit.createSection(parent, 384);
        headerSection.setText(Messages.getString("AffinityReportEditor.Overview.General.Section.Text"));
        headerSection.setDescription(Messages.getString("AffinityReportEditor.Overview.General.Section.Description"));
        headerSection.setLayoutData((Object)headerData);
        layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginWidth = 3;
        layout.marginHeight = 3;
        Composite headerClient = toolkit.createComposite((Composite)headerSection, 64);
        headerClient.setLayout((Layout)layout);
        GridData headerChildrenData = new GridData(16384, 128, false, false);
        Label regionLabel = new Label(headerClient, 0);
        regionLabel.setText(Messages.getString("AffinityReportEditor.Overview.General.Region.Label"));
        regionLabel.setLayoutData((Object)headerChildrenData);
        headerChildrenData = new GridData(4, 128, true, false);
        Text regionText = new Text(headerClient, 2048);
        regionText.setText(this.report.getRegion().getName());
        regionText.setLayoutData((Object)headerChildrenData);
        regionText.setEnabled(false);
        headerChildrenData = new GridData(16384, 128, false, false);
        Label dateLabel = new Label(headerClient, 0);
        dateLabel.setText(Messages.getString("AffinityReportEditor.Overview.General.Date.Label"));
        dateLabel.setLayoutData((Object)headerChildrenData);
        headerChildrenData = new GridData(4, 128, true, false);
        Text dateText = new Text(headerClient, 2048);
        dateText.setText(AffinityReport.DATE_FORMAT.format(this.report.getGenerationDate()));
        dateText.setLayoutData((Object)headerChildrenData);
        dateText.setEnabled(false);
        headerChildrenData = new GridData(16384, 128, false, false);
        Label descriptionLabel = new Label(headerClient, 0);
        descriptionLabel.setText(Messages.getString("AffinityReportEditor.Overview.General.Description.Label"));
        descriptionLabel.setLayoutData((Object)headerChildrenData);
        headerChildrenData = new GridData(4, 128, true, false);
        headerChildrenData.horizontalSpan = 3;
        headerChildrenData.heightHint = 75;
        final Text descriptionText = new Text(headerClient, 2562);
        descriptionText.setText(this.report.getDescription());
        descriptionText.setLayoutData((Object)headerChildrenData);
        descriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AffinityReportOverviewEditorPage.this.editor.setReportDescription(descriptionText.getText());
            }
        });
        headerSection.setClient((Control)headerClient);
        GridData sashData = new GridData(1808);
        sashData.grabExcessHorizontalSpace = true;
        sashData.grabExcessVerticalSpace = true;
        sashData.horizontalSpan = 1;
        this.trangroupSash = new SashForm(parent, 256);
        this.trangroupSash.setLayoutData((Object)sashData);
        GridData trangroupData = new GridData(1808);
        trangroupData.grabExcessHorizontalSpace = true;
        trangroupData.grabExcessVerticalSpace = false;
        trangroupData.horizontalSpan = 1;
        Section trangroupSection = toolkit.createSection((Composite)this.trangroupSash, 256);
        trangroupSection.setText(Messages.getString("AffinityReportEditor.Overview.Trangroups.Section.Text"));
        trangroupSection.setLayoutData((Object)trangroupData);
        Composite trangroupClient = toolkit.createComposite((Composite)trangroupSection, 64);
        trangroupClient.setLayout((Layout)layout);
        this.trangroupTree = toolkit.createTree(trangroupClient, 68352);
        this.trangroupTree.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).hint(100, 100).create());
        this.trangroupTree.getHorizontalBar().setVisible(true);
        this.trangroupTree.setHeaderVisible(true);
        TreeColumn nameColumn = new TreeColumn(this.trangroupTree, 16384);
        nameColumn.setText(Messages.getString("AffinityReportEditor.Overview.TrangroupTree.Column.Name"));
        nameColumn.pack();
        TreeColumn affinityColumn = new TreeColumn(this.trangroupTree, 16384);
        affinityColumn.setText(Messages.getString("AffinityReportEditor.Overview.TrangroupTree.Column.Affinity"));
        affinityColumn.pack();
        TreeColumn lifetimeColumn = new TreeColumn(this.trangroupTree, 16384);
        lifetimeColumn.setText(Messages.getString("AffinityReportEditor.Overview.TrangroupTree.Column.Lifetime"));
        lifetimeColumn.pack();
        TreeColumn resourceColumn = new TreeColumn(this.trangroupTree, 16384);
        resourceColumn.setText(Messages.getString("AffinityReportEditor.Overview.TrangroupTree.Column.Resource"));
        resourceColumn.pack();
        this.trangroupTree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] selection = AffinityReportOverviewEditorPage.this.trangroupTree.getSelection();
                if (selection.length == 1 && selection[0].getData() instanceof AffGroup) {
                    AffGroup affGroup = (AffGroup)selection[0].getData();
                    AffinityReportOverviewEditorPage.this.refreshCommands(affGroup);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        trangroupSection.setClient((Control)trangroupClient);
        GridData commandsData = new GridData(1808);
        commandsData.horizontalSpan = 1;
        Section commandsSection = toolkit.createSection((Composite)this.trangroupSash, 256);
        commandsSection.setText(Messages.getString("AffinityReportEditor.Overview.Commands.Section.Text"));
        commandsSection.setLayoutData((Object)commandsData);
        Composite commandsClient = toolkit.createComposite((Composite)commandsSection, 64);
        commandsClient.setLayout((Layout)layout);
        this.commandsTable = toolkit.createTable(commandsClient, 68352);
        this.commandsTable.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).hint(100, 100).create());
        this.commandsTable.getHorizontalBar().setVisible(true);
        this.commandsTable.setHeaderVisible(true);
        TableColumn transactionColumn = new TableColumn(this.commandsTable, 16384);
        transactionColumn.setText(Messages.getString("AffinityReportEditor.Overview.CommandsTable.Column.Transaction"));
        transactionColumn.pack();
        TableColumn programColumn = new TableColumn(this.commandsTable, 16384);
        programColumn.setText(Messages.getString("AffinityReportEditor.Overview.CommandsTable.Column.Program"));
        programColumn.pack();
        TableColumn commandColumn = new TableColumn(this.commandsTable, 16384);
        commandColumn.setText(Messages.getString("AffinityReportEditor.Overview.CommandsTable.Column.Command"));
        commandColumn.pack();
        TableColumn offsetColumn = new TableColumn(this.commandsTable, 16384);
        offsetColumn.setText(Messages.getString("AffinityReportEditor.Overview.CommandsTable.Column.Offset"));
        offsetColumn.pack();
        TableColumn typeColumn = new TableColumn(this.commandsTable, 16384);
        typeColumn.setText(Messages.getString("AffinityReportEditor.Overview.CommandsTable.Column.Type"));
        typeColumn.pack();
        TableColumn usecountColumn = new TableColumn(this.commandsTable, 16384);
        usecountColumn.setText(Messages.getString("AffinityReportEditor.Overview.CommandsTable.Column.Usecount"));
        usecountColumn.pack();
        TableColumn terminalColumn = new TableColumn(this.commandsTable, 16384);
        terminalColumn.setText(Messages.getString("AffinityReportEditor.Overview.CommandsTable.Column.Terminal"));
        terminalColumn.pack();
        TableColumn btsColumn = new TableColumn(this.commandsTable, 16384);
        btsColumn.setText(Messages.getString("AffinityReportEditor.Overview.CommandsTable.Column.BTS"));
        btsColumn.pack();
        TableColumn link3270Column = new TableColumn(this.commandsTable, 16384);
        link3270Column.setText(Messages.getString("AffinityReportEditor.Overview.CommandsTable.Column.Link3270"));
        link3270Column.pack();
        TableColumn[] tableColumnArray = this.commandsTable.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.pack();
            ++n2;
        }
        commandsSection.setClient((Control)commandsClient);
        this.refresh();
        Debug.exit((Logger)logger, (String)AffinityReportOverviewEditorPage.class.getName(), (String)"createFormContent", (Object)("Thread ID: " + Thread.currentThread().getId()));
    }

    private void refresh() {
        Debug.enter((Logger)logger, (String)AffinityReportOverviewEditorPage.class.getName(), (String)"refresh", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.trangroupTree.removeAll();
        List types = this.report.getAffinityTypes();
        for (AffinityType affinityType : types) {
            TreeItem affinityTypeItem = new TreeItem(this.trangroupTree, 0);
            affinityTypeItem.setText(affinityType.getName());
            affinityTypeItem.setData((Object)affinityType);
            this.trangroupTree.setData(affinityType.toString(), (Object)affinityTypeItem);
            List affGroups = this.report.getAffinityGroups(affinityType);
            for (AffGroup affGroup : affGroups) {
                TreeItem affinityGroupItem = new TreeItem(affinityTypeItem, 0);
                String[] strings = new String[4];
                strings[0] = affGroup.getTranGroup();
                strings[1] = affGroup.getAffinity().toString().trim();
                strings[2] = affGroup.getLifetime().toString().trim();
                if (IAUtilities.hasContent((String)affGroup.getType()) && IAUtilities.hasContent((String)affGroup.getResourceName())) {
                    Resource resource = ResourceFactory.getSingleton().getResource(affGroup.getType().trim(), affGroup.getResourceName().trim());
                    strings[3] = String.valueOf(ResourceTypeRenderer.asText(resource.getTypeName())) + " (" + ResourceRenderer.asText(resource) + ")";
                    affinityGroupItem.setImage(3, ResourceRenderer.asImage(resource));
                }
                affinityGroupItem.setText(strings);
                affinityGroupItem.setData((Object)affGroup);
            }
        }
        TreeColumn[] treeColumnArray = this.trangroupTree.getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            column.pack();
            ++n2;
        }
        Debug.exit((Logger)logger, (String)AffinityReportOverviewEditorPage.class.getName(), (String)"refresh", (Object)("Thread ID: " + Thread.currentThread().getId()));
    }

    private void refreshCommands(AffGroup affGroup) {
        Debug.enter((Logger)logger, (String)AffinityReportOverviewEditorPage.class.getName(), (String)"refreshCommands", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "region: " + affGroup.getRegionName(), "resource: " + affGroup.getResourceName()});
        this.commandsTable.removeAll();
        List affCommands = affGroup.getAffCommands();
        for (AffCommand affCommand : affCommands) {
            String[] strings = new String[]{affCommand.getTransactionName(), affCommand.getProgramName(), affCommand.getCommand(), affCommand.getOffset(), affCommand.getResType(), affCommand.getUsage(), affCommand.getTerminal(), affCommand.getBTS(), affCommand.getLink3270()};
            TableItem item = new TableItem(this.commandsTable, 0);
            item.setText(strings);
            item.setImage(0, ImageFactory.getTransactionImage());
            item.setImage(1, ImageFactory.getProgramImage());
            item.setImage(2, ImageFactory.getVerbImage());
        }
        Debug.exit((Logger)logger, (String)AffinityReportOverviewEditorPage.class.getName(), (String)"refreshCommands", (Object)("Thread ID: " + Thread.currentThread().getId()));
    }
}

