/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.AffinityBuilderOutput;
import com.ibm.cics.ia.ui.AffinityBuildEditor;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.zos.ui.ZOSActivator;
import com.ibm.cics.zos.ui.editor.jcl.ColorManager;
import com.ibm.cics.zos.ui.editor.jcl.JCLConfiguration;
import com.ibm.cics.zos.ui.editor.jcl.JCLPartitionTokenScanner;
import com.ibm.cics.zos.ui.editor.jcl.JCLUtilities;
import com.ibm.cics.zos.ui.editor.jcl.JCLValidator;
import com.ibm.cics.zos.ui.editor.jcl.Validator;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextViewerExtension8;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledTextPrintOptions;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class AffinityBuildJCLPage
extends TextEditor
implements IDocumentListener,
IFormPage,
IEclipsePreferences.IPreferenceChangeListener {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2011, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(AffinityBuildJCLPage.class.getPackage().getName());
    private IDocument document;
    private SourceViewerConfiguration configuration;
    private JCLPartitionTokenScanner partitions;
    private Map<String, Validator> validators = new HashMap<String, Validator>();
    private FormEditor parentEditor;
    private boolean isActive;
    private int index;
    private Composite parent;

    public AffinityBuildJCLPage(SourceViewerConfiguration configuration, JCLPartitionTokenScanner partitions) {
        this();
        this.configuration = configuration;
        this.partitions = partitions;
    }

    public AffinityBuildJCLPage() {
        this.validators.put("JCL_tag", (Validator)new JCLValidator());
    }

    public void addValidator(String tag, Validator validator) {
        this.validators.put(tag, validator);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        Debug.enter((Logger)logger, (String)AffinityBuildJCLPage.class.getName(), (String)"init", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "site id: " + site.getId(), "input: " + input.getName()});
        super.init(site, input);
        this.setSourceViewerConfiguration(this.getConfiguration());
        FileDocumentProvider provider = new FileDocumentProvider(){

            protected IDocument createDocument(Object element) {
                Document document1 = null;
                try {
                    FileEditorInput input = (FileEditorInput)element;
                    IFile iFile = input.getFile();
                    File file = new File(iFile.getLocation().toOSString());
                    if (file.exists()) {
                        AffinityBuilderOutput output = AffinityBuilderOutput.parse((File)file);
                        document1 = new Document(output.getJcl());
                    } else {
                        document1 = new Document();
                    }
                    FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)AffinityBuildJCLPage.this.getPartitionScanner(), AffinityBuildJCLPage.this.getConfiguration().getConfiguredContentTypes(AffinityBuildJCLPage.this.getSourceViewer()));
                    partitioner.connect((IDocument)document1);
                    document1.setDocumentPartitioner((IDocumentPartitioner)partitioner);
                }
                catch (Exception e) {
                    Debug.warning((Logger)logger, (String)AffinityBuildJCLPage.class.getName(), (String)"init create document", (String)"empty catch", (Throwable)e);
                }
                return document1;
            }
        };
        this.setDocumentProvider((IDocumentProvider)provider);
        try {
            provider.connect((Object)input);
        }
        catch (CoreException e) {
            Debug.warning((Logger)logger, (String)AffinityBuildJCLPage.class.getName(), (String)"init", (String)"return from method", (Throwable)e);
            Debug.exit((Logger)logger, (String)AffinityBuildJCLPage.class.getName(), (String)"init", (Object)("Thread ID: " + Thread.currentThread().getId()));
            return;
        }
        this.document = provider.getDocument((Object)input);
        if (this.document != null) {
            this.document.addDocumentListener((IDocumentListener)this);
            JCLUtilities.validateJCLFile((IFile)((FileEditorInput)input).getFile(), (IDocument)this.document, this.validators);
        } else {
            Debug.error((Logger)logger, (String)AffinityBuildJCLPage.class.getName(), (String)"init", null);
        }
        ZOSActivator.getDefault().getPluginInstancePreferences().addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        this.setPartName(Messages.getString("AffinityBuildEditor.DeploymentJCL.Title"));
        Debug.exit((Logger)logger, (String)AffinityBuildJCLPage.class.getName(), (String)"init", (Object)("Thread ID: " + Thread.currentThread().getId()));
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setHelpContextId("com.ibm.cics.zos.core.ui.jcl_editor");
    }

    protected String[] collectContextMenuPreferencePages() {
        String[] ids = super.collectContextMenuPreferencePages();
        String[] more = new String[ids.length + 1];
        more[0] = "com.ibm.cics.zos.core.ui.jcl_preference_page";
        System.arraycopy(ids, 0, more, 1, ids.length);
        return more;
    }

    private SourceViewerConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new JCLConfiguration(ColorManager.getDefault());
        }
        return this.configuration;
    }

    public JCLPartitionTokenScanner getPartitionScanner() {
        if (this.partitions == null) {
            this.partitions = new JCLPartitionTokenScanner();
        }
        return this.partitions;
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        super.createPartControl(parent);
        this.getSourceViewer().getTextWidget().addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (ZOSActivator.getDefault().getPluginInstancePreferences().getBoolean("Caps_on", false)) {
                    e.text = e.text.toUpperCase();
                }
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.cics.zos.core.ui.jcl_editor");
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.DELETE.getId(), this.getAction(ActionFactory.DELETE.getId()));
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.FIND.getId(), this.getAction(ActionFactory.FIND.getId()));
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.getAction(ActionFactory.SELECT_ALL.getId()));
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.NEXT.getId(), this.getAction(ActionFactory.NEXT.getId()));
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.PREVIOUS.getId(), this.getAction(ActionFactory.PREVIOUS.getId()));
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.getAction(ActionFactory.SELECT_ALL.getId()));
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), this.getAction(ActionFactory.COPY.getId()));
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), this.getAction(ActionFactory.CUT.getId()));
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), this.getAction(ActionFactory.PASTE.getId()));
        this.getEditorSite().getActionBars().updateActionBars();
    }

    public void dispose() {
        Debug.enter((Logger)logger, (String)AffinityBuildJCLPage.class.getName(), (String)"dispose", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.document != null) {
            this.document.removeDocumentListener((IDocumentListener)this);
        }
        ZOSActivator.getDefault().getPluginInstancePreferences().removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        super.dispose();
        Debug.exit((Logger)logger, (String)AffinityBuildJCLPage.class.getName(), (String)"dispose", (Object)("Thread ID: " + Thread.currentThread().getId()));
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        Debug.enter((Logger)logger, (String)AffinityBuildJCLPage.class.getName(), (String)"documentChanged", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "event: " + event.getText()});
        this.getSourceViewer().getTextWidget().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ((AffinityBuildEditor)AffinityBuildJCLPage.this.getEditor()).fireDirty();
            }
        });
        JCLUtilities.validateJCLFile((IFile)((FileEditorInput)this.getEditorInput()).getFile(), (IDocument)event.fDocument, this.validators);
        Debug.exit((Logger)logger, (String)AffinityBuildJCLPage.class.getName(), (String)"documentChanged", (Object)("Thread ID: " + Thread.currentThread().getId()));
    }

    protected void doPrint() {
        Debug.enter((Logger)logger, (String)AffinityBuildJCLPage.class.getName(), (String)"doPrint", (Object)("Thread ID: " + Thread.currentThread().getId()));
        StyledTextPrintOptions options = new StyledTextPrintOptions();
        options.printTextFontStyle = true;
        options.printTextForeground = true;
        options.printTextBackground = true;
        options.jobName = this.getTitle();
        options.header = "\t" + this.getTitle();
        ((ITextViewerExtension8)this.getSourceViewer()).print(options);
        Debug.exit((Logger)logger, (String)AffinityBuildJCLPage.class.getName(), (String)"doPrint", (Object)("Thread ID: " + Thread.currentThread().getId()));
    }

    public void initialize(FormEditor editor) {
        this.parentEditor = editor;
    }

    public FormEditor getEditor() {
        return this.parentEditor;
    }

    public IManagedForm getManagedForm() {
        return null;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean canLeaveThePage() {
        return true;
    }

    public Control getPartControl() {
        return this.parent;
    }

    public String getId() {
        return "jcl";
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean isEditor() {
        return true;
    }

    public boolean selectReveal(Object object) {
        this.getSelectionProvider().setSelection((ISelection)new StructuredSelection(object));
        return true;
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        ((JCLConfiguration)this.getConfiguration()).adaptToPreferenceChange(null);
        this.getSourceViewer().invalidateTextPresentation();
    }

    protected void performSaveAs(IProgressMonitor progressMonitor) {
    }

    public IDocument getDocument() {
        return this.document;
    }
}

