/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.ia.controller.CPSMDeploymentController;
import com.ibm.cics.ia.model.AffinityBuilderOutput;
import com.ibm.cics.ia.model.AffinityLifetime;
import com.ibm.cics.ia.model.AffinityRelation;
import com.ibm.cics.ia.model.BuiltAffGroup;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.AffGroupAction;
import com.ibm.cics.ia.ui.AffinityBuildEditor;
import com.ibm.cics.ia.ui.AffinityView;
import com.ibm.cics.ia.ui.CPSMInputCellLabelProvider;
import com.ibm.cics.ia.ui.CPSMInputTreeContentProvider;
import com.ibm.cics.ia.ui.CPSMInputTreeViewerNode;
import com.ibm.cics.ia.ui.ImageFactory;
import com.ibm.cics.ia.ui.Messages;
import com.ibm.cics.ia.ui.TextDialog;
import com.ibm.cics.ia.ui.TreeSelectionProvider;
import com.ibm.cics.zos.model.DataEntry;
import com.ibm.cics.zos.model.DataSet;
import com.ibm.cics.zos.model.Member;
import com.ibm.cics.zos.model.PartitionedDataSet;
import com.ibm.cics.zos.ui.ZOSActivator;
import com.ibm.cics.zos.ui.views.DataSetWizard;
import com.ibm.cics.zos.ui.views.SelectDataSetDialog;
import java.io.FileNotFoundException;
import java.text.MessageFormat;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.internal.PopupMenuExtender;

public class AffinityBuildCPSMInputEditorPage
extends FormPage
implements IDocumentListener {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private AffinityBuildEditor editor;
    private AffinityBuilderOutput affinityBuilderOutput;
    public static final String OUTPUT = "OUTPUT";
    private Tree trangroupTree;
    private ContainerCheckedTreeViewer trangroupViewer;
    private TreeSelectionProvider selectionProvider;
    private CPSMInputTreeContentProvider treeContentProvider;
    private CPSMInputCellLabelProvider treeCellLabelProvider;
    private CPSMDeploymentController cpsmDeploymentController;
    private IDocument document;
    private Button selectDatasetButton;
    private Button createDatasetButton;
    private Text datasetText;
    private Text memberText;
    private Text cmasNameText;
    private Text outputUserText;
    private Text printNodeText;
    private Button checkRadio;
    private Button executeRadio;
    private Action runAction;
    private Form form;
    private static final Logger logger = Logger.getLogger(AffinityBuildCPSMInputEditorPage.class.getPackage().getName());

    public AffinityBuildCPSMInputEditorPage(FormEditor editor, AffinityBuilderOutput affinityBuilderOutput) {
        super(editor, "com.ibm.cics.ia.affinity.report.cpsmInput.page", Messages.getString("AffinityBuildEditor.CPSMInput.Title"));
        this.editor = (AffinityBuildEditor)editor;
        this.affinityBuilderOutput = affinityBuilderOutput;
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
    }

    public void dispose() {
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        IWorkbenchHelpSystem helpSystem = this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)parent, "com.ibm.cics.ia.help.affinity_build_editor");
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        Debug.enter((Logger)logger, (String)AffinityBuildCPSMInputEditorPage.class.getName(), (String)"createFormContent", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.form = managedForm.getForm().getForm();
        if (this.affinityBuilderOutput == null) {
            Debug.exit((Logger)logger, (String)AffinityBuildCPSMInputEditorPage.class.getName(), (String)"createFormContent", (Object)("Thread ID: " + Thread.currentThread().getId()));
            return;
        }
        this.cpsmDeploymentController = new CPSMDeploymentController((IWorkbenchPart)this.editor, this.affinityBuilderOutput, this.affinityBuilderOutput.getDataSetName(), this.affinityBuilderOutput.getMemberName(), this.affinityBuilderOutput.getCmasName(), this.affinityBuilderOutput.getOutputUserName(), this.affinityBuilderOutput.getPrintNode());
        managedForm.getToolkit().decorateFormHeading(this.form);
        Composite parent = this.form.getBody();
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 6;
        layout.marginHeight = 12;
        parent.setLayout((Layout)layout);
        GridData headerData = new GridData(768);
        Section headerSection = toolkit.createSection(parent, 384);
        headerSection.setText(Messages.getString("AffinityBuildEditor.CPSMInput.DeploymentParameters.Section.Text"));
        headerSection.setDescription(Messages.getString("AffinityBuildEditor.CPSMInput.DeploymentParameters.Section.Description"));
        headerSection.setLayoutData((Object)headerData);
        layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginWidth = 3;
        layout.marginHeight = 3;
        Composite headerClient = toolkit.createComposite((Composite)headerSection, 64);
        headerClient.setLayout((Layout)layout);
        GridData headerChildrenData = new GridData(4, 0x1000000, false, false);
        Label datasetLabel = new Label(headerClient, 0);
        datasetLabel.setText(Messages.getString("AffinityBuildEditor.CPSMInput.DeploymentParameters.DatasetName.Label"));
        datasetLabel.setLayoutData((Object)headerChildrenData);
        headerChildrenData = new GridData(4, 0x1000000, true, false);
        Composite datasetComposite = new Composite(headerClient, 0);
        datasetComposite.setLayoutData((Object)headerChildrenData);
        GridLayout datasetCompositeLayout = new GridLayout(3, false);
        datasetCompositeLayout.marginHeight = 0;
        datasetCompositeLayout.marginWidth = 0;
        datasetCompositeLayout.marginTop = 0;
        datasetCompositeLayout.marginLeft = 0;
        datasetCompositeLayout.marginRight = 0;
        datasetCompositeLayout.marginBottom = 0;
        datasetComposite.setLayout((Layout)datasetCompositeLayout);
        GridData datasetGridData = new GridData(4, 0x1000000, true, false);
        this.datasetText = new Text(datasetComposite, 2048);
        this.datasetText.setText(this.affinityBuilderOutput.getDataSetName());
        this.datasetText.setLayoutData((Object)datasetGridData);
        this.datasetText.setEnabled(true);
        this.datasetText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AffinityBuildCPSMInputEditorPage.this.editor.setDatasetName(AffinityBuildCPSMInputEditorPage.this.datasetText.getText());
                AffinityBuildCPSMInputEditorPage.this.updateJcl();
            }
        });
        datasetGridData = new GridData(24, 24);
        this.selectDatasetButton = new Button(datasetComposite, 0x800000);
        this.selectDatasetButton.setImage(ImageFactory.getOpenDatasetImage());
        this.selectDatasetButton.setToolTipText(Messages.getString("AffinityBuildEditor.CPSMInput.DeploymentParameters.OpenDataset.Tooltip"));
        this.selectDatasetButton.setLayoutData((Object)datasetGridData);
        this.selectDatasetButton.setEnabled(ZOSActivator.getZOSConnectable().isConnected());
        this.selectDatasetButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Debug.enter((Logger)logger, (String)AffinityBuildCPSMInputEditorPage.class.getName(), (String)"widgetSelected", (Object)("ThreadId: " + Thread.currentThread().getId()));
                Shell currentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                SelectDataSetDialog dialog = new SelectDataSetDialog(currentShell);
                int open = dialog.open();
                if (open == 0) {
                    DataEntry dataEntry = dialog.getDataEntry();
                    if (dataEntry instanceof Member) {
                        AffinityBuildCPSMInputEditorPage.this.editor.setDatasetName(dataEntry.getParentPath());
                        AffinityBuildCPSMInputEditorPage.this.datasetText.setText(dataEntry.getParentPath());
                        AffinityBuildCPSMInputEditorPage.this.editor.setMemberName(dataEntry.getName());
                        AffinityBuildCPSMInputEditorPage.this.memberText.setText(dataEntry.getName());
                        AffinityBuildCPSMInputEditorPage.this.updateJcl();
                    } else if (dataEntry instanceof PartitionedDataSet) {
                        AffinityBuildCPSMInputEditorPage.this.editor.setDatasetName(((PartitionedDataSet)dataEntry).getFullPath());
                        AffinityBuildCPSMInputEditorPage.this.datasetText.setText(((PartitionedDataSet)dataEntry).getFullPath());
                        AffinityBuildCPSMInputEditorPage.this.editor.setMemberName("");
                        AffinityBuildCPSMInputEditorPage.this.memberText.setText("");
                        AffinityBuildCPSMInputEditorPage.this.updateJcl();
                    } else {
                        MessageBox box = new MessageBox(AffinityBuildCPSMInputEditorPage.this.getSite().getShell(), 40);
                        box.setMessage(Messages.getString("AffinityBuildEditor.CPSMInput.DeploymentParameters.IncorrectDatasetSelected.Message"));
                        box.setText(Messages.getString("AffinityBuildEditor.CPSMInput.DeploymentParameters.IncorrectDatasetSelected.Text"));
                        box.open();
                    }
                    Debug.exit((Logger)logger, (String)AffinityBuildCPSMInputEditorPage.class.getName(), (String)"widgetSelected");
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createDatasetButton = new Button(datasetComposite, 0x800000);
        this.createDatasetButton.setImage(ImageFactory.getCreateDatasetImage());
        this.createDatasetButton.setToolTipText(Messages.getString("AffinityBuildEditor.CPSMInput.DeploymentParameters.CreateDataset.Tooltip"));
        this.createDatasetButton.setLayoutData((Object)datasetGridData);
        this.createDatasetButton.setEnabled(ZOSActivator.getZOSConnectable().isConnected());
        this.createDatasetButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Debug.enter((Logger)logger, (String)AffinityBuildCPSMInputEditorPage.class.getName(), (String)"widgetSelected", (Object)("ThreadId: " + Thread.currentThread().getId()));
                DataSetWizard wizard = new DataSetWizard();
                wizard.setInitialPath("");
                wizard.setGenerateSourceJCL();
                wizard.init(AffinityBuildCPSMInputEditorPage.this.getEditorSite().getWorkbenchWindow().getWorkbench(), null);
                WizardDialog wizardDialog = new WizardDialog(AffinityBuildCPSMInputEditorPage.this.getEditorSite().getShell(), (IWizard)wizard);
                wizardDialog.open();
                if (wizardDialog.getReturnCode() == 0) {
                    try {
                        DataSet dataEntry = ZOSActivator.getZOSConnectable().getDataSet(wizard.getDatasetName());
                        if (dataEntry instanceof PartitionedDataSet) {
                            AffinityBuildCPSMInputEditorPage.this.datasetText.setText(wizard.getDatasetName());
                            AffinityBuildCPSMInputEditorPage.this.editor.setDatasetName(wizard.getDatasetName());
                            AffinityBuildCPSMInputEditorPage.this.memberText.setText("");
                            AffinityBuildCPSMInputEditorPage.this.editor.setMemberName("");
                        } else {
                            MessageBox box = new MessageBox(AffinityBuildCPSMInputEditorPage.this.getSite().getShell(), 40);
                            box.setMessage(Messages.getString("AffinityBuildEditor.CPSMInput.DeploymentParameters.IncorrectDatasetCreated.Message"));
                            box.setText(Messages.getString("AffinityBuildEditor.CPSMInput.DeploymentParameters.IncorrectDatasetCreated.Text"));
                            box.open();
                        }
                    }
                    catch (FileNotFoundException e1) {
                        Debug.warning((Logger)logger, (String)AffinityBuildCPSMInputEditorPage.class.getName(), (String)"widgetSelected", (String)"can't be here", (Throwable)e1);
                    }
                    Debug.exit((Logger)logger, (String)AffinityBuildCPSMInputEditorPage.class.getName(), (String)"widgetSelected");
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        headerChildrenData = new GridData(4, 0x1000000, false, false);
        Label memberLabel = new Label(headerClient, 0);
        memberLabel.setText(Messages.getString("AffinityBuildEditor.CPSMInput.DeploymentParameters.MemberName.Label"));
        memberLabel.setLayoutData((Object)headerChildrenData);
        headerChildrenData = new GridData(4, 0x1000000, true, false);
        this.memberText = new Text(headerClient, 2048);
        this.memberText.setText(this.affinityBuilderOutput.getMemberName());
        this.memberText.setLayoutData((Object)headerChildrenData);
        this.memberText.setEnabled(true);
        this.memberText.setTextLimit(8);
        this.memberText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AffinityBuildCPSMInputEditorPage.this.editor.setMemberName(AffinityBuildCPSMInputEditorPage.this.memberText.getText());
                AffinityBuildCPSMInputEditorPage.this.updateJcl();
            }
        });
        headerChildrenData = new GridData(4, 0x1000000, false, false);
        Label cmasNameLabel = new Label(headerClient, 0);
        cmasNameLabel.setText(Messages.getString("AffinityBuildEditor.CPSMInput.DeploymentParameters.CMASName.Label"));
        cmasNameLabel.setLayoutData((Object)headerChildrenData);
        headerChildrenData = new GridData(4, 0x1000000, true, false);
        this.cmasNameText = new Text(headerClient, 2048);
        this.cmasNameText.setText(this.affinityBuilderOutput.getCmasName());
        this.cmasNameText.setLayoutData((Object)headerChildrenData);
        this.cmasNameText.setEnabled(true);
        this.cmasNameText.setTextLimit(8);
        this.cmasNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AffinityBuildCPSMInputEditorPage.this.editor.setCmasName(AffinityBuildCPSMInputEditorPage.this.cmasNameText.getText());
                AffinityBuildCPSMInputEditorPage.this.updateJcl();
            }
        });
        headerChildrenData = new GridData(4, 0x1000000, false, false);
        Label outputUserLabel = new Label(headerClient, 0);
        outputUserLabel.setText(Messages.getString("AffinityBuildEditor.CPSMInput.DeploymentParameters.OutputUserName.Label"));
        outputUserLabel.setLayoutData((Object)headerChildrenData);
        headerChildrenData = new GridData(4, 0x1000000, true, false);
        this.outputUserText = new Text(headerClient, 2048);
        this.outputUserText.setText(this.affinityBuilderOutput.getOutputUserName());
        this.outputUserText.setLayoutData((Object)headerChildrenData);
        this.outputUserText.setEnabled(true);
        this.outputUserText.setTextLimit(8);
        this.outputUserText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AffinityBuildCPSMInputEditorPage.this.editor.setOutputUserName(AffinityBuildCPSMInputEditorPage.this.outputUserText.getText());
                AffinityBuildCPSMInputEditorPage.this.updateJcl();
            }
        });
        headerChildrenData = new GridData(4, 0x1000000, false, false);
        Label printNodeLabel = new Label(headerClient, 0);
        printNodeLabel.setText(Messages.getString("AffinityBuildEditor.CPSMInput.DeploymentParameters.PrintNode.Label"));
        printNodeLabel.setLayoutData((Object)headerChildrenData);
        headerChildrenData = new GridData(4, 0x1000000, true, false);
        this.printNodeText = new Text(headerClient, 2048);
        this.printNodeText.setText(this.affinityBuilderOutput.getPrintNode());
        this.printNodeText.setLayoutData((Object)headerChildrenData);
        this.printNodeText.setEnabled(true);
        this.printNodeText.setTextLimit(8);
        this.printNodeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AffinityBuildCPSMInputEditorPage.this.editor.setPrintNode(AffinityBuildCPSMInputEditorPage.this.printNodeText.getText());
                AffinityBuildCPSMInputEditorPage.this.updateJcl();
            }
        });
        headerChildrenData = new GridData(4, 0x1000000, false, false);
        this.checkRadio = new Button(headerClient, 16);
        this.checkRadio.setText(Messages.getString("AffinityBuildEditor.CPSMInput.DeploymentParameters.Check.Radio"));
        this.checkRadio.setLayoutData((Object)headerChildrenData);
        this.checkRadio.setSelection(AffinityBuilderOutput.Action.Check.equals((Object)this.affinityBuilderOutput.getAction()));
        this.checkRadio.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AffinityBuildCPSMInputEditorPage.this.editor.setAction(AffinityBuilderOutput.Action.Check);
                AffinityBuildCPSMInputEditorPage.this.updateJcl();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.executeRadio = new Button(headerClient, 16);
        this.executeRadio.setText(Messages.getString("AffinityBuildEditor.CPSMInput.DeploymentParameters.Execute.Radio"));
        this.executeRadio.setLayoutData((Object)headerChildrenData);
        this.executeRadio.setSelection(AffinityBuilderOutput.Action.Execute.equals((Object)this.affinityBuilderOutput.getAction()));
        this.executeRadio.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AffinityBuildCPSMInputEditorPage.this.editor.setAction(AffinityBuilderOutput.Action.Execute);
                AffinityBuildCPSMInputEditorPage.this.updateJcl();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        headerSection.setClient((Control)headerClient);
        layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginWidth = 3;
        layout.marginHeight = 3;
        Section trangroupSection = toolkit.createSection(parent, 384);
        trangroupSection.setText(Messages.getString("AffinityBuildEditor.CPSMInput.Trangroup.Section.Text"));
        trangroupSection.setDescription(Messages.getString("AffinityBuildEditor.CPSMInput.Trangroup.Section.Description"));
        trangroupSection.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).create());
        Composite trangroupClient = toolkit.createComposite((Composite)trangroupSection, 0);
        trangroupClient.setLayout((Layout)layout);
        trangroupClient.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).create());
        this.trangroupTree = toolkit.createTree(trangroupClient, 68388);
        this.trangroupTree.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).hint(100, 100).create());
        this.trangroupTree.getHorizontalBar().setVisible(true);
        this.trangroupViewer = new ContainerCheckedTreeViewer(this.trangroupTree);
        this.treeContentProvider = new CPSMInputTreeContentProvider();
        this.trangroupViewer.setContentProvider((IContentProvider)this.treeContentProvider);
        this.treeCellLabelProvider = new CPSMInputCellLabelProvider();
        this.trangroupViewer.setLabelProvider((IBaseLabelProvider)this.treeCellLabelProvider);
        trangroupSection.setClient((Control)trangroupClient);
        this.trangroupViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Debug.enter((Logger)logger, (String)"AffinityBuildCPSMInputEditorPage.createFormContent().trangroupViewer.ICheckStateListener()", (String)"checkStateChanged", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId()});
                if (event.getElement() instanceof CPSMInputTreeViewerNode) {
                    CPSMInputTreeViewerNode node = (CPSMInputTreeViewerNode)event.getElement();
                    if (node.getType().equals((Object)CPSMInputTreeViewerNode.Type.Context)) {
                        AffinityBuildCPSMInputEditorPage.this.trangroupViewer.setChecked((Object)node, !event.getChecked());
                        node.setChecked(IAUtilities.hasContent((String)((String)node.getData())));
                        Debug.exit((Logger)logger, (String)"AffinityBuildCPSMInputEditorPage.createFormContent().trangroupViewer.ICheckStateListener()", (String)"checkStateChanged", (Object)("Thread ID: " + Thread.currentThread().getId()));
                        return;
                    }
                    node.setChecked(event.getChecked());
                    AffinityBuildCPSMInputEditorPage.this.trangroupViewer.refresh((Object)node);
                    CPSMInputTreeViewerNode parentNode = node.getParentNode();
                    if (parentNode != null) {
                        boolean stateChanged = true;
                        while (parentNode != null && stateChanged) {
                            stateChanged = parentNode.updateCheckedState();
                            if (!stateChanged) continue;
                            AffinityBuildCPSMInputEditorPage.this.trangroupViewer.refresh((Object)parentNode);
                            parentNode = parentNode.getParentNode();
                        }
                    }
                    AffinityBuildCPSMInputEditorPage.this.editor.fireDirty();
                }
                Debug.exit((Logger)logger, (String)"AffinityBuildCPSMInputEditorPage.createFormContent().trangroupViewer.ICheckStateListener()", (String)"checkStateChanged", (Object)("Thread ID: " + Thread.currentThread().getId()));
            }
        });
        MenuManager mgr = new MenuManager(){

            public void addMenuListener(IMenuListener listener) {
                if (listener instanceof PopupMenuExtender) {
                    return;
                }
                super.addMenuListener(listener);
            }
        };
        mgr.setRemoveAllWhenShown(true);
        Menu popupMenu = mgr.createContextMenu((Control)this.trangroupTree);
        this.trangroupTree.setMenu(popupMenu);
        mgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Object object;
                ISelection selection = AffinityBuildCPSMInputEditorPage.this.trangroupViewer.getSelection();
                if (selection instanceof IStructuredSelection && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof CPSMInputTreeViewerNode) {
                    AffinityBuildCPSMInputEditorPage.this.createActions(manager, (CPSMInputTreeViewerNode)object);
                }
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        this.getSite().registerContextMenu(mgr, (ISelectionProvider)this.trangroupViewer);
        trangroupSection.setClient((Control)trangroupClient);
        this.refresh();
        this.editor.updateRunEnablement();
        Debug.exit((Logger)logger, (String)AffinityBuildCPSMInputEditorPage.class.getName(), (String)"createFormContent", (Object)("Thread ID: " + Thread.currentThread().getId()));
    }

    private void refresh() {
        Debug.enter((Logger)logger, (String)AffinityBuildCPSMInputEditorPage.class.getName(), (String)"refresh", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.trangroupViewer.setInput((Object)this.affinityBuilderOutput);
        this.trangroupViewer.expandAll();
        CPSMInputTreeViewerNode[] cPSMInputTreeViewerNodeArray = this.treeContentProvider.rootNodes;
        int n = this.treeContentProvider.rootNodes.length;
        int n2 = 0;
        while (n2 < n) {
            CPSMInputTreeViewerNode node = cPSMInputTreeViewerNodeArray[n2];
            this.trangroupViewer.setChecked((Object)node, node.isChecked());
            if (this.treeContentProvider.hasChildren(node)) {
                CPSMInputTreeViewerNode[] children;
                CPSMInputTreeViewerNode[] cPSMInputTreeViewerNodeArray2 = children = (CPSMInputTreeViewerNode[])this.treeContentProvider.getChildren(node);
                int n3 = children.length;
                int n4 = 0;
                while (n4 < n3) {
                    CPSMInputTreeViewerNode node2 = cPSMInputTreeViewerNodeArray2[n4];
                    this.trangroupViewer.setChecked((Object)node2, node2.isChecked());
                    ++n4;
                }
            }
            ++n2;
        }
        Debug.exit((Logger)logger, (String)AffinityBuildCPSMInputEditorPage.class.getName(), (String)"refresh", (Object)("Thread ID: " + Thread.currentThread().getId()));
    }

    public String getPartProperty(String key) {
        if (IConnectionCategory.class.getName().equals(key)) {
            return "com.ibm.cics.zos.comm.connection";
        }
        return super.getPartProperty(key);
    }

    private void createActions(IMenuManager manager, final CPSMInputTreeViewerNode node) {
        BuiltAffGroup affGroup;
        Action setNameAction;
        Debug.enter((Logger)logger, (String)AffinityView.class.getName(), (String)"createActions", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (node.getType().equals((Object)CPSMInputTreeViewerNode.Type.Context)) {
            final String context = (String)node.getData();
            setNameAction = new Action(Messages.getString("AffinityBuildEditor.CPSMInput.Trangroup.Section.Action.SetName")){

                public void run() {
                    TextDialog dialog = new TextDialog(Display.getDefault().getActiveShell(), Messages.getString("AffinityBuildEditor.CPSMInput.Trangroup.Section.Dialog.Context"), context, true, 8);
                    int result = dialog.open();
                    if (result == 0) {
                        String text = dialog.getText();
                        if (text.length() > 8) {
                            text = text.substring(0, 8);
                        }
                        AffinityBuildCPSMInputEditorPage.this.affinityBuilderOutput.setContext(text);
                        node.setData(text);
                        node.setChecked(IAUtilities.hasContent((String)text));
                        AffinityBuildCPSMInputEditorPage.this.trangroupViewer.setChecked((Object)node, node.isChecked());
                        AffinityBuildCPSMInputEditorPage.this.trangroupViewer.refresh((Object)node);
                        AffinityBuildCPSMInputEditorPage.this.editor.fireDirty();
                        AffinityBuildCPSMInputEditorPage.this.editor.refreshOverview();
                    }
                }
            };
            manager.add((IAction)setNameAction);
        }
        if (node.getType().equals((Object)CPSMInputTreeViewerNode.Type.CreateDtringrp)) {
            affGroup = (BuiltAffGroup)node.getParentNode().getData();
            final Transaction transaction = (Transaction)node.getData();
            Action setNameAction2 = new Action(Messages.getString("AffinityBuildEditor.CPSMInput.Trangroup.Section.Action.SetName")){

                public void run() {
                    TextDialog dialog = new TextDialog(Display.getDefault().getActiveShell(), MessageFormat.format(Messages.getString("AffinityBuildEditor.CPSMInput.Trangroup.Section.Dialog.Transaction"), transaction.getName()), transaction.getName(), false, 4);
                    int result = dialog.open();
                    if (result == 0 && IAUtilities.hasContent((String)dialog.getText())) {
                        String text = dialog.getText();
                        if (text.length() > 4) {
                            text = text.substring(0, 4);
                        }
                        Transaction newTransaction = ResourceFactory.getSingleton().getTransaction(text);
                        if (!affGroup.getTransactions().contains(newTransaction)) {
                            affGroup.addTransaction(newTransaction, Boolean.valueOf(node.isChecked()));
                            affGroup.removeTransaction(transaction);
                            node.setData(newTransaction);
                            AffinityBuildCPSMInputEditorPage.this.trangroupViewer.refresh((Object)node);
                            AffinityBuildCPSMInputEditorPage.this.trangroupViewer.refresh((Object)node.getParentNode());
                            AffinityBuildCPSMInputEditorPage.this.editor.fireDirty();
                            AffinityBuildCPSMInputEditorPage.this.editor.refreshOverview();
                        }
                    }
                }
            };
            manager.add((IAction)setNameAction2);
        }
        if (node.getType().equals((Object)CPSMInputTreeViewerNode.Type.CreateTrangrp)) {
            affGroup = (BuiltAffGroup)node.getData();
            setNameAction = new Action(Messages.getString("AffinityBuildEditor.CPSMInput.Trangroup.Section.Action.SetName")){

                public void run() {
                    TextDialog dialog = new TextDialog(Display.getDefault().getActiveShell(), MessageFormat.format(Messages.getString("AffinityBuildEditor.CPSMInput.Trangroup.Section.Dialog.Trangroup"), affGroup.getTranGroup()), affGroup.getTranGroup(), false, 8);
                    int result = dialog.open();
                    if (result == 0 && IAUtilities.hasContent((String)dialog.getText())) {
                        String text = dialog.getText();
                        if (text.length() > 8) {
                            text = text.substring(0, 8);
                        }
                        affGroup.setTranGroup(text);
                        AffinityBuildCPSMInputEditorPage.this.trangroupViewer.refresh((Object)node);
                        AffinityBuildCPSMInputEditorPage.this.editor.fireDirty();
                        AffinityBuildCPSMInputEditorPage.this.editor.refreshOverview();
                    }
                }
            };
            manager.add((IAction)setNameAction);
            MenuManager affinityMenu = new MenuManager(Messages.getString("AffinityBuildEditor.CPSMInput.Trangroup.Section.Action.SetAffinity"));
            AffGroupAction affinityGlobal = new AffGroupAction(this.editor, (TreeViewer)this.trangroupViewer, node, AffGroupAction.Type.Affinity, "GLOBAL");
            affinityGlobal.setText("GLOBAL");
            if (affGroup.getAffinity().equals((Object)AffinityRelation.GLOBAL)) {
                affinityGlobal.setEnabled(false);
            }
            affinityMenu.add((IAction)affinityGlobal);
            AffGroupAction affinityBappl = new AffGroupAction(this.editor, (TreeViewer)this.trangroupViewer, node, AffGroupAction.Type.Affinity, "BAPPL");
            affinityBappl.setText("BAPPL");
            if (affGroup.getAffinity().equals((Object)AffinityRelation.BAPPL)) {
                affinityBappl.setEnabled(false);
            }
            affinityMenu.add((IAction)affinityBappl);
            AffGroupAction affinityLink3270 = new AffGroupAction(this.editor, (TreeViewer)this.trangroupViewer, node, AffGroupAction.Type.Affinity, "LINK3270");
            affinityLink3270.setText("LINK3270");
            if (affGroup.getAffinity().equals((Object)AffinityRelation.LINK3270)) {
                affinityLink3270.setEnabled(false);
            }
            affinityMenu.add((IAction)affinityLink3270);
            AffGroupAction affinityLuname = new AffGroupAction(this.editor, (TreeViewer)this.trangroupViewer, node, AffGroupAction.Type.Affinity, "LUNAME");
            affinityLuname.setText("LUNAME");
            if (affGroup.getAffinity().equals((Object)AffinityRelation.LUNAME)) {
                affinityLuname.setEnabled(false);
            }
            affinityMenu.add((IAction)affinityLuname);
            AffGroupAction affinityUserid = new AffGroupAction(this.editor, (TreeViewer)this.trangroupViewer, node, AffGroupAction.Type.Affinity, "USERID");
            affinityUserid.setText("USERID");
            if (affGroup.getAffinity().equals((Object)AffinityRelation.USERID)) {
                affinityUserid.setEnabled(false);
            }
            affinityMenu.add((IAction)affinityUserid);
            manager.add((IContributionItem)affinityMenu);
            MenuManager lifetimeMenu = new MenuManager(Messages.getString("AffinityBuildEditor.CPSMInput.Trangroup.Section.Action.SetLifetime"));
            AffGroupAction lifetimePermanent = new AffGroupAction(this.editor, (TreeViewer)this.trangroupViewer, node, AffGroupAction.Type.Lifetime, "PERMANENT");
            lifetimePermanent.setText("PERMANENT");
            if (affGroup.getLifetime().equals((Object)AffinityLifetime.PERMANENT)) {
                lifetimePermanent.setEnabled(false);
            }
            lifetimeMenu.add((IAction)lifetimePermanent);
            AffGroupAction lifetimeSystem = new AffGroupAction(this.editor, (TreeViewer)this.trangroupViewer, node, AffGroupAction.Type.Lifetime, "SYSTEM");
            lifetimeSystem.setText("SYSTEM");
            if (affGroup.getLifetime().equals((Object)AffinityLifetime.SYSTEM)) {
                lifetimeSystem.setEnabled(false);
            }
            lifetimeMenu.add((IAction)lifetimeSystem);
            AffGroupAction lifetimeLogon = new AffGroupAction(this.editor, (TreeViewer)this.trangroupViewer, node, AffGroupAction.Type.Lifetime, "LOGON");
            lifetimeLogon.setText("LOGON");
            if (affGroup.getLifetime().equals((Object)AffinityLifetime.LOGON) || !AffinityLifetime.LOGON.isSuitable(affGroup.getAffinity())) {
                lifetimeLogon.setEnabled(false);
            }
            lifetimeMenu.add((IAction)lifetimeLogon);
            AffGroupAction lifetimePconv = new AffGroupAction(this.editor, (TreeViewer)this.trangroupViewer, node, AffGroupAction.Type.Lifetime, "PCONV");
            lifetimePconv.setText("PCONV");
            if (affGroup.getLifetime().equals((Object)AffinityLifetime.PCONV) || !AffinityLifetime.PCONV.isSuitable(affGroup.getAffinity())) {
                lifetimePconv.setEnabled(false);
            }
            lifetimeMenu.add((IAction)lifetimePconv);
            AffGroupAction lifetimeProcess = new AffGroupAction(this.editor, (TreeViewer)this.trangroupViewer, node, AffGroupAction.Type.Lifetime, "PROCESS");
            lifetimeProcess.setText("PROCESS");
            if (affGroup.getLifetime().equals((Object)AffinityLifetime.PROCESS) || !AffinityLifetime.PROCESS.isSuitable(affGroup.getAffinity())) {
                lifetimeProcess.setEnabled(false);
            }
            lifetimeMenu.add((IAction)lifetimeProcess);
            AffGroupAction lifetimeActivity = new AffGroupAction(this.editor, (TreeViewer)this.trangroupViewer, node, AffGroupAction.Type.Lifetime, "ACTIVITY");
            lifetimeActivity.setText("ACTIVITY");
            if (affGroup.getLifetime().equals((Object)AffinityLifetime.ACTIVITY) || !AffinityLifetime.ACTIVITY.isSuitable(affGroup.getAffinity())) {
                lifetimeActivity.setEnabled(false);
            }
            lifetimeMenu.add((IAction)lifetimeActivity);
            AffGroupAction lifetimeSignon = new AffGroupAction(this.editor, (TreeViewer)this.trangroupViewer, node, AffGroupAction.Type.Lifetime, "SIGNON");
            lifetimeSignon.setText("SIGNON");
            if (affGroup.getLifetime().equals((Object)AffinityLifetime.SIGNON) || !AffinityLifetime.SIGNON.isSuitable(affGroup.getAffinity())) {
                lifetimeSignon.setEnabled(false);
            }
            lifetimeMenu.add((IAction)lifetimeSignon);
            AffGroupAction lifetimeFacility = new AffGroupAction(this.editor, (TreeViewer)this.trangroupViewer, node, AffGroupAction.Type.Lifetime, "FACILITY");
            lifetimeFacility.setText("FACILITY");
            if (affGroup.getLifetime().equals((Object)AffinityLifetime.FACILITY) || !AffinityLifetime.FACILITY.isSuitable(affGroup.getAffinity())) {
                lifetimeFacility.setEnabled(false);
            }
            lifetimeMenu.add((IAction)lifetimeFacility);
            manager.add((IContributionItem)lifetimeMenu);
            MenuManager stateMenu = new MenuManager(Messages.getString("AffinityBuildEditor.CPSMInput.Trangroup.Section.Action.SetState"));
            AffGroupAction stateActive = new AffGroupAction(this.editor, (TreeViewer)this.trangroupViewer, node, AffGroupAction.Type.State, "ACTIVE");
            stateActive.setText("ACTIVE");
            if (affGroup.getState().equals("ACTIVE")) {
                stateActive.setEnabled(false);
            }
            stateMenu.add((IAction)stateActive);
            AffGroupAction stateDormant = new AffGroupAction(this.editor, (TreeViewer)this.trangroupViewer, node, AffGroupAction.Type.State, "DORMANT");
            stateDormant.setText("DORMANT");
            if (affGroup.getState().equals("DORMANT")) {
                stateDormant.setEnabled(false);
            }
            stateMenu.add((IAction)stateDormant);
            manager.add((IContributionItem)stateMenu);
            MenuManager matchMenu = new MenuManager(Messages.getString("AffinityBuildEditor.CPSMInput.Trangroup.Section.Action.SetMatch"));
            AffGroupAction matchLuname = new AffGroupAction(this.editor, (TreeViewer)this.trangroupViewer, node, AffGroupAction.Type.Match, "LUNAME");
            matchLuname.setText("LUNAME");
            if (affGroup.getMatch().equals("LUNAME")) {
                matchLuname.setEnabled(false);
            }
            matchMenu.add((IAction)matchLuname);
            AffGroupAction matchUserid = new AffGroupAction(this.editor, (TreeViewer)this.trangroupViewer, node, AffGroupAction.Type.Match, "USERID");
            matchUserid.setText("USERID");
            if (affGroup.getMatch().equals("USERID")) {
                matchUserid.setEnabled(false);
            }
            matchMenu.add((IAction)matchUserid);
            manager.add((IContributionItem)matchMenu);
        }
        Debug.exit((Logger)logger, (String)AffinityView.class.getName(), (String)"createActions");
    }

    private void updateJcl() {
        Debug.enter((Logger)logger, (String)AffinityBuildCPSMInputEditorPage.class.getName(), (String)"updateJCL", (Object[])new String[]{"ThreadId: " + Thread.currentThread().getId()});
        String jcl = this.editor.getJcl();
        Pattern pattern = Pattern.compile("INPUTDSN(.*)");
        Matcher match = pattern.matcher(jcl);
        if (match.find()) {
            jcl = match.replaceAll("INPUTDSN(" + this.datasetText.getText().replaceAll("([^a-zA-z0-9])", "\\\\$1") + ")");
        }
        if ((match = (pattern = Pattern.compile("INPUTMEMBER(.*)")).matcher(jcl)).find()) {
            jcl = match.replaceAll("INPUTMEMBER(" + this.memberText.getText().replaceAll("([^a-zA-z0-9])", "\\\\$1") + ")");
        }
        if ((match = (pattern = Pattern.compile("CMASNAME(.*)")).matcher(jcl)).find()) {
            jcl = match.replaceAll("CMASNAME(" + this.cmasNameText.getText().replaceAll("([^a-zA-z0-9])", "\\\\$1") + ")");
        }
        if ((match = (pattern = Pattern.compile("OUTPUTUSER(.*)")).matcher(jcl)).find()) {
            jcl = match.replaceAll("OUTPUTUSER(" + this.outputUserText.getText().replaceAll("([^a-zA-z0-9])", "\\\\$1") + ")");
        }
        if ((match = (pattern = Pattern.compile("PRINTNODE(.*)")).matcher(jcl)).find()) {
            jcl = match.replaceAll("PRINTNODE(" + this.printNodeText.getText().replaceAll("([^a-zA-z0-9])", "\\\\$1") + ")");
        }
        if (this.checkRadio.getSelection() && (match = (pattern = Pattern.compile("EXECUTE")).matcher(jcl)).find()) {
            jcl = match.replaceAll("CHECK");
        }
        if (this.executeRadio.getSelection() && (match = (pattern = Pattern.compile("CHECK")).matcher(jcl)).find()) {
            jcl = match.replaceAll("EXECUTE");
        }
        this.editor.setJcl(jcl);
        Debug.exit((Logger)logger, (String)AffinityBuildCPSMInputEditorPage.class.getName(), (String)"updateJCL");
    }

    public void setSelectDataSetEnabled(boolean enabled) {
        if (this.selectDatasetButton != null && !this.selectDatasetButton.isDisposed()) {
            this.selectDatasetButton.setEnabled(enabled);
        }
    }

    public void setCreateDataSetEnbled(boolean enabled) {
        if (this.createDatasetButton != null && !this.createDatasetButton.isDisposed()) {
            this.createDatasetButton.setEnabled(enabled);
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        String newText;
        String jcl = event.fDocument.get();
        if (this.datasetText == null || this.datasetText.isDisposed() || this.memberText == null || this.memberText.isDisposed() || this.cmasNameText == null || this.cmasNameText.isDisposed() || this.outputUserText == null || this.outputUserText.isDisposed() || this.printNodeText == null || this.printNodeText.isDisposed()) {
            return;
        }
        Pattern pattern = Pattern.compile("INPUTDSN\\((.*?)\\)");
        Matcher match = pattern.matcher(jcl);
        if (match.find()) {
            newText = match.group(1);
            if (!this.datasetText.getText().equals(newText)) {
                this.datasetText.setText(newText);
            }
        }
        if ((match = (pattern = Pattern.compile("INPUTMEMBER\\((.*?)\\)")).matcher(jcl)).find()) {
            newText = match.group(1);
            if (!this.memberText.getText().equals(newText)) {
                this.memberText.setText(newText);
            }
        }
        if ((match = (pattern = Pattern.compile("CMASNAME\\((.*?)\\)")).matcher(jcl)).find()) {
            newText = match.group(1);
            if (!this.cmasNameText.getText().equals(newText)) {
                this.cmasNameText.setText(newText);
            }
        }
        if ((match = (pattern = Pattern.compile("OUTPUTUSER\\((.*?)\\)")).matcher(jcl)).find()) {
            newText = match.group(1);
            if (!this.outputUserText.getText().equals(newText)) {
                this.outputUserText.setText(newText);
            }
        }
        if ((match = (pattern = Pattern.compile("PRINTNODE\\((.*?)\\)")).matcher(jcl)).find()) {
            newText = match.group(1);
            if (!this.printNodeText.getText().equals(newText)) {
                this.printNodeText.setText(newText);
            }
        }
        if ((match = (pattern = Pattern.compile("EXECUTE")).matcher(jcl)).find()) {
            this.executeRadio.setSelection(true);
            this.checkRadio.setSelection(false);
        } else {
            this.executeRadio.setSelection(false);
            this.checkRadio.setSelection(true);
        }
    }
}

