/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.ui;

import com.ibm.cics.ia.model.AffinityLifetime;
import com.ibm.cics.ia.model.AffinityRelation;
import com.ibm.cics.ia.model.BuiltAffGroup;
import com.ibm.cics.ia.ui.AffinityBuildEditor;
import com.ibm.cics.ia.ui.CPSMInputTreeViewerNode;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

class AffGroupAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private Type type;
    private String value;
    private TreeViewer treeViewer;
    private CPSMInputTreeViewerNode node;
    private AffinityBuildEditor editor;

    public AffGroupAction(AffinityBuildEditor editor, TreeViewer treeViewer, CPSMInputTreeViewerNode node, Type type, String value) {
        this.type = type;
        this.value = value;
        this.treeViewer = treeViewer;
        this.node = node;
        this.editor = editor;
    }

    public void run() {
        BuiltAffGroup affGroup = (BuiltAffGroup)this.node.getData();
        switch (this.type) {
            case Affinity: {
                affGroup.setAffinity(AffinityRelation.valueOf((String)this.value));
                if (affGroup.getLifetime().isSuitable(affGroup.getAffinity())) break;
                affGroup.setLifetime(AffinityLifetime.SYSTEM);
                break;
            }
            case Lifetime: {
                affGroup.setLifetime(AffinityLifetime.valueOf((String)this.value));
                break;
            }
            case Match: {
                affGroup.setMatch(this.value);
                break;
            }
            case State: {
                affGroup.setState(this.value);
            }
        }
        this.treeViewer.refresh((Object)this.node);
        this.editor.fireDirty();
        this.editor.refreshOverview();
    }

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    static enum Type {
        Match,
        State,
        Affinity,
        Lifetime;

    }
}

