/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.controller;

import com.ibm.cics.common.util.Debug;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public abstract class TreeFinder {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(TreeFinder.class.getPackage().getName());
    protected final Tree tree;
    private final ToolItem searchNextItem;
    private final ToolItem searchPreviousItem;
    protected List<TreeItem> matchingItems;
    private int matchingIndex;

    public TreeFinder(Tree resourcesTree, ToolItem searchNextItem, ToolItem searchPreviousItem) {
        Debug.enter((Logger)logger, (String)TreeFinder.class.getName(), (String)"TreeFinder", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.tree = resourcesTree;
        this.searchNextItem = searchNextItem;
        this.searchPreviousItem = searchPreviousItem;
        searchNextItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeFinder.this.findNext();
            }
        });
        searchPreviousItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeFinder.this.findPrevious();
            }
        });
        Debug.exit((Logger)logger, (String)TreeFinder.class.getName(), (String)"getNumberOfMatches");
    }

    public int getNumberOfMatches() {
        return this.matchingItems == null ? 0 : this.matchingItems.size();
    }

    public int getMatchingIndex() {
        return this.matchingIndex;
    }

    public void findNext() {
        Debug.enter((Logger)logger, (String)TreeFinder.class.getName(), (String)"findNext", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.matchingItems == null) {
            this.findMatchingItems();
            this.matchingIndex = 0;
        } else {
            ++this.matchingIndex;
        }
        if (this.matchingItems.size() > this.matchingIndex) {
            TreeItem matchingItem = this.matchingItems.get(this.matchingIndex);
            if (!matchingItem.isDisposed()) {
                this.tree.showItem(matchingItem);
                if (!matchingItem.isDisposed()) {
                    this.tree.setSelection(matchingItem);
                }
            }
            this.findMatchingItems();
        }
        this.updateToolItemState();
        Debug.exit((Logger)logger, (String)TreeFinder.class.getName(), (String)"findPrevious");
    }

    public void findPrevious() {
        Debug.enter((Logger)logger, (String)TreeFinder.class.getName(), (String)"findPrevious", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.matchingIndex > 0) {
            --this.matchingIndex;
            TreeItem matchingItem = this.matchingItems.get(this.matchingIndex);
            if (!matchingItem.isDisposed()) {
                this.tree.showItem(matchingItem);
                if (!matchingItem.isDisposed()) {
                    this.tree.setSelection(matchingItem);
                }
            }
            this.findMatchingItems();
        }
        this.updateToolItemState();
        Debug.exit((Logger)logger, (String)TreeFinder.class.getName(), (String)"updateToolItemState");
    }

    private void updateToolItemState() {
        this.searchNextItem.setEnabled(this.matchingItems.size() > this.matchingIndex + 1);
        this.searchPreviousItem.setEnabled(this.matchingIndex > 0);
    }

    public abstract void findMatchingItems();

    public void clear() {
        Debug.enter((Logger)logger, (String)TreeFinder.class.getName(), (String)"clear", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.searchNextItem != null && !this.searchNextItem.isDisposed()) {
            this.searchNextItem.setEnabled(false);
        }
        if (this.searchPreviousItem != null && !this.searchPreviousItem.isDisposed()) {
            this.searchPreviousItem.setEnabled(false);
        }
        this.matchingItems = null;
        this.matchingIndex = 0;
        Debug.exit((Logger)logger, (String)TreeFinder.class.getName(), (String)"clear");
    }
}

