/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.controller;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.controller.Messages;
import com.ibm.cics.ia.model.AffCommand;
import com.ibm.cics.ia.model.AffGroup;
import com.ibm.cics.ia.model.AffinityReport;
import com.ibm.cics.ia.model.AffinityType;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.ResourceRenderer;
import com.ibm.cics.ia.ui.ResourceTypeRenderer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;

public class HTMLAffinityReportController {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2013, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(HTMLAffinityReportController.class.getPackage().getName());
    private static final String HEADER_FILE = "$nl$/HTML/Affinity/header.html";
    private static final String AFFINITY_GROUPS_TABLE_FILE = "$nl$/HTML/Affinity/affinity_groups_table.html";
    private static final String AFFINITY_GROUPS_TABLE_ROW_FILE = "$nl$/HTML/Affinity/affinity_groups_table_row.html";
    private static final String AFFINITY_COMMANDS_TABLE_FILE = "$nl$/HTML/Affinity/affinity_commands_table.html";
    private static final String AFFINITY_COMMANDS_TABLE_ROW_FILE = "$nl$/HTML/Affinity/affinity_commands_table_row.html";
    private static final String TABLE_FOOTER_FILE = "$nl$/HTML/Affinity/table_footer.html";
    private static final String FOOTER_FILE = "$nl$/HTML/Affinity/footer.html";
    private static final String UTF8 = "UTF-8";
    private static final String GENERATION_TIME_TAG = "<!--%generationTime%-->";
    private static final String REGION_TAG = "<!--%region%-->";
    private static final String DESCRIPTION_TAG = "<!--%description%-->";
    private static final String COLLID_TAG = "<!--%collid%-->";
    private static final String RESOURCE_NAME_TAG = "<!--%resourceName%-->";
    private static final String RESOURCE_TYPE_TAG = "<!--%resourceType%-->";
    private static final String CICS_LEVEL_TAG = "<!--%cicsLevel%-->";
    private static final String CONTENT_TAG = "<!--%content%-->";

    public static StringBuilder generateReport(AffinityReport affinityReport) {
        Debug.enter((Logger)logger, (String)HTMLAffinityReportController.class.getName(), (String)"generateReport", (Object)("Thread ID: " + Thread.currentThread().getId()));
        StringBuilder reportBuilder = new StringBuilder();
        HTMLAffinityReportController.getHeader(reportBuilder, HEADER_FILE, affinityReport);
        StringBuilder affinityGroupsTable = HTMLAffinityReportController.getFileContent(AFFINITY_GROUPS_TABLE_FILE);
        StringBuilder affinityGroupRowTemplate = HTMLAffinityReportController.getFileContent(AFFINITY_GROUPS_TABLE_ROW_FILE);
        StringBuilder affinityCommandsTable = HTMLAffinityReportController.getFileContent(AFFINITY_COMMANDS_TABLE_FILE);
        StringBuilder affinityCommandRowTemplate = HTMLAffinityReportController.getFileContent(AFFINITY_COMMANDS_TABLE_ROW_FILE);
        for (AffinityType affinityType : affinityReport.getAffinityTypes()) {
            List affGroups = affinityReport.getAffinityGroups(affinityType);
            if (affGroups.size() <= 0) continue;
            reportBuilder.append((CharSequence)affinityGroupsTable);
            for (AffGroup affGroup : affGroups) {
                HTMLAffinityReportController.getAffinityGroupTableRow(reportBuilder, affinityGroupRowTemplate, affGroup);
                if (affGroup.getAffCommands().size() <= 0) continue;
                HTMLAffinityReportController.getAffCommands(reportBuilder, affGroup);
            }
            HTMLAffinityReportController.getFooter(reportBuilder, TABLE_FOOTER_FILE);
        }
        HTMLAffinityReportController.getFooter(reportBuilder, FOOTER_FILE);
        Debug.exit((Logger)logger, (String)HTMLAffinityReportController.class.getName(), (String)"generateReport");
        return reportBuilder;
    }

    private static StringBuilder getFileContent(String relativeFilePath) {
        Debug.enter((Logger)logger, (String)HTMLAffinityReportController.class.getName(), (String)"getFileContent", (Object)("Thread ID: " + Thread.currentThread().getId()));
        try {
            Bundle plugin = Activator.getDefault().getBundle();
            Path relativePath = new Path(relativeFilePath);
            InputStream fis = FileLocator.openStream((Bundle)plugin, (IPath)relativePath, (boolean)true);
            InputStreamReader in = new InputStreamReader(fis, UTF8);
            StringBuilder sb = new StringBuilder();
            int charsRead = -1;
            char[] buffer = new char[4096];
            do {
                if ((charsRead = in.read(buffer)) <= -1) continue;
                sb.append(buffer, 0, charsRead);
            } while (charsRead > -1);
            ((Reader)in).close();
            fis.close();
            Debug.exit((Logger)logger, (String)HTMLAffinityReportController.class.getName(), (String)"getFileContent");
            return sb;
        }
        catch (IOException ex) {
            Debug.warning((Logger)logger, (String)HTMLAffinityReportController.class.getName(), (String)"getFileContent", (Throwable)ex, new HashMap());
            IAPlugin.getDefault().logError(MessageFormat.format(Messages.getString("ReportController.errorByReadingFile"), relativeFilePath), (Throwable)ex);
            Debug.exit((Logger)logger, (String)HTMLAffinityReportController.class.getName(), (String)"getFileContent");
            return null;
        }
    }

    private static void getHeader(StringBuilder result, String relativeFilePath, AffinityReport affinityReport) {
        Debug.enter((Logger)logger, (String)HTMLAffinityReportController.class.getName(), (String)"getHeader", (Object)("Thread ID: " + Thread.currentThread().getId()));
        StringBuilder sb = HTMLAffinityReportController.getFileContent(relativeFilePath);
        if (sb != null) {
            int descriptionIndex;
            int regionIndex;
            int generationTimeIndex = sb.indexOf(GENERATION_TIME_TAG);
            if (generationTimeIndex > 0) {
                sb.replace(generationTimeIndex, generationTimeIndex + GENERATION_TIME_TAG.length(), AffinityReport.DATE_FORMAT.format(affinityReport.getGenerationDate()));
            }
            if ((regionIndex = sb.indexOf(REGION_TAG)) > 0) {
                sb.replace(regionIndex, regionIndex + REGION_TAG.length(), affinityReport.getRegion().getName());
            }
            if ((descriptionIndex = sb.indexOf(DESCRIPTION_TAG)) > 0) {
                sb.replace(descriptionIndex, descriptionIndex + DESCRIPTION_TAG.length(), affinityReport.getDescription());
            }
            result.append((CharSequence)sb);
        }
        Debug.exit((Logger)logger, (String)HTMLAffinityReportController.class.getName(), (String)"getHeader");
    }

    private static void insertTagValue(StringBuilder sb, String key, String value) {
        Debug.enter((Logger)logger, (String)HTMLAffinityReportController.class.getName(), (String)"insertTagValue", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String tag = "<!--%" + key + "%-->";
        int index = sb.indexOf(tag);
        if (index > 0) {
            sb.replace(index, index + tag.length(), value);
        }
        Debug.exit((Logger)logger, (String)HTMLAffinityReportController.class.getName(), (String)"insertTagValue");
    }

    private static void getAffinityGroupTableRow(StringBuilder container, StringBuilder template, AffGroup affGroup) {
        Debug.exit((Logger)logger, (String)HTMLAffinityReportController.class.getName(), (String)"getAffinityGroupTableRow", (Object)("Thread ID: " + Thread.currentThread().getId()));
        StringBuilder sb = new StringBuilder(template.toString());
        HTMLAffinityReportController.insertTagValue(sb, "TRANGROUP", affGroup.getTranGroup());
        HTMLAffinityReportController.insertTagValue(sb, "AFFINITY", affGroup.getAffinity().toString().trim());
        HTMLAffinityReportController.insertTagValue(sb, "LIFETIME", affGroup.getLifetime().toString().trim());
        HTMLAffinityReportController.insertTagValue(sb, "GROUPTYPE", affGroup.getGroupType());
        String resourceString = "";
        if (IAUtilities.hasContent((String)affGroup.getType()) && IAUtilities.hasContent((String)affGroup.getResourceName())) {
            Resource resource = ResourceFactory.getSingleton().getResource(affGroup.getType().trim(), affGroup.getResourceName().trim());
            resourceString = String.valueOf(ResourceTypeRenderer.asText(resource.getTypeName())) + " (" + ResourceRenderer.asText(resource) + ")";
        }
        HTMLAffinityReportController.insertTagValue(sb, "RESOURCE", resourceString);
        int index = container.indexOf(CONTENT_TAG);
        if (index > 0) {
            container.replace(index, index + CONTENT_TAG.length(), sb.toString());
        } else {
            container.append(sb.toString());
        }
        Debug.exit((Logger)logger, (String)HTMLAffinityReportController.class.getName(), (String)"getAffinityGroupTableRow", (Object)("Thread ID: " + Thread.currentThread().getId()));
    }

    private static void getAffCommands(StringBuilder reportTable, AffGroup affGroup) {
        Debug.enter((Logger)logger, (String)HTMLAffinityReportController.class.getName(), (String)"getAffCommands", (Object)("Thread ID: " + Thread.currentThread().getId()));
        StringBuilder affinityCommandsTable = HTMLAffinityReportController.getFileContent(AFFINITY_COMMANDS_TABLE_FILE);
        StringBuilder template = HTMLAffinityReportController.getFileContent(AFFINITY_COMMANDS_TABLE_ROW_FILE);
        StringBuilder rowsBuilder = new StringBuilder();
        for (AffCommand affCommand : affGroup.getAffCommands()) {
            StringBuilder sb = new StringBuilder(template.toString());
            HTMLAffinityReportController.insertTagValue(sb, "TRANSID", affCommand.getTransactionName());
            HTMLAffinityReportController.insertTagValue(sb, "PROGRAM", affCommand.getProgramName());
            HTMLAffinityReportController.insertTagValue(sb, "COMMAND", affCommand.getCommand());
            HTMLAffinityReportController.insertTagValue(sb, "OFFSET", affCommand.getOffset());
            HTMLAffinityReportController.insertTagValue(sb, "RESTYPE", affCommand.getResType());
            HTMLAffinityReportController.insertTagValue(sb, "USAGE", affCommand.getUsage());
            rowsBuilder.append(sb.toString());
        }
        int index = affinityCommandsTable.indexOf(CONTENT_TAG);
        if (index > 0) {
            affinityCommandsTable.replace(index, index + CONTENT_TAG.length(), rowsBuilder.toString());
        }
        reportTable.append((CharSequence)affinityCommandsTable);
        Debug.exit((Logger)logger, (String)HTMLAffinityReportController.class.getName(), (String)"getAffCommands", (Object)("Thread ID: " + Thread.currentThread().getId()));
    }

    private static void getFooter(StringBuilder result, String relativeFilePath) {
        Debug.enter((Logger)logger, (String)HTMLAffinityReportController.class.getName(), (String)"getFooter", (Object)("Thread ID: " + Thread.currentThread().getId()));
        StringBuilder sb = HTMLAffinityReportController.getFileContent(relativeFilePath);
        if (sb != null) {
            result.append((CharSequence)sb);
        }
        Debug.exit((Logger)logger, (String)HTMLAffinityReportController.class.getName(), (String)"getFooter");
    }
}

