/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.controller;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.commands.AffinityCommandsReportCommand;
import com.ibm.cics.ia.commands.AffinityGroupsReportCommand;
import com.ibm.cics.ia.controller.Messages;
import com.ibm.cics.ia.model.AffCommand;
import com.ibm.cics.ia.model.AffGroup;
import com.ibm.cics.ia.model.AffinityReport;
import com.ibm.cics.ia.model.AffinityType;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.ui.Activator;
import com.ibm.cics.ia.ui.AffinityReportEditorInput;
import com.ibm.cics.ia.ui.ReportManager;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;

public class AffinityReportGenerator
extends Job {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(AffinityReportGenerator.class.getPackage().getName());
    private static final String XML_EXTENSION = "xml";
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private String taskName;
    private boolean cancelled = false;
    private List<Region> regions;
    private List<AffinityType> affinityTypes;
    private IContainer rootFolder;
    private IPath absoluteLocation;
    private String reportName;
    private String reportDescription;
    private boolean addTimestamp;
    private IWorkspace workspace;
    private IWorkspaceRoot root;
    private IProject reportsProject;
    private QualifiedName qName = new QualifiedName("com.ibm.cics.ia.affinityReport", "regionFolder");

    public AffinityReportGenerator(List<Region> regions, List<AffinityType> affinityTypes, IContainer rootFolder, String reportName, String reportDescription, boolean addTimestamp) {
        super(Messages.getString("AffinityReportGenerator.taskName.text"));
        Debug.enter((Logger)logger, (String)AffinityReportGenerator.class.getName(), (String)"constructor", (Object[])new String[]{"ThreadID: " + Thread.currentThread().getId(), "regions: " + (regions == null ? regions : Integer.valueOf(regions.size())), "affinityTypes: " + (affinityTypes == null ? affinityTypes : Integer.valueOf(affinityTypes.size())), "rootFolder: " + rootFolder.getName(), "reportName: " + reportName, "reportDescription: " + reportDescription, "addTimesMap: " + addTimestamp});
        this.taskName = Messages.getString("AffinityReportGenerator.taskName.text");
        this.regions = regions;
        this.affinityTypes = affinityTypes;
        this.reportName = reportName;
        this.reportDescription = reportDescription;
        this.addTimestamp = addTimestamp;
        this.workspace = ResourcesPlugin.getWorkspace();
        this.root = this.workspace.getRoot();
        this.reportsProject = null;
        this.reportsProject = this.root.getProject("Interdependency Analyzer Reports");
        try {
            String property = rootFolder.getPersistentProperty(this.qName);
            if (IAUtilities.hasContent((String)property) && Boolean.TRUE.toString().equals(property)) {
                rootFolder = rootFolder.getParent();
            }
        }
        catch (CoreException e) {
            Debug.warning((Logger)logger, (String)AffinityReportGenerator.class.getName(), (String)"constructor", (String)"empty exception", (Throwable)e);
        }
        this.rootFolder = rootFolder;
        this.absoluteLocation = this.reportsProject.getLocation().append(rootFolder.getProjectRelativePath());
        Debug.exit((Logger)logger, (String)AffinityReportGenerator.class.getName(), (String)"constructor");
    }

    public void start() {
        Debug.enter((Logger)logger, (String)AffinityReportGenerator.class.getName(), (String)"start", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.addTimestamp) {
            String timestamp = DATE_FORMAT.format(new Date());
            this.reportName = String.valueOf(this.reportName) + "_" + timestamp;
        }
        IPath firstReport = null;
        for (Region region : this.regions) {
            AffinityReport affinityReport = new AffinityReport(region, this.affinityTypes);
            affinityReport.setDescription(this.reportDescription);
            for (AffinityType affinityType : this.affinityTypes) {
                AffinityGroupsReportCommand command = new AffinityGroupsReportCommand(region, affinityType);
                command.setAsync(false);
                command.start();
                List results = command.getResults();
                if (results == null) {
                    return;
                }
                for (AffGroup affGroup : results) {
                    ArrayList affCommands = new ArrayList();
                    affGroup.setAffCommands(affCommands);
                    AffinityCommandsReportCommand command2 = new AffinityCommandsReportCommand(affGroup);
                    command2.setAsync(false);
                    command2.start();
                    List results2 = command2.getResults();
                    if (results2 == null) {
                        return;
                    }
                    for (AffCommand affCommand : results2) {
                        affGroup.getAffCommands().add(affCommand);
                    }
                }
                affinityReport.setAffinityGroups(affinityType, results);
            }
            IPath path = this.saveAffinityReport(affinityReport);
            if (firstReport != null) continue;
            firstReport = path;
        }
        final IFile reportFile = this.reportsProject.getFile(firstReport);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ReportManager.refreshAll(AffinityReportGenerator.this.rootFolder);
                String fullFileName = reportFile.getLocation().toOSString();
                File file = new File(fullFileName);
                AffinityReport report = AffinityReport.parse((File)file);
                AffinityReportEditorInput input = new AffinityReportEditorInput();
                input.setAffinityReport(report);
                input.setReportFile(reportFile);
                Activator.getAffinityReportEditor(input);
            }
        });
        Debug.exit((Logger)logger, (String)AffinityReportGenerator.class.getName(), (String)"start");
    }

    private IPath saveAffinityReport(AffinityReport report) {
        Debug.enter((Logger)logger, (String)AffinityReportGenerator.class.getName(), (String)"saveAffinityReport", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "region: " + report.getRegion(), "description: " + report.getDescription()});
        Path folderPath = new Path(report.getRegion().getName());
        IPath reportFolder = this.absoluteLocation.append((IPath)folderPath);
        String reportFolderString = reportFolder.toOSString();
        File folder = new File(reportFolderString);
        if (!folder.exists()) {
            folder.mkdir();
            IFolder iFolder = this.rootFolder.getFolder((IPath)folderPath);
            try {
                iFolder.create(true, true, null);
                iFolder.setPersistentProperty(this.qName, Boolean.TRUE.toString());
            }
            catch (CoreException e) {
                Debug.error((Logger)logger, (String)AffinityReportGenerator.class.getName(), (String)"saveAffinityReport", (Throwable)e);
            }
        }
        IPath reportFile = reportFolder.append(this.reportName);
        reportFile = reportFile.addFileExtension(XML_EXTENSION);
        String reportFileString = reportFile.toOSString();
        File file = new File(reportFileString);
        report.write(file);
        Debug.exit((Logger)logger, (String)AffinityReportGenerator.class.getName(), (String)"saveAffinityReport", (Object)("Thread ID: " + Thread.currentThread().getId()));
        return this.rootFolder.getProjectRelativePath().append((IPath)folderPath).append(this.reportName).addFileExtension(XML_EXTENSION);
    }

    protected IStatus run(IProgressMonitor monitor) {
        Debug.enter((Logger)logger, (String)AffinityReportGenerator.class.getName(), (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
        monitor.beginTask(this.taskName, -1);
        this.start();
        monitor.done();
        Debug.exit((Logger)logger, (String)AffinityReportGenerator.class.getName(), (String)"run");
        return Status.OK_STATUS;
    }

    protected void canceling() {
        this.cancelled = true;
        super.canceling();
    }
}

