/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.controller;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.controller.CPSMDeploymentController;
import com.ibm.cics.ia.controller.Messages;
import com.ibm.cics.ia.model.AffinityBuilderOutput;
import com.ibm.cics.ia.model.AffinityLifetime;
import com.ibm.cics.ia.model.AffinityRelation;
import com.ibm.cics.ia.model.AffinityReport;
import com.ibm.cics.ia.model.BuiltAffGroup;
import com.ibm.cics.ia.model.IAffinityBuilderInput;
import com.ibm.cics.ia.model.IAffinityBuilderInputGroup;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.ui.Activator;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class AffinityBuildGenerator
extends Job {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(AffinityBuildGenerator.class.getPackage().getName());
    private static final String XML_EXTENSION = "xml";
    private static final String GRP_SUFFIX = "GRP";
    private String taskName = Messages.getString("AffinityBuildGenerator.taskName.text");
    private boolean cancelled = false;
    private List<IResource> resources;
    private String context;
    private String match;
    private String state;
    private IProject reportsProject;
    private ArrayList<IAffinityBuilderInput> inputReports;
    private ArrayList<IAffinityBuilderInputGroup> inputGroups;
    private ArrayList<IResource> groupToReports;
    private TreeSet<Integer>[] merges;
    private ArrayList<BuiltAffGroup> outputGroups;

    public AffinityBuildGenerator(List<IResource> resources, String context, String match, String state) {
        super(Messages.getString("AffinityBuildGenerator.taskName.text"));
        this.resources = resources;
        this.context = context;
        this.match = match;
        this.state = state;
    }

    public void start() {
        Debug.enter((Logger)logger, (String)AffinityBuildGenerator.class.getName(), (String)"start", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.inputReports = new ArrayList();
        for (IResource resource : this.resources) {
            String fullFileName = ((IFile)resource).getLocation().toOSString();
            File file = new File(fullFileName);
            if (resource.getFileExtension().toLowerCase().equals(XML_EXTENSION)) {
                AffinityReport report = AffinityReport.parse((File)file);
                this.inputReports.add((IAffinityBuilderInput)report);
                continue;
            }
            AffinityBuilderOutput output = AffinityBuilderOutput.parse((File)file);
            this.inputReports.add((IAffinityBuilderInput)output);
        }
        this.fillInputGroups();
        this.mergeAffinityGroups();
        this.fillOutputGroups();
        AffinityBuilderOutput output = new AffinityBuilderOutput();
        output.setContext(this.context);
        output.setMatch(this.match);
        output.setState(this.state);
        output.setAffinityGroups(this.outputGroups);
        output.setDataSetName("");
        output.setMemberName("");
        output.setCmasName("");
        output.setOutputUserName("");
        output.setPrintNode("");
        output.setAction(AffinityBuilderOutput.Action.Execute);
        CPSMDeploymentController controller = new CPSMDeploymentController(null, output, "", "", "", "", "");
        output.setJcl(controller.generateJCL());
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject reportsProject = null;
        reportsProject = root.getProject("Interdependency Analyzer Reports");
        IPath absoluteLocation = reportsProject.getLocation();
        IPath filePath = absoluteLocation.append("build").addFileExtension("tmp");
        final IFile iFile = reportsProject.getFile((IPath)new Path("build.tmp"));
        String reportFileString = filePath.toOSString();
        File file = new File(filePath.toOSString());
        file.deleteOnExit();
        output.write(file);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                FileEditorInput input = new FileEditorInput(iFile);
                Activator.getAffinityBuildEditor((IEditorInput)input);
            }
        });
        Debug.exit((Logger)logger, (String)AffinityBuildGenerator.class.getName(), (String)"start");
    }

    private void fillInputGroups() {
        Debug.enter((Logger)logger, (String)AffinityBuildGenerator.class.getName(), (String)"fillInputGroups", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.inputGroups = new ArrayList();
        this.groupToReports = new ArrayList();
        int i = 0;
        while (i < this.inputReports.size()) {
            IAffinityBuilderInput affinityReport = this.inputReports.get(i);
            List affGroupsToBuild = affinityReport.getAffinityGroups();
            this.inputGroups.addAll(affGroupsToBuild);
            int j = 0;
            while (j < affGroupsToBuild.size()) {
                this.groupToReports.add(this.resources.get(i));
                ++j;
            }
            ++i;
        }
        this.merges = new TreeSet[this.inputGroups.size()];
        i = 0;
        while (i < this.merges.length) {
            TreeSet<Integer> merge = new TreeSet<Integer>();
            this.merges[i] = merge;
            merge.add(i);
            ++i;
        }
        Debug.exit((Logger)logger, (String)AffinityBuildGenerator.class.getName(), (String)"fillInputGroups", (Object)("Thread ID: " + Thread.currentThread().getId()));
    }

    private void mergeAffinityGroups() {
        Debug.enter((Logger)logger, (String)AffinityBuildGenerator.class.getName(), (String)"mergeAffinityGroups", (Object)("Thread ID: " + Thread.currentThread().getId()));
        int i = 0;
        while (i < this.inputGroups.size()) {
            IAffinityBuilderInputGroup affGroup1 = this.inputGroups.get(i);
            HashSet transactions1 = new HashSet();
            transactions1.addAll(affGroup1.getTransactions());
            int j = i + 1;
            while (j < this.inputGroups.size()) {
                HashSet intersection = new HashSet();
                intersection.addAll(transactions1);
                IAffinityBuilderInputGroup affGroup2 = this.inputGroups.get(j);
                Set transactions2 = affGroup2.getTransactions();
                intersection.retainAll(transactions2);
                if (intersection.size() > 0) {
                    this.merges[i].addAll(this.merges[j]);
                    this.merges[j].addAll(this.merges[i]);
                    transactions1.addAll(transactions2);
                }
                ++j;
            }
            ++i;
        }
        Debug.exit((Logger)logger, (String)AffinityBuildGenerator.class.getName(), (String)"mergeAffinityGroups", (Object)("Thread ID: " + Thread.currentThread().getId()));
    }

    private void fillOutputGroups() {
        Debug.enter((Logger)logger, (String)AffinityBuildGenerator.class.getName(), (String)"fillOutputGroups", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.outputGroups = new ArrayList();
        int i = 0;
        while (i < this.merges.length) {
            block10: {
                AffinityLifetime lifetime;
                AffinityRelation relation;
                HashMap derivedFrom;
                Set transactions;
                block9: {
                    block8: {
                        String fileName;
                        transactions = null;
                        derivedFrom = new HashMap();
                        if (this.merges[i].size() <= 1) break block8;
                        transactions = new HashSet();
                        for (Integer number : this.merges[i]) {
                            IAffinityBuilderInputGroup innerGroup = this.inputGroups.get(number);
                            transactions.addAll(innerGroup.getTransactions());
                            if (i == number) continue;
                            this.merges[number].clear();
                        }
                        IAffinityBuilderInputGroup first = this.inputGroups.get(this.merges[i].first());
                        IResource resource = this.groupToReports.get(i);
                        String previousFileName = fileName = ((IFile)resource).getProjectRelativePath().toPortableString();
                        relation = first.getAffinity();
                        lifetime = first.getLifetime();
                        String groupName = first.getTranGroup();
                        String groupNameAndDesc = String.valueOf(groupName) + "(" + relation.toString() + " " + lifetime.toString() + ")";
                        ArrayList<String> derivedFromGroups = new ArrayList<String>();
                        derivedFrom.put(fileName, derivedFromGroups);
                        derivedFromGroups.add(groupNameAndDesc);
                        for (Integer number : this.merges[i]) {
                            if (this.inputGroups.get(number) == first) continue;
                            relation = relation.getResultingRelation(this.inputGroups.get(number).getAffinity());
                            lifetime = lifetime.getResultingLifetime(this.inputGroups.get(number).getLifetime(), relation);
                            groupName = this.inputGroups.get(number).getTranGroup();
                            groupNameAndDesc = String.valueOf(groupName) + "(" + relation.toString() + " " + lifetime.toString() + ")";
                            resource = this.groupToReports.get(number);
                            fileName = ((IFile)resource).getProjectRelativePath().toPortableString();
                            if (!fileName.equals(previousFileName)) {
                                derivedFromGroups = new ArrayList();
                                derivedFrom.put(fileName, derivedFromGroups);
                                previousFileName = fileName;
                            }
                            derivedFromGroups.add(groupNameAndDesc);
                        }
                        break block9;
                    }
                    if (this.merges[i].size() <= 0) break block10;
                    transactions = this.inputGroups.get(i).getTransactions();
                    relation = this.inputGroups.get(i).getAffinity();
                    lifetime = this.inputGroups.get(i).getLifetime();
                    IResource resource = this.groupToReports.get(i);
                    String fileName = ((IFile)resource).getProjectRelativePath().toPortableString();
                    String groupNameAndDesc = String.valueOf(this.inputGroups.get(i).getTranGroup()) + "(" + relation.toString() + " " + lifetime.toString() + ")";
                    ArrayList<String> derivedFromGroups = new ArrayList<String>();
                    derivedFrom.put(fileName, derivedFromGroups);
                    derivedFromGroups.add(groupNameAndDesc);
                }
                TreeSet<String> transactionNames = new TreeSet<String>();
                for (Transaction transaction : transactions) {
                    transactionNames.add(transaction.getName());
                }
                String groupName = String.valueOf((String)transactionNames.pollFirst()) + GRP_SUFFIX;
                BuiltAffGroup outputGroup = new BuiltAffGroup(groupName);
                outputGroup.setDerivedFrom(derivedFrom);
                outputGroup.setAffinity(relation);
                outputGroup.setLifetime(lifetime);
                outputGroup.setMatch(this.match);
                outputGroup.setState(this.state);
                outputGroup.setTransactions(transactions);
                outputGroup.setDoCreate(true);
                outputGroup.setDoRemove(false);
                this.outputGroups.add(outputGroup);
            }
            ++i;
        }
        Debug.exit((Logger)logger, (String)AffinityBuildGenerator.class.getName(), (String)"fillOutputGroups", (Object)("Thread ID: " + Thread.currentThread().getId()));
    }

    protected IStatus run(IProgressMonitor monitor) {
        Debug.enter((Logger)logger, (String)AffinityBuildGenerator.class.getName(), (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
        monitor.beginTask(this.taskName, -1);
        this.start();
        monitor.done();
        Debug.exit((Logger)logger, (String)AffinityBuildGenerator.class.getName(), (String)"run");
        return Status.OK_STATUS;
    }

    protected void canceling() {
        this.cancelled = true;
        super.canceling();
    }
}

