/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.storedproc;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.StoredProcParameter;
import com.ibm.cics.dbfunc.command.StoredProcedureDefinition;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.dbfunc.model.StoredProcedure;
import com.ibm.cics.ia.query.Messages;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Logger;

public class ProcedureCIUSPTSR
extends StoredProcedureDefinition {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ProcedureCIUSPTSR.class.getPackage().getName());
    public static final String CTYPE_PGMS = "PGMS";
    public static final String CTYPE_TRNS = "TRNS";
    public static final String CTYPE_DTLD = "PGMD";
    public static final String CICSLEVEL_31 = "3.1";
    public static final String CICSLEVEL_32 = "3.2";
    public static final String CICSLEVEL_41 = "4.1";
    public static final String CICSLEVEL_42 = "4.2";
    public static final String CICSLEVEL_51 = "5.1";
    public static final String CICSLEVEL_52 = "5.2";
    public static final String CICSLEVEL_53 = "5.3";
    public static final String CICSLEVEL_55 = "5.5";
    public static final String CICSLEVEL_56 = "5.6";
    public static final String CICSLEVEL_61 = "6.1";
    public static final String CICSLEVEL_62 = "6.2";
    public static final String CICSLEVEL_63 = "6.3";
    public static final String CICSLEVEL_REGION_VERSION = " ";
    private static final String SQLSTATE_99100 = "99100";
    private static final String SQLSTATE_99500 = "99500";
    private static final String SQLSTATE_99510 = "99510";
    private static HashSet<String> userFriendlyMessages = new HashSet();

    static {
        userFriendlyMessages.add(SQLSTATE_99100);
        userFriendlyMessages.add(SQLSTATE_99500);
        userFriendlyMessages.add(SQLSTATE_99510);
    }

    public ProcedureCIUSPTSR() {
        this.name = "CIUSPTSR";
        this.parameters = new HashMap();
        this.resultSetCount = 0;
        while (this.resultSetCount < 5) {
            this.parameters.put(++this.resultSetCount, new StoredProcParameter(ColumnReference.DataType.String, StoredProcParameter.SPParameterType.Input));
        }
        this.parameters.put(++this.resultSetCount, new StoredProcParameter(ColumnReference.DataType.Integer, StoredProcParameter.SPParameterType.Output));
        this.parameters.put(++this.resultSetCount, new StoredProcParameter(ColumnReference.DataType.Integer, StoredProcParameter.SPParameterType.Output));
        this.parameters.put(++this.resultSetCount, new StoredProcParameter(ColumnReference.DataType.String, StoredProcParameter.SPParameterType.Output));
        this.parameters.put(++this.resultSetCount, new StoredProcParameter(ColumnReference.DataType.String, StoredProcParameter.SPParameterType.Output));
    }

    public SelectionObject getSelectionObject(String callType, String collectionId, String applId, String queryArg, String cicsTsLevel) {
        Debug.enter((Logger)logger, (String)ProcedureCIUSPTSR.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        StoredProcedure result = PresentationFactory.getInstance().createStoredProcedure(this.name, null);
        result.addInputParameter("CTYPE", callType, ColumnReference.DataType.String);
        result.addInputParameter("COLLID", collectionId, ColumnReference.DataType.String);
        result.addInputParameter("APPLID", applId, ColumnReference.DataType.String);
        result.addInputParameter("QARG", queryArg, ColumnReference.DataType.String);
        if (cicsTsLevel != null) {
            result.addInputParameter("CICSLEVEL", cicsTsLevel, ColumnReference.DataType.String);
        } else {
            result.addInputParameter("CICSLEVEL", CICSLEVEL_REGION_VERSION, ColumnReference.DataType.String);
        }
        result.addOutputParameter("RC", ColumnReference.DataType.Integer);
        result.addOutputParameter("SQLCODE", ColumnReference.DataType.Integer);
        result.addOutputParameter("SQLSTATE", ColumnReference.DataType.String);
        result.addOutputParameter("ERRMSG", ColumnReference.DataType.String);
        Debug.exit((Logger)logger, (String)ProcedureCIUSPTSR.class.getName(), (String)"getSelectionObject");
        return result;
    }

    public static String validateInput(String callType, String collectionId, String applId, String queryArg, String cicsTsLevel) {
        Debug.enter((Logger)logger, (String)ProcedureCIUSPTSR.class.getName(), (String)"validateInput", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String pattern = ".*[\\s+|" + IAUtilities.DB2_WILD_STR + "+].*";
        if (!collectionId.equals(IAUtilities.DB2_WILD_STR) && collectionId.matches(pattern)) {
            return Messages.getString("ProcedureCIUSPTSR.input.error.collectionId");
        }
        if (collectionId.length() > 16) {
            return Messages.getString("ProcedureCIUSPTSR.input.error.collectionIdLength");
        }
        pattern = "(\\w|#)+";
        if (!applId.equals(IAUtilities.DB2_WILD_STR) && !applId.matches(pattern)) {
            return Messages.getString("ProcedureCIUSPTSR.input.error.regionName");
        }
        if (applId.length() > 8) {
            return Messages.getString("ProcedureCIUSPTSR.input.error.regionLength");
        }
        if (callType.equals(CTYPE_PGMS)) {
            pattern = "^[a-zA-Z#@$]{1}[a-zA-Z0-9#@$]{0,7}$";
            if (queryArg.length() > 8) {
                return Messages.getString("ProcedureCIUSPTSR.input.error.programLength");
            }
            if (!queryArg.equals(IAUtilities.DB2_WILD_STR) && !queryArg.matches(pattern)) {
                return Messages.getString("ProcedureCIUSPTSR.input.error.programName");
            }
        } else if (callType.equals(CTYPE_TRNS)) {
            pattern = ".*[\\s+|" + IAUtilities.DB2_WILD_STR + "+].*";
            if (queryArg.length() > 4) {
                return Messages.getString("ProcedureCIUSPTSR.input.error.transactionLength");
            }
            if (!queryArg.equals(IAUtilities.DB2_WILD_STR) && queryArg.matches(pattern)) {
                return Messages.getString("ProcedureCIUSPTSR.input.error.transactionName");
            }
        }
        if (!(cicsTsLevel == null || cicsTsLevel.equals(CICSLEVEL_31) || cicsTsLevel.equals(CICSLEVEL_32) || cicsTsLevel.equals(CICSLEVEL_41) || cicsTsLevel.equals(CICSLEVEL_42) || cicsTsLevel.equals(CICSLEVEL_51) || cicsTsLevel.equals(CICSLEVEL_52) || cicsTsLevel.equals(CICSLEVEL_53) || cicsTsLevel.equals(CICSLEVEL_55) || cicsTsLevel.equals(CICSLEVEL_56) || cicsTsLevel.equals(CICSLEVEL_61) || cicsTsLevel.equals(CICSLEVEL_62) || cicsTsLevel.equals(CICSLEVEL_63) || cicsTsLevel.equals(CICSLEVEL_REGION_VERSION))) {
            return Messages.getString("ProcedureCIUSPTSR.input.error.unknownCicsTsLevel");
        }
        if (callType.equals(CTYPE_DTLD)) {
            if (IAUtilities.containsPercentWildcard(collectionId) || IAUtilities.containsDB2Wildcard(applId) || IAUtilities.containsDB2Wildcard(queryArg)) {
                return Messages.getString("ProcedureCIUSPTSR.input.error.wildcards");
            }
            return null;
        }
        if (callType.equals(CTYPE_PGMS) || callType.equals(CTYPE_TRNS)) {
            return null;
        }
        return Messages.getString("ProcedureCIUSPTSR.input.error.unknownCallType");
    }

    public static Result validateOutput(Integer returnCode, Integer sqlCode, String sqlState, String errMsg) {
        Result result;
        Debug.enter((Logger)logger, (String)ProcedureCIUSPTSR.class.getName(), (String)"validateOutput", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (returnCode != null) {
            switch (returnCode) {
                case 0: {
                    result = Result.SUCCESS;
                    break;
                }
                case 4: {
                    result = Result.SQLWARNING;
                    ProcedureCIUSPTSR.createMsg(returnCode, sqlCode, sqlState, errMsg, result);
                    break;
                }
                case 8: {
                    result = Result.SQLEXCEPTION;
                    if (userFriendlyMessages.contains(sqlState)) {
                        String key = "ProcedureCIUSPTSR.output.sqlState." + sqlState;
                        result.setMessage(MessageFormat.format(Messages.getString(key), errMsg));
                        break;
                    }
                    ProcedureCIUSPTSR.createMsg(returnCode, sqlCode, sqlState, errMsg, result);
                    break;
                }
                default: {
                    result = Result.SQLEXCEPTION;
                    ProcedureCIUSPTSR.createMsg(returnCode, sqlCode, sqlState, errMsg, result);
                    break;
                }
            }
        } else {
            result = Result.SQLEXCEPTION;
            result.setMessage("");
        }
        Debug.exit((Logger)logger, (String)ProcedureCIUSPTSR.class.getName(), (String)"validateOutput");
        return result;
    }

    private static void createMsg(Integer returnCode, Integer sqlCode, String sqlState, String errMsg, Result result) {
        if (IAUtilities.hasContent(errMsg)) {
            result.setMessage(MessageFormat.format(Messages.getString("ProcedureCIUSPTSR.output.notSuccessful"), returnCode, sqlCode, sqlState, errMsg));
        } else {
            result.setMessage(MessageFormat.format(Messages.getString("ProcedureCIUSPTSR.output.notSuccessful.emptyMessage"), returnCode, sqlCode, sqlState));
        }
    }

    public static enum Result {
        SUCCESS,
        SQLWARNING,
        SQLEXCEPTION;

        private String message = "";

        public String getMessage() {
            return this.message;
        }

        private void setMessage(String message) {
            this.message = message;
        }

        public boolean isSuccessful() {
            return this.equals((Object)SUCCESS);
        }

        public boolean isWarning() {
            return this.equals((Object)SQLWARNING);
        }

        public boolean isException() {
            return this.equals((Object)SQLEXCEPTION);
        }
    }
}

