/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.storedproc;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.StoredProcParameter;
import com.ibm.cics.dbfunc.command.StoredProcedureDefinition;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.dbfunc.model.StoredProcedure;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.runtime.Version;
import java.util.HashMap;
import java.util.logging.Logger;

public class ProcedureCIUSPCFL
extends StoredProcedureDefinition {
    static final String COPYRIGHT = "Licensed Materials - (c) Copyright HCL Technologies Ltd. *2025.";
    private static final Logger logger = Logger.getLogger(ProcedureCIUSPCFL.class.getPackage().getName());
    public static final String DELETE = "C";

    public ProcedureCIUSPCFL() {
        this.name = "CIUSPCFL";
        this.parameters = new HashMap();
        this.resultSetCount = 0;
        this.parameters.put(++this.resultSetCount, new StoredProcParameter(ColumnReference.DataType.String, StoredProcParameter.SPParameterType.Input));
        this.parameters.put(++this.resultSetCount, new StoredProcParameter(ColumnReference.DataType.String, StoredProcParameter.SPParameterType.Input));
        int integerParameterNumber = Version.getInstance().getDBVersion() < 5300 ? 16 : 17;
        int parameterCount = this.resultSetCount + integerParameterNumber;
        while (this.resultSetCount < parameterCount) {
            this.parameters.put(++this.resultSetCount, new StoredProcParameter(ColumnReference.DataType.Integer, StoredProcParameter.SPParameterType.Output));
        }
        this.parameters.put(++this.resultSetCount, new StoredProcParameter(ColumnReference.DataType.String, StoredProcParameter.SPParameterType.Output));
    }

    public SelectionObject getSelectionObject(String callType, String commandFlowId) {
        Debug.enter((Logger)logger, (String)ProcedureCIUSPCFL.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        StoredProcedure result = PresentationFactory.getInstance().createStoredProcedure(this.name, null);
        String safeCallType = IAUtilities.hasContent(callType) ? callType : "";
        String safeCollectionId = IAUtilities.hasContent(commandFlowId) ? commandFlowId : "";
        result.addInputParameter("IN_CALLTYPE", callType, ColumnReference.DataType.String);
        result.addInputParameter("IN_COLLECTION_ID", safeCollectionId, ColumnReference.DataType.String);
        result.addOutputParameter("INDEX_COUNT", ColumnReference.DataType.Integer);
        result.addOutputParameter("DETAIL_COUNT", ColumnReference.DataType.Integer);
        result.addOutputParameter("RC", ColumnReference.DataType.Integer);
        result.addOutputParameter("ERRMSG", ColumnReference.DataType.String);
        Debug.exit((Logger)logger, (String)ProcedureCIUSPCFL.class.getName(), (String)"getSelectionObject");
        return result;
    }
}

