/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.storedproc;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.DBUtilities;
import com.ibm.cics.dbfunc.command.StoredProcParameter;
import com.ibm.cics.dbfunc.command.StoredProcedureCommand;
import com.ibm.cics.dbfunc.command.StoredProcedureDefinition;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.dbfunc.model.StoredProcedure;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.runtime.Messages;
import com.ibm.cics.ia.runtime.Version;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProcedureCIUSPAP1
extends StoredProcedureDefinition {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ProcedureCIUSPAP1.class.getPackage().getName());
    private static final String NAME = "CIUSPAP1";
    private static final String IN_CALLTYPE = "IN_CALLTYPE";
    private static final String IN_PLATFORM = "IN_PLATFORM";
    private static final String IN_APPNAME = "IN_APPNAME";
    private static final String IN_VERSION1 = "IN_APPLVER1";
    private static final String IN_VERSION2 = "IN_APPLVER2";
    private static final String IN_VERSION3 = "IN_APPLVER3";
    private static final String IN_APPLOPER = "IN_APPLOPER";
    private static final String RC = "RC";
    private static final String ERRMSG = "ERRMSG";
    public static final String LIST_APPLICATIONS = "LIST";
    public static final String DELETE_APPLICATION = "DEL";

    public ProcedureCIUSPAP1() {
        this.name = NAME;
        this.parameters = new HashMap();
        int paramCounter = 1;
        this.parameters.put(paramCounter++, new StoredProcParameter(ColumnReference.DataType.String, StoredProcParameter.SPParameterType.Input));
        if (Version.getInstance().getDBVersion() >= 5200) {
            this.parameters.put(paramCounter++, new StoredProcParameter(ColumnReference.DataType.String, StoredProcParameter.SPParameterType.Input));
        }
        this.parameters.put(paramCounter++, new StoredProcParameter(ColumnReference.DataType.Integer, StoredProcParameter.SPParameterType.Input));
        this.parameters.put(paramCounter++, new StoredProcParameter(ColumnReference.DataType.Integer, StoredProcParameter.SPParameterType.Input));
        this.parameters.put(paramCounter++, new StoredProcParameter(ColumnReference.DataType.Integer, StoredProcParameter.SPParameterType.Input));
        this.parameters.put(paramCounter++, new StoredProcParameter(ColumnReference.DataType.String, StoredProcParameter.SPParameterType.Output));
        this.parameters.put(paramCounter++, new StoredProcParameter(ColumnReference.DataType.Integer, StoredProcParameter.SPParameterType.Output));
        this.resultSetCount = 5;
    }

    public SelectionObject getSelectionObject(String callType, String platformName, String appName, int ver1, int ver2, int ver3, String applOper) {
        Debug.enter((Logger)logger, (String)ProcedureCIUSPAP1.class.getName(), (String)"getSelectionObject", (Object)("Thread ID: " + Thread.currentThread().getId()));
        StoredProcedure result = PresentationFactory.getInstance().createStoredProcedure(this.name, null);
        String safePlatform = IAUtilities.hasContent(platformName) ? platformName : "";
        String safeAppName = IAUtilities.hasContent(appName) ? appName : "";
        String safeAppOper = IAUtilities.hasContent(applOper) ? applOper : "";
        result.addInputParameter(IN_CALLTYPE, callType, ColumnReference.DataType.String);
        if (Version.getInstance().getDBVersion() >= 5200) {
            result.addInputParameter(IN_PLATFORM, safePlatform, ColumnReference.DataType.String);
        }
        result.addInputParameter(IN_APPNAME, safeAppName, ColumnReference.DataType.String);
        result.addInputParameter(IN_VERSION1, Integer.toString(ver1), ColumnReference.DataType.Integer);
        result.addInputParameter(IN_VERSION2, Integer.toString(ver2), ColumnReference.DataType.Integer);
        result.addInputParameter(IN_VERSION3, Integer.toString(ver3), ColumnReference.DataType.Integer);
        result.addInputParameter(IN_APPLOPER, safeAppOper, ColumnReference.DataType.String);
        result.addOutputParameter(ERRMSG, ColumnReference.DataType.String);
        result.addOutputParameter(RC, ColumnReference.DataType.Integer);
        Debug.exit((Logger)logger, (String)ProcedureCIUSPAP1.class.getName(), (String)"getSelectionObject");
        return result;
    }

    public boolean isAvailable() {
        Debug.enter((Logger)logger, (String)ProcedureCIUSPAP1.class.getName(), (String)"isAvailable", (Object)("Thread ID: " + Thread.currentThread().getId()));
        boolean result = true;
        StoredProcedureCommand command = new StoredProcedureCommand(){

            public Object processRow(ResultSet resultSet) throws SQLException {
                return resultSet.getString(1);
            }

            public SelectionObject getSelectionObject() {
                return ProcedureCIUSPAP1.this.getSelectionObject(ProcedureCIUSPAP1.LIST_APPLICATIONS, "", "", 0, 0, 0, "");
            }
        };
        command.setCategory("com.ibm.cics.ia.connection.db2");
        command.setAsync(false);
        command.start();
        if (command.status() != 1 && command.status() != 3) {
            Throwable t;
            if (command.status() == 2 && (t = command.getError()) instanceof SQLException) {
                Debug.warning((Logger)logger, (String)ProcedureCIUSPAP1.class.getName(), (String)"isAvailable", (Throwable)t, new HashMap());
                SQLException sqle = (SQLException)t;
                if (DBUtilities.isStoredProcedureAbsent((SQLException)sqle) && Version.getInstance().getDBVersion() >= 5100) {
                    logger.log(Level.WARNING, String.valueOf(Messages.getString(String.valueOf(this.name) + ".ProcedureExpected")) + sqle);
                }
            }
            result = false;
        }
        Debug.exit((Logger)logger, (String)ProcedureCIUSPAP1.class.getName(), (String)"isAvailable");
        return result;
    }
}

