/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.sm.comm;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.AbstractConnection;
import com.ibm.cics.core.comm.AuthenticationException;
import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.dbfunc.DB2Host;
import com.ibm.cics.dbfunc.DBUtilities;
import com.ibm.cics.dbfunc.comm.DB2Connection;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.runtime.Messages;
import com.ibm.cics.ia.runtime.Version;
import com.ibm.cics.ia.runtime.VersionException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.logging.Logger;

public class IADB2DataConnection
extends AbstractConnection
implements DB2Connection {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(IADB2DataConnection.class.getName());
    String databaseName;
    String schemaName;
    boolean dbValid = false;

    public IADB2DataConnection() {
        this.toString();
    }

    public void setConfiguration(ConnectionConfiguration connectionConfiguration) {
        super.setConfiguration(connectionConfiguration);
        this.databaseName = connectionConfiguration.getExtendedAttribute("DATABASE_NAME");
        this.schemaName = connectionConfiguration.getExtendedAttribute("SCHEMA_NAME");
    }

    public void connect() throws ConnectionException {
        Debug.enter((Logger)logger, (String)IADB2DataConnection.class.getName(), (String)"connect");
        String host = this.getConfiguration().getHost();
        int port = this.getConfiguration().getPort();
        String passVar = this.getConfiguration().getPassword();
        if (passVar == null || passVar.equals("")) {
            throw new AuthenticationException(Messages.getString("PasswordRequiredException.passwordRequired"));
        }
        String userID = this.getConfiguration().getUserID();
        DB2Host.getDefault((String)"com.ibm.cics.ia.connection.db2").set(host, port, userID, passVar, this.databaseName, this.schemaName, this.getConfiguration().getSecureHint());
        String basicSQLQuery = "SELECT DISTINCT TYPE FROM $tableName.CIU_RESOURCE";
        String basicSQLQueryWithSchema = basicSQLQuery.replace("$tableName", this.schemaName);
        DB2Host db2Host = DB2Host.getDefault((String)"com.ibm.cics.ia.connection.db2");
        if (db2Host != null && db2Host.getConnectionStatus() == DB2Host.CONNECTED) {
            Connection connection = null;
            try {
                connection = db2Host.getDB2Connection();
                ResultSet resultSet = db2Host.runQuery(basicSQLQueryWithSchema);
                resultSet.close();
            }
            catch (ConnectionException ce) {
                throw ce;
            }
            catch (SQLException sqle) {
                if (DBUtilities.isPasswordInvalid((SQLException)sqle) | DBUtilities.isUserIDInvalid((SQLException)sqle) | DBUtilities.isUserIDRevoked((SQLException)sqle) | DBUtilities.isPasswordExpired((SQLException)sqle)) {
                    throw new AuthenticationException(sqle.getMessage());
                }
                if (DBUtilities.isUserIDInvalidPrivelege((SQLException)sqle)) {
                    throw new AuthenticationException(DBUtilities.getCommonSQLExceptionMessage((SQLException)sqle));
                }
                if (sqle instanceof DBUtilities.ReadableDB2SQLException && ((DBUtilities.ReadableDB2SQLException)sqle).getSqlCode().equals("-204") && ((DBUtilities.ReadableDB2SQLException)sqle).getSqlState().equals("42704")) {
                    throw new ConnectionException(MessageFormat.format(Messages.getString("IADB2DataConnection.SQLException.Code.-204.State.42704"), this.schemaName));
                }
                throw new ConnectionException(sqle.getMessage());
            }
        }
        Version.getInstance().reset();
        ResourceFactory.getSingleton().clear();
        boolean connectionExceptionThrown = false;
        try {
            this.dbValid = Version.getInstance().isDBValid();
        }
        catch (VersionException e) {
            this.dbValid = false;
            connectionExceptionThrown = true;
            throw new ConnectionException(e.getMessage(), (Throwable)e);
        }
        if (!this.dbValid && !connectionExceptionThrown) {
            throw new ConnectionException(MessageFormat.format(Messages.getString("Host.versionIncompatible"), Integer.toString(Version.getInstance().getDBVersion()), Integer.toString(6100)));
        }
        Debug.exit((Logger)logger, (String)IADB2DataConnection.class.getName(), (String)"connect");
    }

    public void disconnect() throws ConnectionException {
        DB2Host.getDefault((String)"com.ibm.cics.ia.connection.db2").disconnect();
        ResourceFactory.getSingleton().clear();
    }

    public boolean isConnected() {
        return DB2Host.getDefault((String)"com.ibm.cics.ia.connection.db2").getConnectionStatus() == DB2Host.CONNECTED && this.dbValid;
    }
}

