/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.sm.comm;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.AbstractConnection;
import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.ICredentialsManager;
import com.ibm.cics.ia.model.webservice.CIUAWSCFClient;
import com.ibm.cics.ia.model.webservice.CIUAWSDAClient;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.runtime.Messages;
import com.ibm.cics.ia.sm.comm.IAtomConnection;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Base64;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;

public class AtomConnection
extends AbstractConnection
implements IAtomConnection {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(AtomConnection.class.getPackage().getName());
    private URL url;
    private boolean isConnected = false;
    private String authString;
    private int connectionStatus = 0;
    private HttpURLConnection connection;
    public static final int TIMEOUT = 30000;
    private boolean isAtomService;

    public void connect() throws ConnectionException {
        Boolean ssl;
        int port;
        String host = this.getConfiguration().getHost();
        if (AtomConnection.isAtomService(host, port = this.getConfiguration().getPort(), ssl = Boolean.valueOf(this.getConfiguration().getSecureHint()))) {
            this.isAtomService = true;
            this.connectToAtomService();
        } else {
            this.connectToWebService();
        }
    }

    @Override
    public boolean isAtomService() {
        return this.isAtomService;
    }

    private static boolean isAtomService(String host, int port, boolean ssl) {
        int respCode = -1;
        try {
            URL url = !ssl ? new URL("http", host, port, "/CICSIA/IBM/atom/ciuatm01/feed") : new URL("https", host, port, "/CICSIA/IBM/atom/ciuatm01/feed");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(30000);
            connection.setReadTimeout(30000);
            InputStream is = connection.getInputStream();
            respCode = connection.getResponseCode();
        }
        catch (Exception e) {
            return false;
        }
        System.out.println("RESPONSE CODE: " + respCode);
        return true;
    }

    public void connectToWebService() throws ConnectionException {
        Debug.enter((Logger)logger, (String)AtomConnection.class.getName(), (String)"connect");
        String host = this.getConfiguration().getHost();
        int port = this.getConfiguration().getPort();
        Boolean ssl = this.getConfiguration().getSecureHint();
        this.connectionStatus = 2;
        ICredentialsManager mgr = ConnectionsPlugin.getDefault().getConnectionService().getConnectionManager().getCredentialsManager();
        if (mgr != null) {
            CredentialsConfiguration credentials = mgr.findCredentialsConfigurationByID(this.getConfiguration().getCredentialsID());
            String userID = credentials.getUserID();
            Base64.Encoder encoder = Base64.getMimeEncoder();
            String eStr = encoder.encodeToString(credentials.getPassword().getBytes());
            Base64.Decoder decoder = Base64.getMimeDecoder();
            String passVar = new String(decoder.decode(eStr));
            if (!IAUtilities.hasContent(passVar)) {
                throw new ConnectionException(Messages.getString("PasswordRequiredException.passwordRequired"));
            }
            if (!IAUtilities.hasContent(userID)) {
                throw new ConnectionException(Messages.getString("Host.noUserID"));
            }
            int respCode = -1;
            String respMessage = "";
            CIUAWSDAClient ciuawsdaClient = null;
            CIUAWSCFClient ciuawscfClient = null;
            try {
                ciuawscfClient = new CIUAWSCFClient(host, port, userID, passVar, ssl);
                ciuawscfClient.isServiceAvailable();
                ciuawsdaClient = new CIUAWSDAClient(host, port, userID, passVar, ssl);
                ciuawsdaClient.isServiceAvailable();
            }
            catch (MalformedURLException e1) {
                Debug.warning((Logger)logger, (String)AtomConnection.class.getName(), (String)"connect", (Throwable)e1, new HashMap());
                this.isConnected = false;
                this.connectionStatus = 3;
                throw new ConnectionException(Messages.getString("AtomConnection.MalformedURL"), (Throwable)e1);
            }
            catch (Exception e2) {
                Debug.warning((Logger)logger, (String)AtomConnection.class.getName(), (String)"connect", (Throwable)e2, new HashMap());
                this.isConnected = false;
                this.connectionStatus = 3;
                if (ciuawscfClient == null || ciuawsdaClient == null) {
                    IAPlugin.getDefault().logError(String.valueOf(Messages.getString("AtomConnection.ClientNotCreated")) + "\n" + host + ":" + port, e2);
                    throw new ConnectionException(Messages.getString("AtomConnection.ClientNotCreated"));
                }
                respCode = ciuawscfClient.getLastHttpResponseCode();
                respMessage = ciuawscfClient.getLastHttpResponseMsg();
                respCode = ciuawsdaClient.getLastHttpResponseCode();
                respMessage = ciuawsdaClient.getLastHttpResponseMsg();
                this.analyzeResponseCode(respCode, mgr, host, port, e2, userID, respMessage);
            }
        }
        Debug.exit((Logger)logger, (String)AtomConnection.class.getName(), (String)"connect");
        this.isConnected = true;
        this.connectionStatus = 1;
    }

    public void connectToAtomService() throws ConnectionException {
        Debug.enter((Logger)logger, (String)AtomConnection.class.getName(), (String)"connect");
        String host = this.getConfiguration().getHost();
        int port = this.getConfiguration().getPort();
        Boolean ssl = this.getConfiguration().getSecureHint();
        String path = "CICSIA/IBM/atom/ciuatm01/feed";
        this.connectionStatus = 2;
        ICredentialsManager mgr = ConnectionsPlugin.getDefault().getConnectionService().getConnectionManager().getCredentialsManager();
        if (mgr != null) {
            CredentialsConfiguration credentials = mgr.findCredentialsConfigurationByID(this.getConfiguration().getCredentialsID());
            String userID = credentials.getUserID();
            Base64.Encoder encoder = Base64.getMimeEncoder();
            String eStr = encoder.encodeToString(credentials.getPassword().getBytes());
            Base64.Decoder decoder = Base64.getMimeDecoder();
            String passVar = new String(decoder.decode(eStr));
            if (!IAUtilities.hasContent(passVar)) {
                throw new ConnectionException(Messages.getString("PasswordRequiredException.passwordRequired"));
            }
            if (!IAUtilities.hasContent(userID)) {
                throw new ConnectionException(Messages.getString("Host.noUserID"));
            }
            int respCode = -1;
            String respMessage = "";
            try {
                this.url = ssl == false ? new URL("http", host, port, "/" + path) : new URL("https", host, port, "/" + path);
                String unencodedAuthStr = String.valueOf(userID) + ":" + passVar;
                this.authString = DatatypeConverter.printBase64Binary((byte[])unencodedAuthStr.getBytes());
                this.getConfiguration().setExtendedAttribute("COLLECTOR_AUTH_STRING", this.authString);
                this.connection = (HttpURLConnection)this.url.openConnection();
                this.connection.setRequestMethod("GET");
                this.connection.setRequestProperty("Authorization", "Basic " + this.authString);
                this.connection.setConnectTimeout(30000);
                this.connection.setReadTimeout(30000);
                InputStream is = this.connection.getInputStream();
                respCode = this.connection.getResponseCode();
            }
            catch (MalformedURLException ex) {
                Debug.warning((Logger)logger, (String)AtomConnection.class.getName(), (String)"connect", (Throwable)ex, new HashMap());
                this.isConnected = false;
                this.connectionStatus = 3;
                throw new ConnectionException(Messages.getString("AtomConnection.MalformedURL"), (Throwable)ex);
            }
            catch (IOException ex) {
                Debug.warning((Logger)logger, (String)AtomConnection.class.getName(), (String)"connect", (Throwable)ex, new HashMap());
                this.isConnected = false;
                this.connectionStatus = 3;
                try {
                    respCode = this.connection.getResponseCode();
                    respMessage = this.connection.getResponseMessage();
                }
                catch (IOException ex2) {
                    Debug.warning((Logger)logger, (String)AtomConnection.class.getName(), (String)"connect", (Throwable)ex, new HashMap());
                    IAPlugin.getDefault().logError(String.valueOf(Messages.getString("AtomConnection.CouldntConnect")) + "\n" + host + ":" + port, ex2);
                    throw new ConnectionException(Messages.getString("AtomConnection.CouldntConnect"));
                }
                this.analyzeResponseCode(respCode, mgr, host, port, ex, userID, respMessage);
            }
        }
        Debug.exit((Logger)logger, (String)AtomConnection.class.getName(), (String)"connect");
        this.isConnected = true;
        this.connectionStatus = 1;
    }

    @Override
    public void disconnect(Exception ex, int respCode, String respMessage) throws ConnectionException {
        Debug.enter((Logger)logger, (String)AtomConnection.class.getName(), (String)"disconnect", (Object)("Thread ID: " + Thread.currentThread().getId()));
        ICredentialsManager mgr = ConnectionsPlugin.getDefault().getConnectionService().getConnectionManager().getCredentialsManager();
        this.connectionStatus = 3;
        String host = this.getConfiguration().getHost();
        int port = this.getConfiguration().getPort();
        if (mgr != null) {
            CredentialsConfiguration credentials = mgr.findCredentialsConfigurationByID(this.getConfiguration().getCredentialsID());
            String userId = credentials.getUserID();
            this.analyzeResponseCode(respCode, mgr, host, port, ex, userId, respMessage);
        }
        Debug.exit((Logger)logger, (String)AtomConnection.class.getName(), (String)"disconnect");
    }

    private void analyzeResponseCode(int respCode, ICredentialsManager mgr, String host, int port, Exception ex, String userId, String respMessage) throws ConnectionException {
        Debug.enter((Logger)logger, (String)AtomConnection.class.getName(), (String)"analyzeResponseCode", (Object)("Thread ID: " + Thread.currentThread().getId()));
        switch (respCode) {
            case 401: {
                mgr.clearAuthenticated(this.getConfiguration().getCredentialsID());
                IAPlugin.getDefault().logError(String.valueOf(Messages.getString("AtomConnection.BasicAuthError")) + "\n" + host + ":" + port, ex);
                throw new ConnectionException(Messages.getString("AtomConnection.BasicAuthError"));
            }
            case 403: {
                IAPlugin.getDefault().logError(String.valueOf(Messages.getString("AtomConnection.Forbidden")) + "\n" + host + ":" + port, ex);
                throw new ConnectionException(MessageFormat.format(Messages.getString("AtomConnection.Forbidden"), userId));
            }
            case 404: {
                IAPlugin.getDefault().logError(String.valueOf(Messages.getString("AtomConnection.NotFound")) + "\n" + host + ":" + port, ex);
                throw new ConnectionException(Messages.getString("AtomConnection.NotFound"));
            }
            case 408: {
                IAPlugin.getDefault().logError(String.valueOf(Messages.getString("AtomConnection.Timeout")) + "\n" + host + ":" + port, ex);
                throw new ConnectionException(Messages.getString("AtomConnection.Timeout"));
            }
            case 500: {
                IAPlugin.getDefault().logError(String.valueOf(Messages.getString("AtomConnection.InternalServerError")) + "\n" + host + ":" + port, ex);
                throw new ConnectionException(Messages.getString("AtomConnection.InternalServerError"));
            }
            case 503: {
                IAPlugin.getDefault().logError(String.valueOf(Messages.getString("AtomConnection.ServiceUnavailable")) + "\n" + host + ":" + port, ex);
                throw new ConnectionException(Messages.getString("AtomConnection.ServiceUnavailable"));
            }
        }
        IAPlugin.getDefault().logError(String.valueOf(Messages.getString("AtomConnection.CouldntConnect")) + " (" + respCode + ") " + respMessage + "\n" + host + ":" + port, ex);
        throw new ConnectionException(String.valueOf(Messages.getString("AtomConnection.CouldntConnect")) + " (" + respCode + ") " + respMessage, (Throwable)ex);
    }

    @Override
    public void disconnect(int respCode, String respMessage) throws ConnectionException {
        Debug.enter((Logger)logger, (String)AtomConnection.class.getName(), (String)"disconnect", (Object)("Thread ID: " + Thread.currentThread().getId()));
        ICredentialsManager mgr = ConnectionsPlugin.getDefault().getConnectionService().getConnectionManager().getCredentialsManager();
        this.connectionStatus = 3;
        if (mgr != null) {
            CredentialsConfiguration credentials = mgr.findCredentialsConfigurationByID(this.getConfiguration().getCredentialsID());
            String userId = credentials.getUserID();
            switch (respCode) {
                case 401: {
                    mgr.clearAuthenticated(this.getConfiguration().getCredentialsID());
                    throw new ConnectionException(Messages.getString("AtomConnection.BasicAuthError"));
                }
                case 403: {
                    throw new ConnectionException(MessageFormat.format(Messages.getString("AtomConnection.Forbidden"), userId));
                }
                case 404: {
                    throw new ConnectionException(Messages.getString("AtomConnection.NotFound"));
                }
                case 408: {
                    throw new ConnectionException(Messages.getString("AtomConnection.Timeout"));
                }
                case 500: {
                    throw new ConnectionException(Messages.getString("AtomConnection.InternalServerError"));
                }
                case 503: {
                    throw new ConnectionException(Messages.getString("AtomConnection.ServiceUnavailable"));
                }
            }
            throw new ConnectionException(String.valueOf(Messages.getString("AtomConnection.UnknownError")) + " (" + respCode + ") " + respMessage);
        }
    }

    public void disconnect() throws ConnectionException {
        if (this.isAtomService) {
            this.connection.disconnect();
        }
        this.isConnected = false;
        this.connectionStatus = 0;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    @Override
    public int getConnectionStatus() {
        return this.connectionStatus;
    }

    public void setConfiguration(ConnectionConfiguration connectionConfiguration) {
        super.setConfiguration(connectionConfiguration);
    }

    @Override
    public HttpURLConnection getConnection() {
        return this.connection;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public String getAuthString() {
        return this.authString;
    }
}

