/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.runtime;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.DB2Host;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.runtime.Version;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public final class IAUtilities {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static Logger logger = Logger.getLogger(IAUtilities.class.getPackage().getName());
    public static final char DB2_WILD_CHAR = '%';
    public static final char USER_WILD_CHAR = '*';
    public static final String USER_WILD_STR = String.valueOf('*');
    public static final String DB2_WILD_STR = String.valueOf('%');
    public static final String USER_WILD_STRING = new String(new char[]{'*'});
    public static final char SPACE = ' ';
    public static final String EMPTY_STRING = "".intern();
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final char SINGLE_QUOTE = '\'';
    public static final char COMMA = ',';
    public static final char UNDERSCORE_CHARACTER = '_';
    public static final char EQUALS = '=';
    public static final int APPLID_LENGTH = 8;
    public static final int PROGRAM_LENGTH = 8;
    public static final int APPLICATION_LENGTH = 8;
    public static final int TRANSID_LENGTH = 4;
    public static final int WEBSERVID_LENGTH = 32;
    private static final String HTTP = "http://";
    public static final String BLANK = "";
    public static final String DUMMY_TOD = "00000000000000000000";
    public static final BigDecimal MIN_TOD_MS = IAUtilities.getTodMilliseconds("00000000000000000001");
    public static final BigDecimal MAX_TOD_MS = IAUtilities.getTodMilliseconds("99999999999999999999");
    private static final Comparator regionComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((Region)o1).getName().compareTo(((Region)o2).getName());
        }
    };
    public static final String FILE_PREFIX = "CIU";
    private static List<String> tablesWithCollectionId = null;

    private IAUtilities() {
    }

    public static String toLikeString(String text) {
        Debug.enter((Logger)logger, (String)IAUtilities.class.getName(), (String)"toLikeString", (Object[])new String[]{"ThreadId: " + Thread.currentThread().getId(), "text: " + text});
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < text.length()) {
            char nextChar = text.charAt(i);
            if (nextChar == '\'') {
                buffer.append(nextChar);
                buffer.append(nextChar);
            } else if (nextChar == '*') {
                buffer.append('%');
            } else {
                buffer.append(nextChar);
            }
            ++i;
        }
        Debug.exit((Logger)logger, (String)IAUtilities.class.getName(), (String)"toLikeString", (Object)("result: " + buffer.toString()));
        return buffer.toString();
    }

    public static boolean match(String str, String regExp) {
        Debug.enter((Logger)logger, (String)IAUtilities.class.getName(), (String)"match", (Object[])new String[]{"ThreadId: " + Thread.currentThread().getId(), "str: " + str, "regExp: " + regExp});
        Pattern p = Pattern.compile(regExp);
        Matcher m = p.matcher(str);
        if (m.find()) {
            boolean result = str.length() == m.end() - m.start();
            Debug.exit((Logger)logger, (String)IAUtilities.class.getName(), (String)"match", (Object)("return " + result));
            return result;
        }
        Debug.exit((Logger)logger, (String)IAUtilities.class.getName(), (String)"match", (Object)"return false");
        return false;
    }

    public static boolean hasContent(String aString) {
        return aString != null && aString.trim().length() > 0;
    }

    public static boolean isDashed(String aString) {
        return aString != null && aString.replace("-", BLANK).length() == 0;
    }

    public static void addAllUnique(Collection resultListWithNoDuplicates, Collection listWithDuplicates) {
        for (Object nextChild : listWithDuplicates) {
            if (resultListWithNoDuplicates.contains(nextChild)) continue;
            resultListWithNoDuplicates.add(nextChild);
        }
    }

    public static List combine(Collection collection1, Collection collection2, Comparator aComparator) {
        Debug.enter((Logger)logger, (String)IAUtilities.class.getName(), (String)"combine", (Object[])new String[]{"ThreadID: " + Thread.currentThread().getId(), "collection 1 size: " + collection1.size(), "collection2 size: " + collection2.size(), "aComparator: " + aComparator});
        ArrayList results = new ArrayList(collection1.size() + collection2.size());
        for (Object item : collection1) {
            if (results.contains(item)) continue;
            results.add(item);
        }
        for (Object item : collection2) {
            if (results.contains(item)) continue;
            results.add(item);
        }
        Collections.sort(results, aComparator);
        Debug.exit((Logger)logger, (String)IAUtilities.class.getName(), (String)"combine", (Object)("results size: " + results.size()));
        return results;
    }

    public static String toString(List aList) {
        StringBuffer buffer = new StringBuffer();
        Object[] values = aList.toArray();
        int i = 0;
        while (i < values.length) {
            buffer.append(values[i]);
            if (values.length > i + 1) {
                buffer.append(", ");
            }
            ++i;
        }
        return buffer.toString();
    }

    public static Comparator getRegionComparator() {
        return regionComparator;
    }

    public static List asUniqueCollection(List verbs) {
        ArrayList result = new ArrayList(verbs.size());
        IAUtilities.addAllUnique(result, verbs);
        return result;
    }

    public static String shorten(String description, int maxLength) {
        if (description.length() < maxLength) {
            return description;
        }
        return String.valueOf(description.substring(0, maxLength)) + "...";
    }

    public static boolean startsWithANumber(String name) {
        Debug.enter((Logger)logger, (String)IAUtilities.class.getName(), (String)"startsWithANumber", (Object[])new String[]{"ThreadID: " + Thread.currentThread().getId(), "name: " + name});
        boolean result = name.matches("[0-9]+.*");
        Debug.exit((Logger)logger, (String)IAUtilities.class.getName(), (String)"startsWithANimber", (Object)("result: " + result));
        return result;
    }

    public static boolean isValidFilename(String name) {
        Debug.enter((Logger)logger, (String)IAUtilities.class.getName(), (String)"isValidFilename", (Object[])new String[]{"ThreadID: " + Thread.currentThread().getId(), "name: " + name});
        String escapedBackSlash = "\\\\";
        String regex = "[^:" + escapedBackSlash + ";/\\[\\]=\\*\\.\\|\\?\"<>]+";
        boolean result = name.matches(regex);
        Debug.exit((Logger)logger, (String)IAUtilities.class.getName(), (String)"isValidFileNamer", (Object)("result: " + result));
        return result;
    }

    public static boolean isValidFilePath(String filePath) {
        Debug.enter((Logger)logger, (String)IAUtilities.class.getName(), (String)"isValidFilePath", (Object[])new String[]{"ThreadID: " + Thread.currentThread().getId(), "filePath: " + filePath});
        if (filePath.length() > 240) {
            Debug.exit((Logger)logger, (String)IAUtilities.class.getName(), (String)"isValidFilePath", (Object)"return false");
            return false;
        }
        Debug.exit((Logger)logger, (String)IAUtilities.class.getName(), (String)"isValidFilePath", (Object)"return true");
        return true;
    }

    public static String removeTrailingBlanks(String aString) {
        char[] charArray = aString.toCharArray();
        int i = aString.length() - 1;
        while (i >= 0) {
            if (charArray[i] != ' ') {
                return aString.substring(0, i + 1);
            }
            --i;
        }
        return aString;
    }

    public static URL toURL(String serverName) throws MalformedURLException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(HTTP);
        buffer.append(serverName);
        return new URL(buffer.toString());
    }

    public static boolean isExactName(String resourceName) {
        Debug.enter((Logger)logger, (String)IAUtilities.class.getName(), (String)"isExactName", (Object[])new String[]{"ThreadID: " + Thread.currentThread().getId(), "resourceName: " + resourceName});
        if (resourceName.indexOf(42) != -1) {
            Debug.exit((Logger)logger, (String)IAUtilities.class.getName(), (String)"isExactName", (Object)"return false");
            return false;
        }
        Debug.exit((Logger)logger, (String)IAUtilities.class.getName(), (String)"isExactName", (Object)"return true");
        return true;
    }

    private static boolean stringIsNumericOnly(String input) {
        int i = 0;
        while (i < input.length()) {
            if (!Character.isDigit(input.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isAuthenticationInvalid(SQLException e, String matchErrFirst, String matchErrSecond) {
        Debug.enter((Logger)logger, (String)IAUtilities.class.getName(), (String)"isAuthenticationInvalid", (Object[])new String[]{"ThreadID: " + Thread.currentThread().getId(), "e sql state: " + e.getSQLState(), "matchErrFirst: " + matchErrFirst, "matchErrSecond: " + matchErrSecond});
        String firstErrorToken = BLANK;
        String secondErrorToken = BLANK;
        int firstErrNumLength = 4;
        int secondErrNumLength = 5;
        StringTokenizer tokenizer = new StringTokenizer(e.getMessage(), "[");
        boolean notFoundYet = true;
        while (tokenizer.hasMoreTokens() && notFoundYet) {
            String input = tokenizer.nextToken();
            if (!IAUtilities.numericErrorMatcher(input, firstErrNumLength)) continue;
            firstErrorToken = input;
            input = tokenizer.nextToken();
            if (!IAUtilities.numericErrorMatcher(input, secondErrNumLength)) continue;
            secondErrorToken = input;
            notFoundYet = false;
        }
        Debug.exit((Logger)logger, (String)IAUtilities.class.getName(), (String)"isAuthenticationInvalid", (Object)("return " + (firstErrorToken.startsWith(matchErrFirst) && secondErrorToken.startsWith(matchErrSecond))));
        return firstErrorToken.startsWith(matchErrFirst) && secondErrorToken.startsWith(matchErrSecond);
    }

    private static boolean numericErrorMatcher(String input, int targetLength) {
        if (input.contains("]")) {
            input = input.substring(0, input.indexOf("]"));
        }
        return IAUtilities.stringIsNumericOnly(input) && input.length() == targetLength;
    }

    public static boolean isPasswordInvalid(SQLException e) {
        return IAUtilities.isAuthenticationInvalid(e, "2013", "11249");
    }

    public static boolean isUserIDInvalid(SQLException e) {
        return IAUtilities.isAuthenticationInvalid(e, "2016", "11252");
    }

    public static boolean isUserIDRevoked(SQLException e) {
        return IAUtilities.isAuthenticationInvalid(e, "2017", "11253");
    }

    public static boolean isPasswordExpired(SQLException e) {
        return IAUtilities.isAuthenticationInvalid(e, "2016", "11252");
    }

    public static String getDefaultSchema() {
        return DB2Host.getDefault((String)"com.ibm.cics.ia.connection.db2").getSchema();
    }

    public static String getAffinityCommandTableName() {
        return "CIU_AFF_CMD_DATA";
    }

    public static String getAffinityGroupDataTableName() {
        return "CIU_AFF_GRP_DATA";
    }

    public static String getCICSDataTableName() {
        return "CIU_CICS_DATA";
    }

    public static String getDB2DataTableName() {
        return "CIU_DB2_DATA";
    }

    public static String getApplicationDescriptionTableName() {
        return "CIU_APPLS_DESC";
    }

    public static String getApplicationResourcesTableName() {
        return "CIU_APPLS_RESOURCE";
    }

    public static String getMQDataTableName() {
        return "CIU_MQ_DATA";
    }

    public static String getIMSDataTableName() {
        return "CIU_IMS_DATA";
    }

    public static String getAffinityViewTableName() {
        return "V_CIU_AFFINITY";
    }

    public static String getScannerTableName() {
        return "V_CIU_CICS_SCAN";
    }

    public static String getScanSummaryTableName() {
        return "CIU_SCAN_SUMMARY";
    }

    public static String getScanDetailTableName() {
        return "CIU_SCAN_DETAIL";
    }

    public static String getCSectInfoTableName() {
        return "CIU_CSECT_INFO";
    }

    public static String getEventsView() {
        return "V_CIU_EVENTS";
    }

    public static String getEventPropertyTableName() {
        return "CIU_EVENT_DETAIL";
    }

    public static String getProgramPropertyTableName() {
        return "CIU_PROGRAM_DETAIL";
    }

    public static String getTransactionPropertyTableName() {
        return "CIU_TRANSID_DETAIL";
    }

    public static String getWebservicePropertyTableName() {
        return "CIU_WEBSERV_DETAIL";
    }

    public static String getFilePropertyTableName() {
        return "CIU_FILE_DETAIL";
    }

    public static String getTDQueuePropertyTableName() {
        return "CIU_TDQUEUE_DETAIL";
    }

    public static String getTSQueuePropertyTableName() {
        return "CIU_TSQUEUE_DETAIL";
    }

    public static String getExitPropertyTableName() {
        if (Version.getInstance().getDBVersion() >= 3200) {
            return "V_CIU_EXIT_INFO";
        }
        return "CIU_EXIT_INFO";
    }

    public static String getRegionInfoName() {
        return "CIU_REGION_INFO";
    }

    public static String getVersionTableName() {
        return "CIU_VERSION";
    }

    public static String getResourcesTableName() {
        return "CIU_RESOURCE";
    }

    public static String getCommandFlowTableName() {
        return "CIU_CMDFLOW_DATA";
    }

    public static String getNaturalTableName() {
        return "CIU_NATURAL_DATA";
    }

    public static String getCommandFlowIndexTableName() {
        return "CIU_CMDFLOW_INDEX";
    }

    public static String getProgramInfoTableName() {
        return "CIU_PROGRAM_INFO";
    }

    public static String getProgramTemp2TableName() {
        return "CIU_PROGRAM_TEMP2";
    }

    public static String getTaskFlowIndexTableName() {
        return "CIU_CF_TASKFLOW_INDEX";
    }

    public static String getProgramFlowTableName() {
        return "CIU_CF_PROGFLOW";
    }

    public static List<String> getTablesWithCollectionId() {
        if (tablesWithCollectionId == null) {
            tablesWithCollectionId = new ArrayList<String>();
            tablesWithCollectionId.add(IAUtilities.getCICSDataTableName());
            tablesWithCollectionId.add(IAUtilities.getDB2DataTableName());
            tablesWithCollectionId.add(IAUtilities.getMQDataTableName());
            tablesWithCollectionId.add(IAUtilities.getIMSDataTableName());
            tablesWithCollectionId.add(IAUtilities.getNaturalTableName());
            tablesWithCollectionId.add(IAUtilities.getResourcesTableName());
        }
        return tablesWithCollectionId;
    }

    public static boolean containsWildcard(String input) {
        return input.contains(Character.toString('%')) || input.contains(Character.toString('*')) || input.contains(Character.toString('_'));
    }

    public static boolean containsPercentWildcard(String input) {
        return input.contains(Character.toString('%'));
    }

    public static boolean containsDB2Wildcard(String input) {
        return input.contains(Character.toString('%')) || input.contains(Character.toString('_'));
    }

    public static String escapeDB2Wildcards(String input, char escapeChar) {
        String result = input.replace("%", BLANK + escapeChar + '%');
        result = result.replace("_", BLANK + escapeChar + '_');
        return result;
    }

    public static <T> T[] concat(T[] first, T[] ... rest) {
        int tmp = first.length;
        T[][] TArray = rest;
        int n = rest.length;
        int n2 = 0;
        while (n2 < n) {
            T[] array = TArray[n2];
            tmp += array.length;
            ++n2;
        }
        T[] result = Arrays.copyOf(first, tmp);
        tmp = first.length;
        T[][] TArray2 = rest;
        int n3 = rest.length;
        n = 0;
        while (n < n3) {
            T[] array = TArray2[n];
            System.arraycopy(array, 0, result, tmp, array.length);
            tmp += array.length;
            ++n;
        }
        return result;
    }

    public static <T> List<T> subtract(List<T> a, T ... b) {
        LinkedList<T> result = new LinkedList<T>();
        List<T> toSubtract = Arrays.asList(b);
        for (T attribute : a) {
            if (toSubtract.contains(attribute)) continue;
            result.add(attribute);
        }
        return result;
    }

    public static BigDecimal getTodMilliseconds(String tod) throws NumberFormatException {
        return new BigDecimal(tod).divide(BigDecimal.valueOf(4096000L));
    }

    public static String getUserFriendlyTodMilliseconds(String tod) throws NumberFormatException {
        if (DUMMY_TOD.equals(tod)) {
            return BLANK;
        }
        return IAUtilities.getTodMilliseconds(tod.trim()).setScale(7, RoundingMode.HALF_UP).toPlainString();
    }

    public static String[] getTodString(BigDecimal milliseconds) {
        Debug.enter((Logger)logger, (String)IAUtilities.class.getName(), (String)"getTodString", (Object[])new String[]{"ThreadId: " + Thread.currentThread().getId(), "milliseconds: " + milliseconds});
        String[] tods = new String[2];
        if (milliseconds.compareTo(MIN_TOD_MS) < 0) {
            tods[0] = null;
            tods[1] = IAUtilities.getTodString(MIN_TOD_MS)[0];
        } else if (milliseconds.compareTo(MAX_TOD_MS) > 0) {
            tods[0] = IAUtilities.getTodString(MAX_TOD_MS)[0];
            tods[1] = null;
        } else {
            BigDecimal div = milliseconds.multiply(BigDecimal.valueOf(4096000L));
            BigDecimal integer = div.divideAndRemainder(BigDecimal.ONE)[0];
            BigDecimal remainder = div.divideAndRemainder(BigDecimal.ONE)[1];
            tods[0] = String.format("%20s", integer.setScale(0).toPlainString()).replaceAll(" ", "0");
            tods[1] = remainder.compareTo(BigDecimal.ZERO) > 0 ? String.format("%20s", integer.add(BigDecimal.ONE).stripTrailingZeros().toPlainString()).replaceAll(" ", "0") : tods[0];
        }
        Debug.exit((Logger)logger, (String)IAUtilities.class.getName(), (String)"getTodString", (Object)("result: " + tods.toString()));
        return tods;
    }

    public static String transformXml(File xml, Reader xslReader, Map<String, Object> xslParameters) throws TransformerException {
        Debug.enter((Logger)logger, (String)IAUtilities.class.getName(), (String)"transformXml", (Object)("Thread ID: " + Thread.currentThread().getId()));
        StreamSource xslt = new StreamSource(xslReader);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer(xslt);
        StreamSource source = new StreamSource(xml);
        StringWriter out = new StringWriter();
        StreamResult result = new StreamResult(out);
        if (xslParameters != null) {
            for (Map.Entry<String, Object> entry : xslParameters.entrySet()) {
                transformer.setParameter(entry.getKey(), entry.getValue());
            }
        }
        transformer.transform(source, result);
        Debug.exit((Logger)logger, (String)IAUtilities.class.getName(), (String)"transformXml");
        return out.toString();
    }

    public static void transformStringToHtml(String fileContent, String filePath) throws IOException {
        Debug.enter((Logger)logger, (String)IAUtilities.class.getName(), (String)"transformStringToHtml", (Object)("Thread ID: " + Thread.currentThread().getId()));
        File htmlFile = new File(filePath);
        FileWriter writer = new FileWriter(htmlFile);
        writer.write(fileContent);
        writer.close();
        Debug.exit((Logger)logger, (String)IAUtilities.class.getName(), (String)"transformStringToHtml");
    }

    public static String transformXmlToHtml(File xml, Reader xslReader, String filePath, Map<String, Object> xslParameters) throws TransformerException {
        Debug.enter((Logger)logger, (String)IAUtilities.class.getName(), (String)"transformXmlToHtml", (Object)("Thread ID: " + Thread.currentThread().getId()));
        StreamSource xslt = new StreamSource(xslReader);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer(xslt);
        StreamSource source = new StreamSource(xml);
        StringWriter out = new StringWriter();
        StreamResult result = new StreamResult(new File(filePath));
        if (xslParameters != null) {
            for (Map.Entry<String, Object> entry : xslParameters.entrySet()) {
                transformer.setParameter(entry.getKey(), entry.getValue());
            }
        }
        transformer.transform(source, result);
        Debug.exit((Logger)logger, (String)IAUtilities.class.getName(), (String)"transformXmlToHtml");
        return out.toString();
    }

    public static class EBCDICStringComparator
    implements Comparator {
        public int compare(Object firstString, Object secondString) {
            if (firstString == null) {
                return 1;
            }
            if (secondString == null) {
                return -1;
            }
            try {
                byte[] b1 = ((String)firstString).getBytes("CP1047");
                char[] c1 = new char[b1.length];
                int i = 0;
                while (i < b1.length) {
                    c1[i] = (char)b1[i];
                    ++i;
                }
                byte[] b2 = ((String)secondString).getBytes("CP1047");
                char[] c2 = new char[b2.length];
                int i2 = 0;
                while (i2 < b2.length) {
                    c2[i2] = (char)b2[i2];
                    ++i2;
                }
                int n = Math.min(b1.length, b2.length);
                int i3 = 0;
                int j = 0;
                while (n-- != 0) {
                    char char2;
                    char char1;
                    if ((char1 = c1[i3++]) == (char2 = c2[j++])) continue;
                    return char1 - char2;
                }
                return b1.length - b2.length;
            }
            catch (UnsupportedEncodingException e) {
                return 0;
            }
        }

        @Override
        public boolean equals(Object o) {
            return this == o;
        }
    }
}

