/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.runtime;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.DB2Host;
import com.ibm.cics.eclipse.common.IConnectionPasswordStorage;
import com.ibm.cics.ia.runtime.ICollectionIdListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class IAPlugin
extends Plugin {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static int nextThreadNum = 0;
    private static ThreadLocal<Object> uniqueThreadNum = new ThreadLocal<Object>(){

        @Override
        protected synchronized Object initialValue() {
            int n = nextThreadNum;
            nextThreadNum = n + 1;
            return n;
        }
    };
    private List<Listener> listeners = new ArrayList<Listener>();
    private List<ICollectionIdListener> collectionIdListeners = new ArrayList<ICollectionIdListener>();
    public static final String ID = "com.ibm.cics.ia.runtime";
    private static IAPlugin plugin;
    public static List<MultiStatus> statusStack;
    public static final String PLUGIN_ID = "com.ibm.cics.ia.ui";
    public static final String CICS_DATA = "CICS_DATA";
    public static final String DB2_DATA = "DB2_DATA";
    public static final String IMS_DATA = "IMS_DATA";
    public static final String MQ_DATA = "MQ_DATA";
    public static final String AFFINITY_DATA = "AFFINITY_DATA";
    public static final String CMDFLOW_DATA = "CMDFLOW_DATA";
    public static final String NATURAL_DATA = "NATURAL_DATA";
    public static final String SERVER_NAME = "SERVER_NAME";
    public static final String DATABASE_NAME = "DATABASE_NAME";
    public static final String USER_ID = "USER_ID";
    public static final String COLLECTOR_AUTH_STRING = "COLLECTOR_AUTH_STRING";
    public static final String HISTORY_CACHE_SIZE = "HISTORY_CACHE_SIZE";
    public static final String SCHEMA_NAME = "SCHEMA_NAME";
    public static final String PORT_NUMBER = "PORT_NUMBER";
    public static final String LOG_COMMAND_PREF = "LOG_COMMAND";
    public static final String PAGE_SIZE = "PAGE_SIZE";
    public static final String INTERNAL_USE_ONLY_FILE_PREFIX = "INTERNAL_USE_ONLY_FILE_PREFIX";
    public static final String CONNECTIONS = "connections";
    public boolean logSQL;
    public boolean logCommand;
    private IConnectionPasswordStorage passwordStorage;
    private String qualifier = "com.ibm.cics.ia.runtime";
    public static final String WSAA_IMS_PSB_DETAIL_URL = "http://{0}:{1}/dmh/UrlApi?View=Summary&AssetType=ImsTransaction&s_Name={2}&RedirectSingle=Y";
    public static final String WSAA_TRANSACTION_SUMMARY_URL = "http://{0}:{1}/dmh/UrlApi?View=TransactionSummary&AssetType=CicsTransaction&s_Name={2}&RedirectSingle=Y";
    public static final String WSAA_PROGRAM_DETAIL_URL = "http://{0}:{1}/dmh/UrlApi?View=Summary&AssetType=Program&s_Name={2}&RedirectSingle=Y";
    public static final String WSAA_SERVER_NAME = "WSAA_SERVER_NAME";
    public static final String WSAA_PORT_NUMBER = "WSAA_PORT_NUMBER";
    private static String debugPrefix;
    private static Map<Integer, MultiStatus> threadIDsToStatus;
    public static final String IA_CONNECTION_CATEGORY = "com.ibm.cics.ia.connection.db2";
    public static final String IA_ATOM_CONNECTION_CATEGORY = "com.ibm.cics.ia.connection.atom";
    public static final String DB2_CONNECTION_DESCRIPTOR = "com.ibm.cics.ia.connection.db2";
    public static final String IACONNECTION = "IACONNECTION";
    private static boolean DEBUG_GENERAL;
    public static final String OPTION_DEBUG_GENERAL;

    static {
        statusStack = new ArrayList<MultiStatus>();
        debugPrefix = "com.ibm.cics.ia.runtime/";
        threadIDsToStatus = new HashMap<Integer, MultiStatus>();
        OPTION_DEBUG_GENERAL = String.valueOf(debugPrefix) + "general";
        DEBUG_GENERAL = IAPlugin.getBooleanOption(OPTION_DEBUG_GENERAL, true);
    }

    private static boolean getBooleanOption(String option, boolean defaultValue) {
        String optionValue = Platform.getDebugOption((String)option);
        if (optionValue != null) {
            return optionValue.equalsIgnoreCase("true");
        }
        return defaultValue;
    }

    public IAPlugin() {
        plugin = this;
        this.logSQL = "true".equals(Platform.getDebugOption((String)(String.valueOf(debugPrefix) + "logSQL")));
        this.logCommand = "true".equals(Platform.getDebugOption((String)(String.valueOf(debugPrefix) + "logCommand")));
    }

    public void setLogSQL(boolean aBoolean) {
        this.logSQL = aBoolean;
        for (Listener listener : this.listeners) {
            listener.logSQLChanged(this.logSQL);
        }
    }

    public void setLogCommand(boolean aBoolean) {
        this.logCommand = aBoolean;
        for (Listener listener : this.listeners) {
            listener.logCommandChanged(this.logCommand);
        }
    }

    public void addListener(Listener aListener) {
        this.listeners.add(aListener);
    }

    public void removeListener(Listener aListener) {
        this.listeners.remove(aListener);
    }

    public void addCollectionIDListener(ICollectionIdListener listener) {
        this.collectionIdListeners.add(listener);
    }

    public void removeCollectionIDListener(ICollectionIdListener listener) {
        this.collectionIdListeners.remove(listener);
    }

    public boolean isCommandLoggingActive() {
        return this.logCommand;
    }

    public boolean isSQLLoggingActive() {
        return this.logSQL;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        DB2Host.getDefault((String)"com.ibm.cics.ia.connection.db2").disconnect();
        plugin = null;
    }

    public static IAPlugin getDefault() {
        return plugin;
    }

    private static MultiStatus getStatus(Integer key, String message) {
        return threadIDsToStatus.get(key);
    }

    public void clearLogging() {
        threadIDsToStatus.clear();
    }

    public void logInformation(String message) {
        this.logMessage(message, 1, null);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Logger logger = Logger.getLogger("com.ibm.cics.ia");
        if (DEBUG_GENERAL) {
            logger.setLevel(Level.FINER);
        }
        logger.setUseParentHandlers(true);
        logger = Logger.getLogger(ID);
        logger.setUseParentHandlers(true);
        if (DEBUG_GENERAL) {
            logger.setLevel(Level.FINER);
        }
        try {
            Class.forName("com.ibm.db2.jcc.DB2Driver");
        }
        catch (ClassNotFoundException e) {
            Debug.event((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"start", (Object)e);
        }
    }

    public void logMessage(String message, int severity, Throwable e) {
        Integer key = (Integer)uniqueThreadNum.get();
        MultiStatus existingStatus = IAPlugin.getStatus(key, message);
        if (existingStatus == null) {
            existingStatus = new MultiStatus(ID, severity, message, e);
            threadIDsToStatus.put(key, existingStatus);
            this.getLog().log((IStatus)existingStatus);
            for (Listener listener : this.listeners) {
                listener.logStatus(existingStatus);
            }
        } else {
            Status status = new Status(severity, ID, message, e);
            this.getLog().log((IStatus)status);
            existingStatus.add((IStatus)status);
            for (Listener listener : this.listeners) {
                listener.logStatus(existingStatus, status);
            }
        }
    }

    public void taskEnded() {
        Integer key = (Integer)uniqueThreadNum.get();
        threadIDsToStatus.remove(key);
    }

    public void logError(String message, Throwable e) {
        this.logMessage(message, 4, e);
    }

    public static void pushLog(String message) {
        MultiStatus status = new MultiStatus(ID, 1, message, null);
        statusStack.add(status);
        IAPlugin.getDefault().getLog().log((IStatus)status);
    }

    public static void popLog() {
        statusStack.remove(statusStack.size() - 1);
    }

    public IProject getRootProject() {
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            IProject newStyleProject = root.getProject("Interdependency Analyzer Queries");
            if (!newStyleProject.exists()) {
                newStyleProject.create(null);
            }
            newStyleProject.open(null);
            return newStyleProject;
        }
        catch (CoreException exc) {
            IAPlugin.getDefault().logError("Unable to open folder containing the queries", exc);
            return null;
        }
    }

    public void fireCollectionIdChanged(String newCollectionId) {
        for (ICollectionIdListener listener : this.collectionIdListeners) {
            listener.collectionIdChanged(newCollectionId);
        }
    }

    public IConnectionPasswordStorage getPasswordStorage() {
        if (this.passwordStorage == null) {
            this.passwordStorage = IConnectionPasswordStorage.Factory.create((String)this.qualifier);
        }
        return this.passwordStorage;
    }

    public static interface Listener {
        public void logStatus(MultiStatus var1);

        public void logStatus(MultiStatus var1, Status var2);

        public void logSQLChanged(boolean var1);

        public void logCommandChanged(boolean var1);
    }
}

