/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.runtime;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.eclipse.common.ViewHelper;
import com.ibm.cics.ia.runtime.IAtomControllerListener;
import com.ibm.cics.ia.sm.comm.AtomConnectable;
import com.ibm.cics.ia.sm.comm.IAtomConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Display;

public class AtomController {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(AtomController.class.getPackage().getName());
    private static AtomController instance = null;
    private HashMap<String, IConnection> connections = new HashMap();
    private List<IAtomControllerListener> listeners = new ArrayList<IAtomControllerListener>();

    private AtomController() {
    }

    public static AtomController getInstance() {
        if (instance == null) {
            instance = new AtomController();
        }
        return instance;
    }

    public void connected(IConnectable connectable) {
        Debug.enter((Logger)logger, (String)AtomController.class.getName(), (String)"connected", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "connection: " + (connectable.getConnection() == null ? connectable : connectable.getConnection().getName())});
        IConnection connection = connectable.getConnection();
        if (connection != null) {
            String connectionID = connection.getConfiguration().getID();
            this.connections.put(connectionID, connectable.getConnection());
            for (IAtomControllerListener listener : this.listeners) {
                listener.connected(connection);
            }
        }
        Debug.exit((Logger)logger, (String)AtomController.class.getName(), (String)"connected");
    }

    public void disconnected(IConnectable connectable) {
        Debug.enter((Logger)logger, (String)AtomController.class.getName(), (String)"disconnected", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "connection: " + (connectable.getConnection() == null ? connectable : connectable.getConnection().getName())});
        IConnection connection = connectable.getConnection();
        if (connection != null) {
            String connectionID = connection.getConfiguration().getID();
            if (this.connections.containsKey(connectionID)) {
                this.connections.remove(connectionID);
            }
            for (IAtomControllerListener listener : this.listeners) {
                listener.disconnected(connection);
            }
        }
        Debug.exit((Logger)logger, (String)AtomController.class.getName(), (String)"disconnected");
    }

    public Collection<IConnection> getConnections() {
        Debug.enter((Logger)logger, (String)AtomController.class.getName(), (String)"getConnections", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Set<Map.Entry<String, IConnection>> entrySet = this.connections.entrySet();
        Iterator<Map.Entry<String, IConnection>> iter = entrySet.iterator();
        while (iter.hasNext()) {
            Map.Entry<String, IConnection> entry = iter.next();
            IConnection connection = entry.getValue();
            List connConfigurations = ConnectionsPlugin.getDefault().getConnectionService().getConnectionManager().getConnectionProfiles("com.ibm.cics.ia.collectorConnection");
            ConnectionConfiguration conf = connection.getConfiguration();
            boolean exists = false;
            for (ConnectionProfile conf2 : connConfigurations) {
                if (!conf.getID().equals(conf2.getId())) continue;
                exists = true;
            }
            if (exists) continue;
            iter.remove();
        }
        Collection<IConnection> result = this.connections.values();
        Debug.exit((Logger)logger, (String)AtomController.class.getName(), (String)"getConnections", (Object)("result size: " + result.size()));
        return result;
    }

    public IConnection getConnection(String connectionID) {
        return this.connections.get(connectionID);
    }

    public void disconnect(final IAtomConnection connection) {
        Debug.enter((Logger)logger, (String)AtomController.class.getName(), (String)"disconnect", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Display.getDefault().asyncExec(new Runnable(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void run() {
                block9: {
                    block8: {
                        Debug.enter((Logger)AtomController.access$0(), (String)"AtomController.disconnect.Runnable", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                        conf = connection.getConfiguration();
                        if (conf != null) {
                            AtomController.access$1(AtomController.this).remove(conf.getID());
                        }
                        try {
                            try {
                                AtomConnectable.getDefault().setConnection(connection);
                                connection.disconnect();
                                break block8;
                            }
                            catch (ConnectionException e) {
                                str = e.getMessage();
                                AtomConnectable.getDefault().exception((Exception)e);
                                ViewHelper.setDeferredStatusErrorMessage((String)str);
                                ** for (listener : AtomController.access$2((AtomController)AtomController.this))
                            }
                        }
                        catch (Throwable var4_10) {
                            ** for (listener : AtomController.access$2((AtomController)AtomController.this))
                        }
lbl-1000:
                        // 1 sources

                        {
                            listener.disconnected(connection);
                            continue;
lbl18:
                            // 1 sources

                            break block9;
                        }
lbl-1000:
                        // 1 sources

                        {
                            listener.disconnected(connection);
                            continue;
                        }
lbl23:
                        // 1 sources

                        throw var4_10;
                    }
                    for (IAtomControllerListener listener : AtomController.access$2(AtomController.this)) {
                        listener.disconnected(connection);
                    }
                }
                Debug.exit((Logger)AtomController.access$0(), (String)"AtomController.disconnect.Runnable", (String)"run");
            }
        });
        Debug.exit((Logger)logger, (String)AtomController.class.getName(), (String)"disconnect");
    }

    public void disconnect(final IAtomConnection connection, final int respCode, final String respMessage) {
        Debug.enter((Logger)logger, (String)AtomController.class.getName(), (String)"disconnect", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "connection: " + connection.getName(), "respCode: " + respCode, "respMessage: " + respMessage});
        Display.getDefault().asyncExec(new Runnable(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void run() {
                block9: {
                    block8: {
                        Debug.enter((Logger)AtomController.access$0(), (String)"AtomController.disconnect.Runnable", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                        conf = connection.getConfiguration();
                        if (conf != null) {
                            AtomController.access$1(AtomController.this).remove(conf.getID());
                        }
                        try {
                            try {
                                AtomConnectable.getDefault().setConnection(connection);
                                connection.disconnect(respCode, respMessage);
                                break block8;
                            }
                            catch (ConnectionException e) {
                                Debug.warning((Logger)AtomController.access$0(), (String)AtomController.class.getName(), (String)"disconnect", (String)"connection exception", (Throwable)e);
                                str = e.getMessage();
                                AtomConnectable.getDefault().exception((Exception)e);
                                ViewHelper.setDeferredStatusErrorMessage((String)str);
                                ** for (listener : AtomController.access$2((AtomController)AtomController.this))
                            }
                        }
                        catch (Throwable var4_10) {
                            ** for (listener : AtomController.access$2((AtomController)AtomController.this))
                        }
lbl-1000:
                        // 1 sources

                        {
                            listener.disconnected(connection);
                            continue;
lbl19:
                            // 1 sources

                            break block9;
                        }
lbl-1000:
                        // 1 sources

                        {
                            listener.disconnected(connection);
                            continue;
                        }
lbl24:
                        // 1 sources

                        throw var4_10;
                    }
                    for (IAtomControllerListener listener : AtomController.access$2(AtomController.this)) {
                        listener.disconnected(connection);
                    }
                }
                Debug.exit((Logger)AtomController.access$0(), (String)"AtomController.disconnect.Runnable", (String)"run");
            }
        });
        Debug.exit((Logger)logger, (String)AtomController.class.getName(), (String)"disconnect");
    }

    public void disconnect(final IAtomConnection connection, final Exception ex, final int respCode, final String respMessage) {
        Debug.enter((Logger)logger, (String)AtomController.class.getName(), (String)"disconnect", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "connection: " + connection.getName(), "exception: " + ex, "respCode: " + respCode, "respMessage: " + respMessage});
        Display.getDefault().asyncExec(new Runnable(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void run() {
                block11: {
                    block10: {
                        Debug.enter((Logger)AtomController.access$0(), (String)"AtomController.disconnect.Runnable", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                        conf = connection.getConfiguration();
                        if (conf != null) {
                            AtomController.access$1(AtomController.this).remove(conf.getID());
                        }
                        try {
                            try {
                                AtomConnectable.getDefault().setConnection(connection);
                                if (ex != null) {
                                    connection.disconnect(ex, respCode, respMessage);
                                } else {
                                    connection.disconnect();
                                }
                                break block10;
                            }
                            catch (ConnectionException e) {
                                Debug.warning((Logger)AtomController.access$0(), (String)AtomController.class.getName(), (String)"disconnect", (String)"connection exception", (Throwable)e);
                                str = e.getMessage();
                                AtomConnectable.getDefault().exception((Exception)e);
                                ViewHelper.setDeferredStatusErrorMessage((String)str);
                                ** for (listener : AtomController.access$2((AtomController)AtomController.this))
                            }
                        }
                        catch (Throwable var4_10) {
                            ** for (listener : AtomController.access$2((AtomController)AtomController.this))
                        }
lbl-1000:
                        // 1 sources

                        {
                            listener.disconnected(connection);
                            continue;
lbl22:
                            // 1 sources

                            break block11;
                        }
lbl-1000:
                        // 1 sources

                        {
                            listener.disconnected(connection);
                            continue;
                        }
lbl27:
                        // 1 sources

                        throw var4_10;
                    }
                    for (IAtomControllerListener listener : AtomController.access$2(AtomController.this)) {
                        listener.disconnected(connection);
                    }
                }
                Debug.exit((Logger)AtomController.access$0(), (String)"AtomController.disconnect.Runnable", (String)"run");
            }
        });
        Debug.exit((Logger)logger, (String)AtomController.class.getName(), (String)"disconnect");
    }

    public void addAtomControllerListener(IAtomControllerListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeAtomControllerListener(IAtomControllerListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    static /* synthetic */ Logger access$0() {
        return logger;
    }

    static /* synthetic */ HashMap access$1(AtomController atomController) {
        return atomController.connections;
    }

    static /* synthetic */ List access$2(AtomController atomController) {
        return atomController.listeners;
    }
}

