/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.query;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Direction;
import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.Selection;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IAdaptable;

public abstract class Query
implements IAdaptable {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(Query.class.getPackage().getName());
    public static final String QUERY_TYPE = "query_type";
    public static final String QUERY_TYPE_GENERIC = "com.ibm.cics.query.type.generic";
    public static final String QUERY_TYPE_CICS = "com.ibm.cics.query.type.cics";
    public static final String QUERY_TYPE_SCANNER = "com.ibm.cics.query.type.scanner";
    public static final String QUERY_TYPE_AFFINITY = "com.ibm.cics.query.type.affinity";
    public static final String QUERY_TYPE_DB2 = "com.ibm.cics.query.type.db2";
    public static final String QUERY_TYPE_IMS = "com.ibm.cics.query.type.ims";
    public static final String QUERY_TYPE_MQ = "com.ibm.cics.query.type.mq";
    public static final String QUERY_TYPE_COMMANDFLOW = "com.ibm.cics.query.type.commandflow";
    public static final String QUERY_TYPE_NATURAL = "com.ibm.cics.query.type.natural";

    public static Presentation createPresentation(String title, String table, String ... columns) {
        Debug.enter((Logger)logger, (String)Query.class.getName(), (String)"createPresentation", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "title: " + title, "table: " + table, "columns: " + columns});
        Selection selection = PresentationFactory.getInstance().createSelectForTable(table, null);
        Presentation presentation = PresentationFactory.getInstance().createPresentation(title, "", "", selection);
        selection.getSelect().setDistinct(true);
        String[] stringArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            String column = stringArray[n2];
            selection.getSelect().addSelectionColumn(column, table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
            selection.addOrderByCondition(column, table, Direction.ASC);
            ++n2;
        }
        Debug.exit((Logger)logger, (String)Query.class.getName(), (String)"createPresentation", (Object)new String[]{"presentation: " + presentation.getTitle(), "selection: " + selection.toString()});
        return presentation;
    }
}

