/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.query;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.TSApplication;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.util.logging.Logger;

public class InitialProgram2SubQuery {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(InitialProgram2SubQuery.class.getPackage().getName());
    private static final String[] inValues = new String[]{"LOAD", "LINK", "XCTL", "CALL"};
    private Presentation presentation;

    public InitialProgram2SubQuery(Transaction transaction, Region region) {
        this(transaction, region, null);
    }

    public InitialProgram2SubQuery(Transaction transaction, Region region, TSApplication tsApplication) {
        Debug.enter((Logger)logger, (String)InitialProgram2SubQuery.class.getName(), (String)"InitialProgram2SubQuery", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String title = transaction != null ? transaction.getName() : ("No tran-" + region != null ? region.getName() : "All regions");
        String table = IAUtilities.getCICSDataTableName();
        Selection selection = PresentationFactory.getInstance().createSelectForTable(table, null);
        selection.getSelect().setDistinct(true);
        selection.getSelect().addSelectionColumn("OBJECT", table, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        selection.appendCondition("FUNCTION", table, ColumnReference.DataType.String, Comparator.IN, (Object[])inValues, QueryElement.Predicate.AND, false);
        if (tsApplication != null) {
            selection.appendCondition("APPL_NAME", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{tsApplication.getName()}, QueryElement.Predicate.AND, false);
            selection.appendCondition("APPL_VER1", table, ColumnReference.DataType.Integer, Comparator.EQ, new Object[]{tsApplication.getMajorVersion()}, QueryElement.Predicate.AND, false);
            selection.appendCondition("APPL_VER2", table, ColumnReference.DataType.Integer, Comparator.EQ, new Object[]{tsApplication.getMinorVersion()}, QueryElement.Predicate.AND, false);
            selection.appendCondition("APPL_VER3", table, ColumnReference.DataType.Integer, Comparator.EQ, new Object[]{tsApplication.getMicroVersion()}, QueryElement.Predicate.AND, false);
        }
        if (transaction != null) {
            selection.appendCondition("TRANSID", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{transaction.getName()}, QueryElement.Predicate.AND, false);
        }
        selection.appendCondition("TYPE", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{"PROGRAM"}, QueryElement.Predicate.AND, false);
        if (region != null) {
            selection.appendCondition("APPLID", table, ColumnReference.DataType.String, Comparator.EQ, new Object[]{region.getName()}, QueryElement.Predicate.AND, false);
        }
        this.presentation = PresentationFactory.getInstance().createPresentation(title, "", "", selection);
        Debug.exit((Logger)logger, (String)InitialProgram2SubQuery.class.getName(), (String)"createQueryCommand");
    }

    public Presentation getPresentation() {
        return this.presentation;
    }
}

