/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.query;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.Clause;
import com.ibm.cics.dbfunc.model.ClauseGroup;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.ConstraintElement;
import com.ibm.cics.dbfunc.model.Values;
import com.ibm.cics.ia.query.Messages;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class ClauseToStringHelper {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ClauseToStringHelper.class.getPackage().getName());
    public static final String VALUE_TYPE = "VALUE_TYPE";
    public static final String VALUE_TYPE_DECIMAL = "DECIMAL";
    public static final String VALUE_TYPE_HEX = "HEX";
    public static final String VALUE_TYPE_DATE = "DATE";
    public static final String VALUE_TYPE_STRING = "STRING";

    public static String ClauseToUserString(Clause aClause, String valueType) {
        Debug.enter((Logger)logger, (String)ClauseToStringHelper.class.getName(), (String)"ClauseToUserString", (Object)("Thread ID: " + Thread.currentThread().getId()));
        StringBuilder clauseStringBuilder = new StringBuilder();
        boolean isDateTime = false;
        if (aClause.getColumns() != null) {
            List columnList = aClause.getColumns();
            Iterator columnIter = columnList.iterator();
            while (columnIter.hasNext()) {
                ColumnReference column = (ColumnReference)columnIter.next();
                String columnName = column.getColumnName();
                if (columnName.equals("FIRST_RUN") || columnName.equals("LAST_RUN") || columnName.equals("CMD_TIME_LOCAL")) {
                    isDateTime = true;
                }
                String messagePrefix = column.getTable().equals(IAUtilities.getCICSDataTableName()) ? "CICS.Column." : "Column.";
                String userColumnName = Messages.getString(String.valueOf(messagePrefix) + columnName);
                clauseStringBuilder.append(userColumnName);
                clauseStringBuilder.append(columnIter.hasNext() ? ", " : "");
            }
        }
        String columns = clauseStringBuilder.toString();
        clauseStringBuilder = new StringBuilder();
        if (aClause.getValues() != null) {
            List valuesList = aClause.getValues();
            Iterator valuesIter = valuesList.iterator();
            while (valuesIter.hasNext()) {
                Values values = (Values)valuesIter.next();
                Object value = values.getValue();
                String str = null;
                if (value != null) {
                    if (VALUE_TYPE_HEX.equals(valueType)) {
                        if (value instanceof Integer) {
                            value = (long)((Integer)value).intValue();
                        } else if (value instanceof String) {
                            value = Long.parseLong((String)value);
                        } else if (!(value instanceof Long)) {
                            value = 0L;
                        }
                        long valueLong = (Long)value;
                        str = valueLong == -1L ? "FFFFFFFF" : Long.toHexString(valueLong).toUpperCase();
                    } else if (VALUE_TYPE_DATE.equals(valueType)) {
                        Timestamp timestamp = (Timestamp)value;
                        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                        str = dateFormat.format(timestamp);
                    } else {
                        str = value.toString();
                        if (aClause.getColumns().size() == 1 && ((ColumnReference)aClause.getColumns().get(0)).getColumnName().equals("CMD_TCB_CPUTIME_BEFORE") || ((ColumnReference)aClause.getColumns().get(0)).getColumnName().equals("CMD_TCB_CPUTIME_AFTER")) {
                            try {
                                str = !str.equals("00000000000000000000") ? IAUtilities.getTodMilliseconds(str.trim()).toPlainString() : "";
                            }
                            catch (NumberFormatException e) {
                                str = "";
                            }
                        }
                        str = str.replace("%", "*");
                    }
                } else {
                    str = Messages.getString("FieldExpression.nullString");
                }
                if (str == null) {
                    str = Messages.getString("FieldExpression.emptyString");
                } else if (str.equals("")) {
                    str = Messages.getString("FieldExpression.blankString");
                }
                clauseStringBuilder.append(str);
                clauseStringBuilder.append(valuesIter.hasNext() ? ", " : "");
            }
        }
        String values = clauseStringBuilder.toString();
        String result = ClauseToStringHelper.getClauseStr(aClause, columns, values, isDateTime);
        Debug.exit((Logger)logger, (String)ClauseToStringHelper.class.getName(), (String)"ClauseToUserString", (Object)("Result: " + result));
        return result;
    }

    public static String ClauseGroupToUserString(ClauseGroup expression, String valueType) {
        Debug.enter((Logger)logger, (String)ClauseToStringHelper.class.getName(), (String)"ClauseGroupToUserString", (Object)("Thread ID: " + Thread.currentThread().getId()));
        StringBuilder clauseStringBuilder = new StringBuilder();
        List constraints = expression.getClauses();
        Iterator constraintsIter = constraints.iterator();
        ArrayList<Clause> clauses = new ArrayList<Clause>();
        while (constraintsIter.hasNext()) {
            ConstraintElement constraint = (ConstraintElement)constraintsIter.next();
            if (!(constraint instanceof Clause)) continue;
            clauses.add((Clause)constraint);
        }
        Iterator<Clause> clausesIter = clauses.iterator();
        if (clausesIter.hasNext()) {
            Clause firstClause = (Clause)clausesIter.next();
            boolean isDateTime = false;
            if (firstClause.getColumns() != null) {
                List columnList = firstClause.getColumns();
                Iterator columnIter = columnList.iterator();
                while (columnIter.hasNext()) {
                    ColumnReference column = (ColumnReference)columnIter.next();
                    String columnName = column.getColumnName();
                    if (columnName.equals("FIRST_RUN") || columnName.equals("LAST_RUN")) {
                        isDateTime = true;
                    }
                    String messagePrefix = column.getTable().equals(IAUtilities.getCICSDataTableName()) ? "CICS.Column." : "Column.";
                    String userColumnName = Messages.getString(String.valueOf(messagePrefix) + columnName);
                    clauseStringBuilder.append(userColumnName);
                    clauseStringBuilder.append(columnIter.hasNext() ? ", " : "");
                }
            }
            String columns = clauseStringBuilder.toString();
            clauseStringBuilder = new StringBuilder();
            if (firstClause.getValues() != null) {
                List valuesList = firstClause.getValues();
                Iterator<Values> valuesIter = valuesList.iterator();
                while (valuesIter.hasNext()) {
                    Values values = (Values)valuesIter.next();
                    Object value = values.getValue();
                    String str = null;
                    if (VALUE_TYPE_HEX.equals(valueType)) {
                        if (value instanceof Integer) {
                            value = (long)((Integer)value).intValue();
                        } else if (value instanceof String) {
                            value = Long.parseLong((String)value);
                        } else if (!(value instanceof Long)) {
                            value = 0L;
                        }
                        long valueLong = (Long)value;
                        str = valueLong == -1L ? "FFFFFFFF" : Long.toHexString(valueLong).toUpperCase();
                    } else {
                        str = value.toString();
                    }
                    str = ClauseToStringHelper.convertString(str, clauseStringBuilder, valuesIter, clausesIter);
                    clauseStringBuilder.append(str);
                    if (valuesIter.hasNext()) {
                        clauseStringBuilder.append(", ");
                        continue;
                    }
                    if (!clausesIter.hasNext()) continue;
                    clauseStringBuilder.append(", ");
                }
            }
            while (clausesIter.hasNext()) {
                Clause nextClause = (Clause)clausesIter.next();
                if (nextClause.getValues() == null) continue;
                List valuesList = nextClause.getValues();
                Iterator<Values> valuesIter = valuesList.iterator();
                while (valuesIter.hasNext()) {
                    Values values = (Values)valuesIter.next();
                    Object value = values.getValue();
                    String str = value.toString();
                    str = ClauseToStringHelper.convertString(str, clauseStringBuilder, valuesIter, clausesIter);
                    clauseStringBuilder.append(str);
                    if (valuesIter.hasNext()) {
                        clauseStringBuilder.append(", ");
                        continue;
                    }
                    if (!clausesIter.hasNext()) continue;
                    clauseStringBuilder.append(", ");
                }
            }
            String values = clauseStringBuilder.toString();
            String result = ClauseToStringHelper.getClauseStr(firstClause, columns, values, isDateTime);
            Debug.exit((Logger)logger, (String)ClauseToStringHelper.class.getName(), (String)"ClauseGroupToUserString", (Object)("Result: " + result));
            return result;
        }
        return null;
    }

    private static String convertString(String str, StringBuilder clauseStringBuilder, Iterator<Values> valuesIter, Iterator<Clause> clausesIter) {
        Debug.enter((Logger)logger, (String)ClauseToStringHelper.class.getName(), (String)"convertString", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (str == null) {
            str = Messages.getString("FieldExpression.emptyString");
        } else if (str.equals("")) {
            str = Messages.getString("FieldExpression.blankString");
        }
        Debug.exit((Logger)logger, (String)ClauseToStringHelper.class.getName(), (String)"convertString");
        return str;
    }

    private static String getClauseStr(Clause aClause, String columns, String values, boolean isDateTime) {
        if (aClause.getComparator() != null) {
            Comparator comparator = aClause.getComparator();
            boolean isNot = aClause.isNot();
            String operator = "";
            String expression = "";
            if (comparator.equals((Object)Comparator.EQ)) {
                operator = isNot ? Messages.getString("FieldExpression.isNot") : Messages.getString("FieldExpression.is");
                expression = isNot ? Messages.getString("FieldExpression.isNotExp") : Messages.getString("FieldExpression.isExp");
            } else if (comparator.equals((Object)Comparator.GT)) {
                operator = isDateTime ? Messages.getString("FieldExpression.isAfter") : Messages.getString("FieldExpression.isGreater");
                expression = isDateTime ? Messages.getString("FieldExpression.isAfterExp") : Messages.getString("FieldExpression.isGreaterExp");
            } else if (comparator.equals((Object)Comparator.GE)) {
                operator = isDateTime ? Messages.getString("FieldExpression.isAtOrAfter") : Messages.getString("FieldExpression.isGreaterOrEqual");
                expression = isDateTime ? Messages.getString("FieldExpression.isAtOrAfterExp") : Messages.getString("FieldExpression.isGreaterOrEqualExp");
            } else if (comparator.equals((Object)Comparator.LT)) {
                operator = isDateTime ? Messages.getString("FieldExpression.isBef") : Messages.getString("FieldExpression.isLess");
                expression = isDateTime ? Messages.getString("FieldExpression.isBefExp") : Messages.getString("FieldExpression.isLessExp");
            } else if (comparator.equals((Object)Comparator.LE)) {
                operator = isDateTime ? Messages.getString("FieldExpression.isAtOrBef") : Messages.getString("FieldExpression.isLessOrEqual");
                expression = isDateTime ? Messages.getString("FieldExpression.isAtOrBefExp") : Messages.getString("FieldExpression.isLessOrEqualExp");
            } else if (comparator.equals((Object)Comparator.LI)) {
                operator = isNot ? Messages.getString("FieldExpression.isNot") : Messages.getString("FieldExpression.is");
                expression = isNot ? Messages.getString("FieldExpression.isNotExp") : Messages.getString("FieldExpression.isExp");
            } else if (comparator.equals((Object)Comparator.IN)) {
                operator = isNot ? Messages.getString("FieldExpression.isNot") : Messages.getString("FieldExpression.is");
                expression = isNot ? Messages.getString("FieldExpression.isNotExp") : Messages.getString("FieldExpression.isExp");
            }
            return MessageFormat.format(expression, columns, operator, values);
        }
        return null;
    }
}

