/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model.webservice;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

public class SoapHandler
implements SOAPHandler<SOAPMessageContext> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(SoapHandler.class.getPackage().getName());
    private static Pattern HTTP_RESPONSE_PATTERN = Pattern.compile("HTTP.*?\\s[0-9]+\\s(.+)");
    private int lastHttpResponseCode = 0;
    private String lastHttpResponseMsg = "";

    public Set<QName> getHeaders() {
        return Collections.emptySet();
    }

    public boolean handleMessage(SOAPMessageContext messageContext) {
        return true;
    }

    public boolean handleFault(SOAPMessageContext messageContext) {
        return true;
    }

    public void close(MessageContext messageContext) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"close", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.lastHttpResponseCode = (Integer)messageContext.get((Object)"javax.xml.ws.http.response.code");
        Map headers = (Map)messageContext.get((Object)"javax.xml.ws.http.response.headers");
        for (Map.Entry entry : headers.entrySet()) {
            for (String value : (List)entry.getValue()) {
                String httpResponseMessage = SoapHandler.extractResponseMessage(value);
                if (!IAUtilities.hasContent(httpResponseMessage)) continue;
                this.lastHttpResponseMsg = httpResponseMessage;
                Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"close");
                return;
            }
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"sendServiceCommand");
    }

    private static String extractResponseMessage(String header) {
        Debug.enter((Logger)logger, (String)SoapHandler.class.getName(), (String)"extractResponseMessage", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Matcher matcher = HTTP_RESPONSE_PATTERN.matcher(header);
        if (matcher.find()) {
            Debug.exit((Logger)logger, (String)SoapHandler.class.getName(), (String)"extractResponseMessage");
            return matcher.group(1);
        }
        Debug.exit((Logger)logger, (String)SoapHandler.class.getName(), (String)"extractResponseMessage");
        return null;
    }

    public int getLastHttpResponseCode() {
        return this.lastHttpResponseCode;
    }

    public String getLastHttpResponseMsg() {
        return this.lastHttpResponseMsg;
    }
}

