/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model.webservice;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.webservice.CIUAWSDAPort;
import com.ibm.cics.ia.model.webservice.CIUAWSDARequestProgramInterface;
import com.ibm.cics.ia.model.webservice.CIUAWSDAResponseProgramInterface;
import com.ibm.cics.ia.model.webservice.CIUAWSDAService;
import com.ibm.cics.ia.model.webservice.CiuawsdaServiceResponse;
import com.ibm.cics.ia.model.webservice.SoapHandler;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceClient;
import org.xml.sax.SAXException;

public final class CIUAWSDAClient {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CIUAWSDAClient.class.getPackage().getName());
    private static final QName SERVICE_NAME = new QName("http://www.CIUAWSDA.CIUAWSDI.com", "CIUAWSDAService");
    private static final String CIUAWSDA_SERVICE_RESPONSE_TAG = CiuawsdaServiceResponse.class.getAnnotation(XmlRootElement.class).name();
    private CIUAWSDAPort port;
    private Unmarshaller unmarshaller;
    private SoapHandler soapHandler;

    public CIUAWSDAClient(String hostName, int portNumber, String userName, String passVar, Boolean ssl) throws MalformedURLException, JAXBException, SAXException {
        URL wsdlLocation = new URL(CIUAWSDAService.class.getAnnotation(WebServiceClient.class).wsdlLocation());
        ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            CIUAWSDAService service = new CIUAWSDAService(wsdlLocation, SERVICE_NAME);
            this.port = service.getCIUAWSDAPort();
        }
        finally {
            if (originalContextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(originalContextClassLoader);
            }
        }
        BindingProvider bindingProvider = (BindingProvider)this.port;
        if (ssl.booleanValue()) {
            bindingProvider.getRequestContext().put("javax.xml.ws.service.endpoint.address", "https://" + hostName + ":" + portNumber + "/cics/services/DependencyOperation");
        } else {
            bindingProvider.getRequestContext().put("javax.xml.ws.service.endpoint.address", "http://" + hostName + ":" + portNumber + "/cics/services/DependencyOperation");
        }
        bindingProvider.getRequestContext().put("javax.xml.ws.security.auth.username", userName);
        bindingProvider.getRequestContext().put("javax.xml.ws.security.auth.password", passVar);
        Binding binding = bindingProvider.getBinding();
        List handlerList = binding.getHandlerChain();
        this.soapHandler = new SoapHandler();
        handlerList.add(this.soapHandler);
        binding.setHandlerChain(handlerList);
        if (this.unmarshaller == null) {
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{CiuawsdaServiceResponse.class});
                this.unmarshaller = jaxbContext.createUnmarshaller();
            }
            finally {
                if (originalContextClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(originalContextClassLoader);
                }
            }
        }
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new URL("platform:/plugin/com.ibm.cics.ia.runtime/ciuawsdaServiceResponse.xsd"));
        this.unmarshaller.setSchema(schema);
    }

    public String getLastHttpResponseMsg() {
        return this.soapHandler.getLastHttpResponseMsg();
    }

    public int getLastHttpResponseCode() {
        return this.soapHandler.getLastHttpResponseCode();
    }

    public CiuawsdaServiceResponse requestRegionList() throws JAXBException, SAXException, MalformedURLException {
        return this.sendServiceCommand("", "", "0");
    }

    public CiuawsdaServiceResponse startRegion(String applid, String sysid) throws JAXBException, SAXException, MalformedURLException {
        return this.sendServiceCommand(applid, sysid, "1");
    }

    public CiuawsdaServiceResponse stopRegion(String applid, String sysid) throws JAXBException, SAXException, MalformedURLException {
        return this.sendServiceCommand(applid, sysid, "2");
    }

    public CiuawsdaServiceResponse pauseRegion(String applid, String sysid) throws JAXBException, SAXException, MalformedURLException {
        return this.sendServiceCommand(applid, sysid, "3");
    }

    public CiuawsdaServiceResponse continueRegion(String applid, String sysid) throws JAXBException, SAXException, MalformedURLException {
        return this.sendServiceCommand(applid, sysid, "4");
    }

    public CiuawsdaServiceResponse reguestRegionProperties(String applid, String sysid) throws JAXBException, SAXException, MalformedURLException {
        return this.sendServiceCommand(applid, sysid, "5");
    }

    public CiuawsdaServiceResponse setRegionDefaults(String applid, String sysid) throws JAXBException, SAXException, MalformedURLException {
        return this.sendServiceCommand(applid, sysid, "Z");
    }

    public CiuawsdaServiceResponse saveAppOptions(String applId, String sysId, String applMode, String applCtxt, String applName, String applVer1, String applVer2, String applVer3) throws JAXBException, SAXException, MalformedURLException {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"saveAppOptions", (Object)("Thread ID: " + Thread.currentThread().getId()));
        CIUAWSDARequestProgramInterface.WsInBuf wsInBuf = new CIUAWSDARequestProgramInterface.WsInBuf();
        CIUAWSDARequestProgramInterface.WsInBuf.AppOptions appOptions = new CIUAWSDARequestProgramInterface.WsInBuf.AppOptions();
        appOptions.setAppMode(applMode != null ? applMode : "");
        appOptions.setAppCtxt(applCtxt != null ? applCtxt : "");
        appOptions.setAppName(applName != null ? applName : "");
        appOptions.setAppVer1(applVer1 != null ? applVer1 : "");
        appOptions.setAppVer2(applVer2 != null ? applVer2 : "");
        appOptions.setAppVer3(applVer3 != null ? applVer3 : "");
        wsInBuf.setAppOptions(appOptions);
        wsInBuf.setWsInCommand("6");
        wsInBuf.setWsInApplid(applId);
        wsInBuf.setWsInSysid(sysId);
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"saveAppOptions");
        return this.sendServiceCommand(wsInBuf);
    }

    public CiuawsdaServiceResponse startScenarioBasedCollection(CIUAWSDARequestProgramInterface.WsInBuf wsInBuf) throws MalformedURLException, JAXBException, SAXException {
        wsInBuf.setWsInCommand("9");
        return this.sendServiceCommand(wsInBuf);
    }

    public CiuawsdaServiceResponse reguestRegionPropertiesForEditing(String applid, String sysid) throws JAXBException, SAXException, MalformedURLException {
        return this.sendServiceCommand(applid, sysid, "7");
    }

    public CiuawsdaServiceResponse requestUsersList() throws JAXBException, SAXException, MalformedURLException {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"requestUsersList", (Object)("Thread ID: " + Thread.currentThread().getId()));
        CIUAWSDARequestProgramInterface.WsInBuf wsInBuf = new CIUAWSDARequestProgramInterface.WsInBuf();
        wsInBuf.setWsInCommand("8");
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"requestUsersList");
        return this.sendServiceCommand(wsInBuf);
    }

    public boolean isServiceAvailable() throws Exception {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"isServiceAvailable", (Object)("Thread ID: " + Thread.currentThread().getId()));
        CIUAWSDARequestProgramInterface.WsInBuf wsInBuf = new CIUAWSDARequestProgramInterface.WsInBuf();
        wsInBuf.setWsInCommand("a");
        CiuawsdaServiceResponse response = this.sendServiceCommand(wsInBuf);
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"isServiceAvailable");
        return true;
    }

    private CiuawsdaServiceResponse sendServiceCommand(CIUAWSDARequestProgramInterface.WsInBuf wsInBuf) throws JAXBException, SAXException, MalformedURLException {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"sendServiceCommand", (Object)("Thread ID: " + Thread.currentThread().getId()));
        CIUAWSDAResponseProgramInterface.WsOutBuf wsOutBuf = this.port.ciuawsdaOperation(wsInBuf);
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"sendServiceCommand");
        return (CiuawsdaServiceResponse)this.unmarshaller.unmarshal((Reader)new StringReader("<" + CIUAWSDA_SERVICE_RESPONSE_TAG + ">" + wsOutBuf.getBuf() + "</" + CIUAWSDA_SERVICE_RESPONSE_TAG + ">"));
    }

    private CiuawsdaServiceResponse sendServiceCommand(String applId, String sysId, String action) throws JAXBException, SAXException, MalformedURLException {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"sendServiceCommand", (Object)("Thread ID: " + Thread.currentThread().getId()));
        CIUAWSDARequestProgramInterface.WsInBuf wsInBuf = new CIUAWSDARequestProgramInterface.WsInBuf();
        wsInBuf.setWsInCommand(action);
        wsInBuf.setWsInApplid(applId);
        wsInBuf.setWsInSysid(sysId);
        CIUAWSDAResponseProgramInterface.WsOutBuf wsOutBuf = this.port.ciuawsdaOperation(wsInBuf);
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"sendServiceCommand");
        return (CiuawsdaServiceResponse)this.unmarshaller.unmarshal((Reader)new StringReader("<" + CIUAWSDA_SERVICE_RESPONSE_TAG + ">" + wsOutBuf.getBuf() + "</" + CIUAWSDA_SERVICE_RESPONSE_TAG + ">"));
    }
}

