/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model.webservice;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.webservice.CIUAWSCFPort;
import com.ibm.cics.ia.model.webservice.CIUAWSCFRequestProgramInterface;
import com.ibm.cics.ia.model.webservice.CIUAWSCFResponseProgramInterface;
import com.ibm.cics.ia.model.webservice.CIUAWSCFService;
import com.ibm.cics.ia.model.webservice.SoapHandler;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceClient;

public final class CIUAWSCFClient {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CIUAWSCFClient.class.getPackage().getName());
    private static final QName SERVICE_NAME = new QName("http://www.CIUAWSCF.CIUAWSCI.com", "CIUAWSCFService");
    private CIUAWSCFPort port;
    private SoapHandler soapHandler;

    public CIUAWSCFClient(String hostName, int portNumber, String userName, String passVar, Boolean ssl) throws MalformedURLException {
        URL wsdlLocation = new URL(CIUAWSCFService.class.getAnnotation(WebServiceClient.class).wsdlLocation());
        ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            CIUAWSCFService service = new CIUAWSCFService(wsdlLocation, SERVICE_NAME);
            this.port = service.getCIUAWSCFPort();
        }
        finally {
            if (originalContextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(originalContextClassLoader);
            }
        }
        BindingProvider bindingProvider = (BindingProvider)this.port;
        if (ssl.booleanValue()) {
            bindingProvider.getRequestContext().put("javax.xml.ws.service.endpoint.address", "https://" + hostName + ":" + portNumber + "/cics/services/CommandFlowOperation");
        } else {
            bindingProvider.getRequestContext().put("javax.xml.ws.service.endpoint.address", "http://" + hostName + ":" + portNumber + "/cics/services/CommandFlowOperation");
        }
        bindingProvider.getRequestContext().put("javax.xml.ws.security.auth.username", userName);
        bindingProvider.getRequestContext().put("javax.xml.ws.security.auth.password", passVar);
        Binding binding = bindingProvider.getBinding();
        List handlerList = binding.getHandlerChain();
        this.soapHandler = new SoapHandler();
        handlerList.add(this.soapHandler);
        binding.setHandlerChain(handlerList);
    }

    public String getLastHttpResponseMsg() {
        return this.soapHandler.getLastHttpResponseMsg();
    }

    public int getLastHttpResponseCode() {
        return this.soapHandler.getLastHttpResponseCode();
    }

    public CIUAWSCFResponseProgramInterface.CfOutBuf requestStatistic() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"requestStatistic", (Object)("Thread ID: " + Thread.currentThread().getId()));
        CIUAWSCFRequestProgramInterface.CfInBuf cfInBuf = new CIUAWSCFRequestProgramInterface.CfInBuf();
        cfInBuf.setInCommand("A");
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"requestStatistic");
        return this.port.ciuawscfOperation(cfInBuf);
    }

    public CIUAWSCFResponseProgramInterface.CfOutBuf startCollector() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"startCollector", (Object)("Thread ID: " + Thread.currentThread().getId()));
        CIUAWSCFRequestProgramInterface.CfInBuf cfInBuf = new CIUAWSCFRequestProgramInterface.CfInBuf();
        cfInBuf.setInCommand("B");
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"startCollector");
        return this.port.ciuawscfOperation(cfInBuf);
    }

    public CIUAWSCFResponseProgramInterface.CfOutBuf stopCollector() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"stopCollector", (Object)("Thread ID: " + Thread.currentThread().getId()));
        CIUAWSCFRequestProgramInterface.CfInBuf cfInBuf = new CIUAWSCFRequestProgramInterface.CfInBuf();
        cfInBuf.setInCommand("C");
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"stopCollector");
        return this.port.ciuawscfOperation(cfInBuf);
    }

    public CIUAWSCFResponseProgramInterface.CfOutBuf requestDetails(String userId) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"requestDetails", (Object)("Thread ID: " + Thread.currentThread().getId()));
        CIUAWSCFRequestProgramInterface.CfInBuf cfInBuf = new CIUAWSCFRequestProgramInterface.CfInBuf();
        cfInBuf.setInUser(userId);
        cfInBuf.setInCommand("D");
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"requestDetails");
        return this.port.ciuawscfOperation(cfInBuf);
    }

    public CIUAWSCFResponseProgramInterface.CfOutBuf saveDetails(CIUAWSCFRequestProgramInterface.CfInBuf cfInBuf) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"saveDetails", (Object)("Thread ID: " + Thread.currentThread().getId()));
        cfInBuf.setInCommand("E");
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"saveDetails");
        return this.port.ciuawscfOperation(cfInBuf);
    }

    public boolean isServiceAvailable() throws Exception {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"isServiceAvailable", (Object)("Thread ID: " + Thread.currentThread().getId()));
        CIUAWSCFRequestProgramInterface.CfInBuf cfInBuf = new CIUAWSCFRequestProgramInterface.CfInBuf();
        cfInBuf.setInCommand("z");
        CIUAWSCFResponseProgramInterface.CfOutBuf cfOutBuf = this.port.ciuawscfOperation(cfInBuf);
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"isServiceAvailable");
        return true;
    }
}

