/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model.viz;

import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.viz.INestedNode;
import com.ibm.cics.ia.model.viz.INode;
import com.ibm.cics.ia.model.viz.Node;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class TreeNestedNode<T>
extends Node<T>
implements INestedNode<T> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected TreeMap<Comparable, INode> children = new TreeMap();

    @Override
    public Map getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(Map children) {
        this.children = (TreeMap)children;
        this.fireModelChanged();
    }

    @Override
    public List getAll() {
        ArrayList<INode> nodes = new ArrayList<INode>();
        for (INode node : this.children.values()) {
            nodes.add(node);
            if (!(node instanceof INestedNode)) continue;
            nodes.addAll(((INestedNode)node).getAll());
        }
        return nodes;
    }

    @Override
    public List getAll(Object o) {
        ArrayList<INode> nodes = new ArrayList<INode>();
        for (INode node : this.children.values()) {
            if (node.getObject().getClass().equals(o.getClass())) {
                nodes.add(node);
            }
            if (!(node instanceof INestedNode)) continue;
            nodes.addAll(((INestedNode)node).getAll(o));
        }
        return nodes;
    }

    @Override
    public void removeAll(Class clazz) {
        Iterator it = this.getChildren().values().iterator();
        while (it.hasNext()) {
            INode node = (INode)it.next();
            if (node instanceof INestedNode) {
                ((INestedNode)node).removeAll(clazz);
                continue;
            }
            if (!node.getObject().getClass().equals(clazz)) continue;
            it.remove();
        }
    }

    @Override
    public void removeAll(String typeName) {
        Iterator it = this.getChildren().values().iterator();
        while (it.hasNext()) {
            INode node = (INode)it.next();
            if (node instanceof INestedNode) {
                ((INestedNode)node).removeAll(typeName);
                continue;
            }
            if (!(node.getObject() instanceof Resource) || !((Resource)node.getObject()).getTypeName().equals(typeName)) continue;
            it.remove();
        }
    }
}

