/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model.viz;

import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.viz.IModelChangeListener;
import com.ibm.cics.ia.model.viz.INestedNode;
import com.ibm.cics.ia.model.viz.INode;
import com.ibm.cics.ia.model.viz.NodeConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RootNode<T>
implements INestedNode<T> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected LinkedHashMap<Object, INode> children = new LinkedHashMap();
    private ArrayList<IModelChangeListener> listeners = new ArrayList();
    private Object object;
    private HashMap data = new HashMap();
    public static final String CONTEXT_REGION = "CONTEXT_REGION";
    public static final String CONTEXT_PLATFORM = "CONTEXT_PLATFORM";
    public static final String CONTEXT_APPLICATION = "CONTEXT_APPLICATION";

    @Override
    public INestedNode getParent() {
        return null;
    }

    @Override
    public void setParent(INestedNode resourceNode) {
    }

    public void setResource(Resource aResource) {
    }

    @Override
    public Map getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(Map children) {
        this.children = (LinkedHashMap)children;
    }

    @Override
    public void addModelChangeListener(IModelChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeModelChangeListener(IModelChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void fireModelChanged() {
        for (IModelChangeListener listener : this.listeners) {
            listener.onModelChanged(this);
        }
    }

    @Override
    public List<NodeConnection> getIncomingConnections() {
        return null;
    }

    @Override
    public List<NodeConnection> getOutgoingConnections() {
        return null;
    }

    public void setId(int id) {
    }

    public int getId() {
        return 0;
    }

    public void setSelected(boolean selected) {
    }

    public boolean isSelected() {
        return false;
    }

    @Override
    public T getObject() {
        return (T)this.object;
    }

    @Override
    public void setObject(T anObject) {
        this.object = anObject;
    }

    @Override
    public int compareTo(INode o) {
        return 0;
    }

    @Override
    public List getAll() {
        ArrayList<INode> nodes = new ArrayList<INode>();
        for (INode node : this.children.values()) {
            nodes.add(node);
            if (!(node instanceof INestedNode)) continue;
            nodes.addAll(((INestedNode)node).getAll());
        }
        return nodes;
    }

    @Override
    public List getAll(Object o) {
        ArrayList<INode> nodes = new ArrayList<INode>();
        for (INode node : this.children.values()) {
            if (node.getObject().getClass().equals(o.getClass())) {
                nodes.add(node);
            }
            if (!(node instanceof INestedNode)) continue;
            nodes.addAll(((INestedNode)node).getAll(o));
        }
        return nodes;
    }

    @Override
    public void removeAll(Class clazz) {
        Iterator it = this.getChildren().values().iterator();
        while (it.hasNext()) {
            INode sibling;
            INode node = (INode)it.next();
            if (node instanceof INestedNode) {
                ((INestedNode)node).removeAll(clazz);
                continue;
            }
            if (!node.getObject().getClass().equals(clazz)) continue;
            List<NodeConnection> list = node.getOutgoingConnections();
            for (NodeConnection connection : list) {
                sibling = connection.getTarget();
                sibling.getIncomingConnections().remove(connection);
            }
            list.clear();
            list = node.getIncomingConnections();
            for (NodeConnection connection : list) {
                sibling = connection.getSource();
                sibling.getOutgoingConnections().remove(connection);
            }
            list.clear();
            it.remove();
        }
    }

    @Override
    public void removeAll(String typeName) {
        Iterator it = this.getChildren().values().iterator();
        while (it.hasNext()) {
            INode sibling;
            INode node = (INode)it.next();
            if (node instanceof INestedNode) {
                ((INestedNode)node).removeAll(typeName);
                continue;
            }
            if (!(node.getObject() instanceof Resource) || !((Resource)node.getObject()).getTypeName().equals(typeName)) continue;
            List<NodeConnection> list = node.getOutgoingConnections();
            for (NodeConnection connection : list) {
                sibling = connection.getTarget();
                sibling.getIncomingConnections().remove(connection);
            }
            list.clear();
            list = node.getIncomingConnections();
            for (NodeConnection connection : list) {
                sibling = connection.getSource();
                sibling.getOutgoingConnections().remove(connection);
            }
            list.clear();
            it.remove();
        }
    }

    @Override
    public void setData(Object key, Object value) {
        this.data.put(key, value);
    }

    @Override
    public void setData(Object value) {
        this.data.put(null, value);
    }

    @Override
    public Object getData(Object key) {
        return this.data.get(key);
    }

    @Override
    public Object getData() {
        return this.data.get(null);
    }
}

