/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model.viz;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.viz.IModelChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;

public class ResourceFilter {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Comparator<ResourceFilter> DESCRIPTION_COMPARATOR = new Comparator<ResourceFilter>(){

        @Override
        public int compare(ResourceFilter filter1, ResourceFilter filter2) {
            return filter1.getDescription().compareTo(filter2.getDescription());
        }
    };
    private static final Logger logger = Logger.getLogger(ResourceFilter.class.getPackage().getName());
    private String description;
    private String name;
    private boolean checked;
    private ArrayList<ResourceFilter> children = new ArrayList();
    private ArrayList<IModelChangeListener<ResourceFilter>> listeners = new ArrayList();
    public static String ROOT = "ROOT";
    public static String CICS = "CICS";
    public static String DB2 = "DB2";
    public static String IMS = "IMS";
    public static String MQ = "MQ";
    public static String NATURAL = "NATURAL";
    public static String EMPTY = "";
    private ResourceFilter parent;

    public ResourceFilter getParent() {
        return this.parent;
    }

    public void setParent(ResourceFilter parent) {
        this.parent = parent;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
        this.fireModelChange();
    }

    public ArrayList<ResourceFilter> getChildren() {
        return this.children;
    }

    public void setChildren(ArrayList<ResourceFilter> children) {
        this.children = children;
    }

    public ResourceFilter getFilter(String name) {
        Debug.enter((Logger)logger, (String)ResourceFilter.class.getName(), (String)"getFilter", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "name: " + name});
        for (ResourceFilter filter : this.children) {
            if (!filter.name.equals(name)) continue;
            Debug.exit((Logger)logger, (String)ResourceFilter.class.getName(), (String)"getFilter", (Object)("filter: " + filter.getName()));
            return filter;
        }
        ResourceFilter result = null;
        for (ResourceFilter filter : this.children) {
            result = filter.getFilter(name);
            if (result == null) continue;
            Debug.exit((Logger)logger, (String)ResourceFilter.class.getName(), (String)"getFilter", (Object)("filter: " + filter.getName()));
            return result;
        }
        Debug.exit((Logger)logger, (String)ResourceFilter.class.getName(), (String)"getFilter", (Object)"return null");
        return null;
    }

    private void fireModelChange() {
        Debug.enter((Logger)logger, (String)ResourceFilter.class.getName(), (String)"fireModelChange", (Object)("Thread ID: " + Thread.currentThread().getId()));
        for (IModelChangeListener<ResourceFilter> listener : this.listeners) {
            listener.onModelChanged(this);
        }
        Debug.exit((Logger)logger, (String)ResourceFilter.class.getName(), (String)"fireModelChange");
    }

    public void addModelChangeListener(IModelChangeListener<ResourceFilter> listener) {
        this.listeners.add(listener);
    }

    public void removeModelChangeListener(IModelChangeListener<ResourceFilter> listener) {
        this.listeners.remove(listener);
    }

    public List<String> getCheckedSubtreeLeafNames() {
        return this.getSubtreeLeaves(this, true);
    }

    public List<String> getUncheckedSubtreeLeafNames() {
        return this.getSubtreeLeaves(this, false);
    }

    private List<String> getSubtreeLeaves(ResourceFilter root, boolean checked) {
        Debug.enter((Logger)logger, (String)ResourceFilter.class.getName(), (String)"getSubtreeLeaves", (Object[])new String[]{"ThreadId: " + Thread.currentThread().getId(), "root: " + root.getName(), "checked: " + checked});
        ArrayList<String> leaves = new ArrayList<String>();
        if (root.children.isEmpty() && root.isChecked() == checked) {
            leaves.add(root.getName());
        } else if (!root.children.isEmpty()) {
            for (ResourceFilter child : root.children) {
                leaves.addAll(this.getSubtreeLeaves(child, checked));
            }
        }
        Debug.exit((Logger)logger, (String)ResourceFilter.class.getName(), (String)"getSubtreeLeaves", (Object)("leaves size: " + leaves.size()));
        return leaves;
    }

    public void setCheckedSubtree(boolean checked) {
        Debug.enter((Logger)logger, (String)ResourceFilter.class.getName(), (String)"setCheckedSubtree", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "checked: " + checked});
        this.checkRecursive(this, checked);
        Debug.exit((Logger)logger, (String)ResourceFilter.class.getName(), (String)"setCheckedSubtree");
    }

    private void checkRecursive(ResourceFilter root, boolean checked) {
        for (ResourceFilter child : root.children) {
            this.checkRecursive(child, checked);
        }
        root.setChecked(checked);
    }

    public void sortSubtreeByDescription() {
        Debug.enter((Logger)logger, (String)ResourceFilter.class.getName(), (String)"sortSubtreeByDescription", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.sortRecursiveByDescription(this);
        Debug.exit((Logger)logger, (String)ResourceFilter.class.getName(), (String)"sortSubtreeByDescription");
    }

    private void sortRecursiveByDescription(ResourceFilter parent) {
        Collections.sort(parent.children, DESCRIPTION_COMPARATOR);
        for (ResourceFilter child : parent.children) {
            this.sortRecursiveByDescription(child);
        }
    }

    public static ResourceFilter createFilter(String name, String description, ResourceFilter parent, boolean checked) {
        Debug.enter((Logger)logger, (String)ResourceFilter.class.getName(), (String)"createFilter", (Object[])new String[]{"ThreadID: " + Thread.currentThread().getId(), "name: " + name, "description: " + description, "parent: " + (parent == null ? parent : parent.getName()), "checked: " + checked});
        ResourceFilter filter = new ResourceFilter();
        filter.setName(name);
        filter.setDescription(description);
        filter.setParent(parent);
        filter.setChecked(checked);
        if (parent != null) {
            parent.getChildren().add(filter);
        }
        Debug.exit((Logger)logger, (String)ResourceFilter.class.getName(), (String)"createFilter", (Object)("filter: " + filter.getName()));
        return filter;
    }

    public ResourceFilter findFilterInPath(String ... filterNames) {
        Debug.enter((Logger)logger, (String)ResourceFilter.class.getName(), (String)"findFilterInPath", (Object[])new String[]{"threadID: " + Thread.currentThread().getId(), "filterNames length: " + filterNames.length});
        ResourceFilter candidate = this;
        while (candidate != null) {
            int i = 0;
            while (i < filterNames.length) {
                if (candidate.getName().equals(filterNames[i])) {
                    return candidate;
                }
                ++i;
            }
            candidate = candidate.getParent();
        }
        Debug.exit((Logger)logger, (String)ResourceFilter.class.getName(), (String)"findFilterInPath", (Object)("candidate: " + (candidate == null ? candidate : candidate.getName())));
        return candidate;
    }
}

