/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model.viz;

import com.ibm.cics.ia.model.viz.IModelChangeListener;
import com.ibm.cics.ia.model.viz.INode;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.util.ArrayList;
import java.util.LinkedList;

public class NodeConnection {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private INode sourceNode;
    private INode targetNode;
    private ArrayList<String> verbs = new ArrayList();
    private LinkedList<IModelChangeListener<NodeConnection>> listeners = new LinkedList();
    private boolean selected;
    public String name;

    public NodeConnection(INode source, INode target) {
        this.sourceNode = source;
        this.targetNode = target;
        this.selected = false;
    }

    public INode getSource() {
        return this.sourceNode;
    }

    public void setSource(INode source) {
        this.sourceNode = source;
    }

    public INode getTarget() {
        return this.targetNode;
    }

    public void setTarget(INode target) {
        this.targetNode = target;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof NodeConnection)) {
            return false;
        }
        NodeConnection connection = (NodeConnection)o;
        return connection.sourceNode == this.sourceNode && connection.targetNode == this.targetNode;
    }

    public int hashCode() {
        int shift = 31;
        return this.sourceNode.hashCode() * shift + this.targetNode.hashCode();
    }

    public void addVerb(String verb) {
        if (!this.verbs.contains(verb)) {
            this.verbs.add(verb);
        }
    }

    public ArrayList<String> getVerbs() {
        return this.verbs;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.sourceNode.toString());
        result.append(" -> ");
        for (String verb : this.verbs) {
            if (!IAUtilities.hasContent(verb)) continue;
            result.append(verb);
            result.append(", ");
        }
        result.append(" -> ");
        result.append(this.targetNode.toString());
        return result.toString();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.notifyListeners();
    }

    private void notifyListeners() {
        for (IModelChangeListener iModelChangeListener : this.listeners) {
            iModelChangeListener.onModelChanged(this);
        }
    }

    public void addModelChangeListener(IModelChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeModelChangeListener(IModelChangeListener listener) {
        this.listeners.remove(listener);
    }
}

