/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model.threadsafe;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.AtomContent;
import com.ibm.cics.ia.model.CintCollector;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.model.TreeNode;
import com.ibm.cics.ia.model.threadsafe.Summary;
import com.ibm.cics.ia.model.threadsafe.ThreadsafeReport;
import com.ibm.cics.ia.model.threadsafe.ThreadsafeReportModel;
import com.ibm.cics.ia.model.threadsafe.ThreadsafeReportModelListener;
import com.ibm.cics.ia.runtime.Version;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public class ThreadsafeReportModelImpl
implements ThreadsafeReportModel {
    private static final Logger logger = Logger.getLogger(ThreadsafeReportModelImpl.class.getPackage().getName());
    private static ThreadsafeReportModelImpl instance;
    private Unmarshaller unmarshaller;
    private Marshaller marshaller;
    private Schema schema;
    private ThreadsafeReport report;
    private File reportFile;
    private List<ThreadsafeReportModelListener> listeners = new ArrayList<ThreadsafeReportModelListener>();
    private List<TreeNode> collidNodes = new ArrayList<TreeNode>();

    public static ThreadsafeReportModelImpl getInstance() {
        if (instance == null) {
            instance = new ThreadsafeReportModelImpl();
        }
        return instance;
    }

    @Override
    public void setReport(ThreadsafeReport report) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"setReport", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.report = report;
        for (ThreadsafeReportModelListener listener : this.listeners) {
            listener.onReportSet(report);
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"setReport");
    }

    @Override
    public ThreadsafeReport getReport() {
        return this.report;
    }

    @Override
    public File getReportFile() {
        return this.reportFile;
    }

    @Override
    public List<TreeNode> convertReport() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"convertReport", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.collidNodes = new ArrayList<TreeNode>();
        if (this.report != null) {
            List<Summary> summaries = this.report.getSummaries();
            for (Summary summary : summaries) {
                String collectionId = summary.getCollectionId();
                TreeNode collidNode = null;
                for (TreeNode node : this.collidNodes) {
                    if (!node.getData().equals(collectionId)) continue;
                    collidNode = node;
                    break;
                }
                if (collidNode == null) {
                    collidNode = new TreeNode(collectionId);
                    this.collidNodes.add(collidNode);
                }
                String applid = summary.getApplid();
                TreeNode<Object> regionNode = null;
                List<TreeNode<String>> regionNodes = collidNode.getChildren();
                for (TreeNode<String> child : regionNodes) {
                    if (!((Region)((Object)child.getData())).getName().equals(applid)) continue;
                    regionNode = child;
                    break;
                }
                if (regionNode == null) {
                    regionNode = new TreeNode<Region>(ResourceFactory.getSingleton().getRegion(applid));
                    collidNode.addChild(regionNode);
                }
                TreeNode<Summary> summaryNode = new TreeNode<Summary>(summary);
                TreeNode<Summary.CicsCalls> cicsCallsNode = new TreeNode<Summary.CicsCalls>(summary.getCicsCalls());
                summaryNode.addChild(cicsCallsNode);
                TreeNode<Summary.Db2MqCalls> db2MqCallsNode = new TreeNode<Summary.Db2MqCalls>(summary.getDb2MqCalls());
                summaryNode.addChild(db2MqCallsNode);
                TreeNode<Summary.ImsCalls> imsCallsNode = new TreeNode<Summary.ImsCalls>(summary.getImsCalls());
                summaryNode.addChild(imsCallsNode);
                if (Version.getInstance().getDBVersion() >= 5200 && summary.getCpsmCalls() != null) {
                    TreeNode<Summary.CpsmCalls> cpsmCallsNode = new TreeNode<Summary.CpsmCalls>(summary.getCpsmCalls());
                    summaryNode.addChild(cpsmCallsNode);
                }
                regionNode.addChild(summaryNode);
            }
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"convertReport");
        return this.collidNodes;
    }

    @Override
    public ThreadsafeReport loadReport(File reportFile) throws FileNotFoundException, MalformedURLException, JAXBException, SAXException {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"loadReport", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.reportFile = reportFile;
        if (this.unmarshaller == null) {
            ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ThreadsafeReport.class});
                this.unmarshaller = jaxbContext.createUnmarshaller();
            }
            finally {
                if (originalContextClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(originalContextClassLoader);
                }
            }
        }
        this.initSchema();
        this.unmarshaller.setSchema(this.schema);
        this.report = (ThreadsafeReport)this.unmarshaller.unmarshal((Reader)new FileReader(reportFile));
        for (ThreadsafeReportModelListener listener : this.listeners) {
            listener.onReportLoad(this.report);
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"loadReport");
        return this.report;
    }

    private void initSchema() throws MalformedURLException, SAXException {
        if (this.schema == null) {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            this.schema = schemaFactory.newSchema(new URL("platform:/plugin/com.ibm.cics.ia.runtime/threadsafe-report.xsd"));
        }
    }

    @Override
    public void saveReport(ThreadsafeReport report, File reportFile) throws JAXBException, SAXException, MalformedURLException {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"saveReport", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.reportFile = reportFile;
        if (this.marshaller == null) {
            ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ThreadsafeReport.class});
                this.marshaller = jaxbContext.createMarshaller();
            }
            finally {
                if (originalContextClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(originalContextClassLoader);
                }
            }
        }
        this.initSchema();
        this.marshaller.setSchema(this.schema);
        this.marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        this.marshaller.marshal((Object)new JAXBElement(new QName("", "threadsafe-report"), ThreadsafeReport.class, null, (Object)report), reportFile);
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"saveReport");
    }

    @Override
    public void addListener(ThreadsafeReportModelListener listener) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"addListener", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"addListener");
    }

    @Override
    public void removeListener(ThreadsafeReportModelListener listener) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"removeListener", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.listeners.remove(listener);
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"removeListener");
    }

    @Override
    public void updateCollectorStatus(List<AtomContent> collectors) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"updateCollectorStatus", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Iterator<AtomContent> iter = collectors.iterator();
        boolean updated = false;
        while (iter.hasNext()) {
            AtomContent content = iter.next();
            if (!(content instanceof CintCollector)) continue;
            CintCollector cintCollector = (CintCollector)content;
            for (TreeNode collidNode : this.collidNodes) {
                for (TreeNode node : collidNode.getChildren()) {
                    if (!(node.getData() instanceof Region)) continue;
                    Region region = (Region)node.getData();
                    Region collectorRegion = cintCollector.getRegion();
                    if (!collectorRegion.equals(region)) continue;
                    region.setCintCollector(cintCollector);
                    updated = true;
                }
            }
        }
        if (updated) {
            for (ThreadsafeReportModelListener listener : this.listeners) {
                listener.onUpdate();
            }
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"updateCollectorStatus");
    }
}

