/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model.threadsafe;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.EngineShell;
import com.ibm.cics.dbfunc.command.SQLCommand;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.commands.ThreadsafeDetailReportCommand;
import com.ibm.cics.ia.commands.ThreadsafeReportCommand;
import com.ibm.cics.ia.commands.ThreadsafeSummaryReportCommand;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.threadsafe.CreateThreadsafeReportModel;
import com.ibm.cics.ia.model.threadsafe.CreateThreadsafeReportModelListener;
import com.ibm.cics.ia.model.threadsafe.Summary;
import com.ibm.cics.ia.model.threadsafe.ThreadsafeReport;
import com.ibm.cics.ia.storedproc.ProcedureCIUSPTSR;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

public class CreateThreadsafeReportModelImpl
implements CreateThreadsafeReportModel {
    private static final Logger logger = Logger.getLogger(CreateThreadsafeReportModelImpl.class.getPackage().getName());
    private ThreadsafeReport report;
    private Resource resource;
    private Region region;
    private List<CreateThreadsafeReportModelListener> listeners;
    private String callType;
    private String collectionId;
    private String applId;
    private String queryArg;
    private String cicsTsLevel;
    private ThreadsafeReportCommand summaryCommand;
    private ThreadsafeDetailReportCommand detailedCommand;
    private AtomicBoolean stopCreatingDetails;

    public CreateThreadsafeReportModelImpl(Resource resource, Region region) {
        this.resource = resource;
        this.region = region;
        this.listeners = new ArrayList<CreateThreadsafeReportModelListener>();
        this.stopCreatingDetails = new AtomicBoolean(false);
        this.summaryCommand = new ThreadsafeSummaryReportCommand();
        this.detailedCommand = new ThreadsafeDetailReportCommand();
    }

    @Override
    public void fillReportWithSummaries(EngineShell.EngineListener listener) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"fillReportWithSummaries", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.report = new ThreadsafeReport();
        this.getReport().setIaVersion("6.1.3");
        this.getReport().setDate(DateFormat.getDateTimeInstance().format(new Date()));
        ThreadsafeReport.Options options = new ThreadsafeReport.Options();
        options.setCicsTsLevel(this.cicsTsLevel);
        options.setCollectionId(this.collectionId);
        ThreadsafeReport.Options.Resource resource = new ThreadsafeReport.Options.Resource();
        resource.setValue(this.queryArg);
        resource.setType(this.resource instanceof Program ? "PROGRAM" : "TRANSID");
        options.setResource(resource);
        options.setRegion(this.applId);
        this.getReport().setOptions(options);
        this.getSummaryCommand().reset();
        this.getSummaryCommand().addListener(listener);
        this.getSummaryCommand().setCriteria(this.callType, this.collectionId, this.applId, this.queryArg, this.cicsTsLevel);
        this.getSummaryCommand().setAsync(false);
        IASQLCommand.runCommandSynch((SQLCommand)this.getSummaryCommand());
        while (this.getSummaryCommand().status() == 3) {
            this.getSummaryCommand().resume();
        }
        List summaries = this.getSummaryCommand().getResults();
        if (summaries != null) {
            this.getReport().getSummaries().addAll(summaries);
        }
        this.getSummaryCommand().removeListener(listener);
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"fillReportWithSummaries");
    }

    @Override
    public String validateInput() {
        return ProcedureCIUSPTSR.validateInput(this.callType, this.collectionId, this.applId, this.queryArg, this.cicsTsLevel);
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    @Override
    public void setCollectionId(String collectionId) {
        this.collectionId = collectionId;
    }

    @Override
    public void setCallType(String callType) {
        this.callType = callType;
    }

    @Override
    public void setCicsTsLevel(String cicsTsLevel) {
        this.cicsTsLevel = cicsTsLevel;
    }

    @Override
    public void setQueryArg(String queryArg) {
        this.queryArg = queryArg;
    }

    @Override
    public void setApplId(String applId) {
        this.applId = applId;
    }

    @Override
    public String getCallType() {
        return this.callType;
    }

    @Override
    public String getCollectionId() {
        return this.collectionId;
    }

    @Override
    public String getApplId() {
        return this.applId;
    }

    @Override
    public String getQueryArg() {
        return this.queryArg;
    }

    @Override
    public String getCicsTsLevel() {
        return this.cicsTsLevel;
    }

    @Override
    public ThreadsafeReportCommand getSummaryCommand() {
        return this.summaryCommand;
    }

    @Override
    public ThreadsafeDetailReportCommand getDetailCommand() {
        return this.detailedCommand;
    }

    @Override
    public void stopCreatingDetails() {
        this.stopCreatingDetails.set(true);
    }

    @Override
    public void fillReportWithDetails() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"fillReportWithDetails", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.getReport() == null) {
            Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"fillReportWithDetails");
            return;
        }
        int i = 0;
        while (i < this.getReport().getSummaries().size()) {
            if (this.stopCreatingDetails.compareAndSet(true, false)) {
                Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"fillReportWithDetails");
                return;
            }
            Summary summary = this.getReport().getSummaries().get(i);
            this.getDetailCommand().reset();
            this.getDetailCommand().setCriteria("PGMD", summary.getCollectionId(), summary.getApplid(), summary.getProgram(), summary.getCicsReleaseExternal());
            IASQLCommand.runCommandSynch((SQLCommand)this.getDetailCommand());
            while (this.getDetailCommand().status() == 3) {
                this.getDetailCommand().resume();
            }
            for (CreateThreadsafeReportModelListener listener : this.listeners) {
                listener.afterCreatingDetails(i + 1, this.getReport().getSummaries().size());
            }
            List objects = this.getDetailCommand().getResults();
            if (objects != null) {
                summary.setDetails(new Summary.Details());
                summary.getDetails().getDetails().addAll(objects);
            }
            ++i;
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"fillReportWithDetails");
    }

    @Override
    public void addListener(CreateThreadsafeReportModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(CreateThreadsafeReportModelListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public ThreadsafeReport getReport() {
        return this.report;
    }
}

