/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.ia.commands.PlatformsForResourceCommand;
import com.ibm.cics.ia.commands.ProgramsForWebserviceCommand;
import com.ibm.cics.ia.commands.PropertiesCommand;
import com.ibm.cics.ia.commands.RegionsForResourceCommand;
import com.ibm.cics.ia.commands.SourceInteractionsForResourceCommand;
import com.ibm.cics.ia.commands.SourceProgramInteractionsForResourceCommand;
import com.ibm.cics.ia.commands.SourceTransactionInteractionsForResourceCommand;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.WebservicePropertySource;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.ui.views.properties.IPropertySource;

public class Webservice
extends Resource {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(Webservice.class.getPackage().getName());
    private static final long serialVersionUID = 9058246018029955636L;
    protected List programs;
    protected List properties;

    public Webservice(String resourceName) {
        super("WEBSERVICE", resourceName);
    }

    protected Webservice(String resourceType, String resourceName) {
        super(resourceType, resourceName);
    }

    @Override
    public Command createGetRegionsCommand() {
        return new RegionsForResourceCommand(this);
    }

    @Override
    public Command createGetPlatformsCommand() {
        return new PlatformsForResourceCommand(this);
    }

    public synchronized List getImplementingPrograms(Region aRegion) {
        Debug.enter((Logger)logger, (String)Webservice.class.getName(), (String)"getImplementingPrograms", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.programs == null) {
            ProgramsForWebserviceCommand command = new ProgramsForWebserviceCommand(this, aRegion);
            command.start();
            while (command.status() == 3) {
                command.start();
            }
            if (command.status() != 2) {
                this.programs = command.getResults();
            }
        }
        Debug.exit((Logger)logger, (String)Webservice.class.getName(), (String)"getImplementingPrograms");
        return this.programs;
    }

    @Override
    public String getTypeName() {
        return "WEBSERVICE";
    }

    @Override
    public synchronized List getSourceInteractions() {
        Debug.enter((Logger)logger, (String)Webservice.class.getName(), (String)"getSourceInteractions", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.sourceInteractions == null) {
            SourceInteractionsForResourceCommand command = new SourceInteractionsForResourceCommand(this);
            command.setAsync(false);
            command.start();
            while (command.status() == 3) {
                command.start();
            }
            this.sourceInteractions = command.getResults();
        }
        Debug.exit((Logger)logger, (String)Webservice.class.getName(), (String)"getSourceInteractions");
        return this.sourceInteractions;
    }

    @Override
    public Object getAdapter(Class adapterType) {
        if (adapterType == IPropertySource.class) {
            if (this.propertySource == null) {
                this.propertySource = new WebservicePropertySource(this);
            }
            return this.propertySource;
        }
        return super.getAdapter(adapterType);
    }

    @Override
    public List getProperties() {
        Debug.enter((Logger)logger, (String)Webservice.class.getName(), (String)"getProperties", (Object)("Thread ID: " + Thread.currentThread().getId()));
        PropertiesCommand command = new PropertiesCommand(this);
        command.start();
        this.properties = command.getResults();
        Debug.exit((Logger)logger, (String)Webservice.class.getName(), (String)"getProperties");
        return this.properties;
    }

    @Override
    public synchronized List getSourceProgramInteractions() {
        Debug.enter((Logger)logger, (String)Webservice.class.getName(), (String)"getSourceProgramInteractions", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.sourceProgramInteractions == null) {
            SourceProgramInteractionsForResourceCommand command = new SourceProgramInteractionsForResourceCommand(this);
            command.setAsync(false);
            command.start();
            while (command.status() == 3) {
                command.start();
            }
            this.sourceProgramInteractions = command.getResults();
        }
        Debug.exit((Logger)logger, (String)Webservice.class.getName(), (String)"getSourceProgramInteractions");
        return this.sourceProgramInteractions;
    }

    @Override
    public synchronized List getSourceTransactionInteractions() {
        Debug.enter((Logger)logger, (String)Webservice.class.getName(), (String)"getSourceTransactionInteractions", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.sourceTransactionInteractions == null) {
            SourceTransactionInteractionsForResourceCommand command = new SourceTransactionInteractionsForResourceCommand(this);
            command.setAsync(false);
            command.start();
            while (command.status() == 3) {
                command.start();
            }
            this.sourceTransactionInteractions = command.getResults();
        }
        Debug.exit((Logger)logger, (String)Webservice.class.getName(), (String)"getSourceTransactionInteractions");
        return this.sourceTransactionInteractions;
    }
}

