/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.Messages;
import com.ibm.cics.ia.model.Platform;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.ResourcePropertySource;
import com.ibm.cics.ia.model.TSApplication;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.runtime.Version;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class TransactionPropertySource
extends ResourcePropertySource {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(TransactionPropertySource.class.getPackage().getName());
    private static String APPLID = "APPLID";
    private static String HOMESYSID = "HOMESYSID";
    private static String TRANSID = "TRANSID";
    private static String BREXIT = "BREXIT";
    private static String CMDSEC = "CMDSEC";
    private static String DTIMEOUT = "DTIMEOUT";
    private static String DUMP = "DUMP";
    private static String DYNAMIC = "DYNAMIC";
    private static String INDOUBT = "INDOUBT";
    private static String INDOUBT_WAIT = "INDOUBT_WAIT";
    private static String INDOUBT_WAIT_TIME = "INDOUBT_WAIT_TIME";
    private static String INITIAL_PROGRAM = "INITIAL_PROGRAM";
    private static String ISOLATE = "ISOLATE";
    private static String LOCAL_QUEUING = "LOCAL_QUEUING";
    private static String OTSTIMEOUT = "OTSTIMEOUT";
    private static String PARTITIONSET = "PARTITIONSET";
    private static String PARTITIONSET_NAME = "PARTITIONSET_NAME";
    private static String PRIMARY_TRANSID = "PRIMARY_TRANSID";
    private static String PROFILE_NAME = "PROFILE_NAME";
    private static String REMOTE = "REMOTE";
    private static String REMOTE_NAME = "REMOTE_NAME";
    private static String REMOTE_SYSTEM = "REMOTE_SYSTEM";
    private static String RESSEC = "RESSEC";
    private static String RESTART = "RESTART";
    private static String ROUTABLE_STATUS = "ROUTABLE_STATUS";
    private static String RUNAWAY_LIMIT = "RUNAWAY_LIMIT";
    private static String SHUTDOWN = "SHUTDOWN";
    private static String SPURGE = "SPURGE";
    private static String STORAGE_CLEAR = "STORAGE_CLEAR";
    private static String STORAGE_FREEZE = "STORAGE_FREEZE";
    private static String SYSTEM_ATTACH = "SYSTEM_ATTACH";
    private static String SYSTEM_RUNAWAY = "SYSTEM_RUNAWAY";
    private static String TASKDATAKEY = "TASKDATAKEY";
    private static String TASKDATALOC = "TASKDATALOC";
    private static String TCLASS = "TCLASS";
    private static String TCLASS_NAME = "TCLASS_NAME";
    private static String TPURGE = "TPURGE";
    private static String TRACE = "TRACE";
    private static String TRAN_ROUTING_PROFILE = "TRAN_ROUTING_PROFILE";
    private static String TWASIZE = "TWASIZE";
    private static String FIRST_RUN = "FIRST_RUN";
    private static String LAST_RUN = "LAST_RUN";
    private static String ARCHIVE_DATE = "ARCHIVE_DATE";
    private static String COLLECTION_ID = "COLLECTION_ID";
    private static String APPL_NAME = "APPL_NAME";
    private static String APPL_VER1 = "APPL_VER1";
    private static String APPL_VER2 = "APPL_VER2";
    private static String APPL_VER3 = "APPL_VER3";
    private static String APPL_OPER = "APPL_OPER";
    private static String PLATFORM = "PLATFORM";
    private static final String[] ia31propertyIDs = new String[]{APPLID, HOMESYSID, TRANSID, BREXIT, CMDSEC, DTIMEOUT, DUMP, DYNAMIC, INDOUBT, INDOUBT_WAIT, INDOUBT_WAIT_TIME, INITIAL_PROGRAM, ISOLATE, LOCAL_QUEUING, OTSTIMEOUT, PARTITIONSET, PARTITIONSET_NAME, PRIMARY_TRANSID, PROFILE_NAME, REMOTE, REMOTE_NAME, REMOTE_SYSTEM, RESSEC, RESTART, ROUTABLE_STATUS, RUNAWAY_LIMIT, SHUTDOWN, SPURGE, STORAGE_CLEAR, STORAGE_FREEZE, SYSTEM_ATTACH, SYSTEM_RUNAWAY, TASKDATAKEY, TASKDATALOC, TCLASS, TCLASS_NAME, TPURGE, TRACE, TRAN_ROUTING_PROFILE, TWASIZE, FIRST_RUN, LAST_RUN};
    private static final String[] ia32propertyIDs = IAUtilities.concat(ia31propertyIDs, new String[][]{{COLLECTION_ID, ARCHIVE_DATE}});
    private static final String[] ia51propertyIDs = IAUtilities.concat(ia32propertyIDs, new String[][]{{APPL_NAME, APPL_VER1, APPL_VER2, APPL_VER3, APPL_OPER}});
    private static final String[] ia52propertyIDs = IAUtilities.concat(ia51propertyIDs, new String[][]{{PLATFORM}});

    public TransactionPropertySource(Resource resource) {
        super(resource);
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        Debug.enter((Logger)logger, (String)TransactionPropertySource.class.getName(), (String)"getPropertyDescriptors", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.propertyDescriptors == null && !this.collectionID2Props.containsKey(IASQLCommand.getCollectionId())) {
            List properties = this.resource.getProperties();
            this.processProperties(properties);
        }
        Debug.exit((Logger)logger, (String)TransactionPropertySource.class.getName(), (String)"getPropertyDescriptors");
        return this.getPropertiesInCurrentCollectionId();
    }

    private void processProperties(List properties) {
        Debug.enter((Logger)logger, (String)TransactionPropertySource.class.getName(), (String)"processProperties", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String[] propertyIDs = TransactionPropertySource.getPropertyIDs();
        int i = 0;
        while (i < properties.size()) {
            String categoryName;
            Map m = (Map)properties.get(i);
            ArrayList<PropertyDescriptor> descriptors = (ArrayList<PropertyDescriptor>)this.collectionID2Props.get((String)m.get(COLLECTION_ID));
            if (descriptors == null) {
                descriptors = new ArrayList<PropertyDescriptor>();
                this.collectionID2Props.put((String)m.get(COLLECTION_ID), descriptors);
            }
            int version = Version.getInstance().getDBVersion();
            switch (version) {
                case 3200: {
                    categoryName = MessageFormat.format(Messages.getString("TransactionPropertySource.3200"), (String)m.get(TRANSID), (String)m.get(COLLECTION_ID), (String)m.get(APPLID));
                    break;
                }
                case 5100: 
                case 5110: {
                    String ver1 = (String)m.get(APPL_VER1);
                    int v1 = IAUtilities.hasContent(ver1) ? Integer.parseInt(ver1) : 0;
                    String ver2 = (String)m.get(APPL_VER2);
                    int v2 = IAUtilities.hasContent(ver2) ? Integer.parseInt(ver2) : 0;
                    String ver3 = (String)m.get(APPL_VER3);
                    int v3 = IAUtilities.hasContent(ver3) ? Integer.parseInt(ver3) : 0;
                    TSApplication app1 = new TSApplication(null, (String)m.get(APPL_NAME), v1, v2, v3);
                    categoryName = String.valueOf(MessageFormat.format(Messages.getString("TransactionPropertySource.3200"), (String)m.get(TRANSID), (String)m.get(COLLECTION_ID), (String)m.get(APPLID))) + ", " + app1.getFullName() + " (" + m.get(APPL_OPER) + ")";
                    break;
                }
                case 5200: 
                case 5300: 
                case 5500: 
                case 6100: {
                    String ver1 = (String)m.get(APPL_VER1);
                    int v1 = IAUtilities.hasContent(ver1) ? Integer.parseInt(ver1) : 0;
                    String ver2 = (String)m.get(APPL_VER2);
                    int v2 = IAUtilities.hasContent(ver2) ? Integer.parseInt(ver2) : 0;
                    String ver3 = (String)m.get(APPL_VER3);
                    int v3 = IAUtilities.hasContent(ver3) ? Integer.parseInt(ver3) : 0;
                    TSApplication app1 = new TSApplication(new Platform((String)m.get(PLATFORM)), (String)m.get(APPL_NAME), v1, v2, v3);
                    categoryName = String.valueOf(MessageFormat.format(Messages.getString("TransactionPropertySource.3200"), (String)m.get(TRANSID), (String)m.get(COLLECTION_ID), (String)m.get(APPLID))) + ", " + m.get(PLATFORM) + ", " + app1.getFullName() + " (" + m.get(APPL_OPER) + ")";
                    break;
                }
                case 3100: {
                    categoryName = MessageFormat.format(Messages.getString("TransactionPropertySource.3100"), (String)m.get(TRANSID), (String)m.get(APPLID));
                    break;
                }
                default: {
                    categoryName = MessageFormat.format(Messages.getString("TransactionPropertySource.3100"), (String)m.get(TRANSID), (String)m.get(APPLID));
                }
            }
            int j = 0;
            while (j < propertyIDs.length) {
                String key = propertyIDs[j];
                String newKey = String.valueOf(key) + m.get(COLLECTION_ID) + m.get(APPLID) + "_" + Integer.toString(i);
                this.values.put(newKey, m.get(key));
                PropertyDescriptor descriptor = new PropertyDescriptor((Object)newKey, Messages.getString(propertyIDs[j]));
                descriptor.setCategory(categoryName);
                descriptors.add(descriptor);
                ++j;
            }
            ++i;
        }
        Debug.exit((Logger)logger, (String)TransactionPropertySource.class.getName(), (String)"processProperties");
    }

    public static int getPropertyCount() {
        return TransactionPropertySource.getPropertyIDs().length;
    }

    public static String[] getPropertyIDs() {
        int version = Version.getInstance().getDBVersion();
        switch (version) {
            case 3100: {
                return ia31propertyIDs;
            }
            case 3200: {
                return ia32propertyIDs;
            }
            case 5100: 
            case 5110: {
                return ia51propertyIDs;
            }
            case 5200: 
            case 5300: 
            case 5500: 
            case 6100: {
                return ia52propertyIDs;
            }
        }
        return ia31propertyIDs;
    }
}

