/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.Direction;
import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.ia.commands.FindUserCommandFlowRunsCommand;
import com.ibm.cics.ia.commands.PlatformsForResourceCommand;
import com.ibm.cics.ia.commands.PropertiesCommand;
import com.ibm.cics.ia.commands.QueryCommand;
import com.ibm.cics.ia.commands.RegionsForTransactionCommand;
import com.ibm.cics.ia.commands.SourceInteractionsForResourceCommand;
import com.ibm.cics.ia.commands.SourceProgramInteractionsForResourceCommand;
import com.ibm.cics.ia.commands.SourceTransactionInteractionsForResourceCommand;
import com.ibm.cics.ia.commands.TransactionInitialProgramCommand1;
import com.ibm.cics.ia.commands.TransactionInitialProgramCommand2;
import com.ibm.cics.ia.commands.TransactionOwnerUserIdsCommand;
import com.ibm.cics.ia.commands.TransactionTasksCommand;
import com.ibm.cics.ia.commands.TransactionUsesProgramsCommand;
import com.ibm.cics.ia.model.Platform;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.TSApplication;
import com.ibm.cics.ia.model.TransactionPropertySource;
import com.ibm.cics.ia.query.Query;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.ui.views.properties.IPropertySource;

public class Transaction
extends Resource {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(Transaction.class.getPackage().getName());
    private static final long serialVersionUID = 9058246018029955634L;
    protected List programs;
    private List properties;
    private List tasks;
    private List<String> ownerUserIds;
    private QueryCommand tasksCommand;
    private HashMap<Region, Program> firstPrograms = new HashMap();

    public Transaction(String resourceName) {
        super("TRANSID", resourceName);
    }

    @Override
    public Command createGetRegionsCommand() {
        return new RegionsForTransactionCommand(this);
    }

    @Override
    public Command createGetPlatformsCommand() {
        return new PlatformsForResourceCommand(this);
    }

    public synchronized List getUsesPrograms() {
        Debug.enter((Logger)logger, (String)Transaction.class.getName(), (String)"getUsesPrograms", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.programs == null) {
            TransactionUsesProgramsCommand command = new TransactionUsesProgramsCommand(this);
            command.start();
            while (command.status() == 3) {
                command.start();
            }
            if (command.status() != 2) {
                this.programs = command.getResults();
            }
        }
        Debug.exit((Logger)logger, (String)Transaction.class.getName(), (String)"getUsesPrograms", (Object)("result size: " + this.programs.size()));
        return this.programs;
    }

    public List<Resource[]> getFirstProgramsByRegionPlatformAndApplication(Region region, Platform platform, TSApplication application) {
        Debug.enter((Logger)logger, (String)Transaction.class.getName(), (String)"getFirstProgramsByRegionAndApplication", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "region: " + (region == null ? region : region.getName()), "platform: " + (platform == null ? platform : platform.getName()), "application:" + (application == null ? application : application.getName())});
        TransactionInitialProgramCommand1 command = new TransactionInitialProgramCommand1(this, region, platform, application);
        List results = null;
        command.start();
        while (command.status() == 3) {
            command.start();
        }
        if (command.status() != 2) {
            results = command.getResults();
        }
        TransactionInitialProgramCommand2 command2 = new TransactionInitialProgramCommand2(this, region, platform, application);
        command2.start();
        while (command2.status() == 3) {
            command2.start();
        }
        if (command2.status() != 2) {
            List results2 = command2.getResults();
            for (Object object : results2) {
                Object[] row2 = (Object[])object;
                Region region2 = (Region)row2[0];
                TSApplication application2 = (TSApplication)row2[2];
                boolean exists = false;
                for (Object object1 : results) {
                    Object[] row1 = (Object[])object1;
                    Region region1 = (Region)row1[0];
                    TSApplication application1 = (TSApplication)row1[2];
                    if (!region2.equals(region1) || application1 != application2 && !application1.equals(application2)) continue;
                    exists = true;
                }
                if (exists) continue;
                results.add(row2);
            }
        }
        if (results.size() > 0) {
            Debug.exit((Logger)logger, (String)Transaction.class.getName(), (String)"getFirstProgramsByRegionAndApplication", (Object)("results size: " + results.size()));
            return results;
        }
        ArrayList<Resource[]> result = new ArrayList<Resource[]>();
        Debug.exit((Logger)logger, (String)Transaction.class.getName(), (String)"getFirstProgramsByRegionAndApplication", (Object)("result size: " + result.size()));
        return result;
    }

    public Program getFirstProgram(Region region) {
        Debug.enter((Logger)logger, (String)Transaction.class.getName(), (String)"getFirstProgram", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "region: " + (region == null ? region : region.getName())});
        Program initialPgm = this.firstPrograms.get(region);
        if (initialPgm == null) {
            List results = null;
            TransactionInitialProgramCommand1 command = new TransactionInitialProgramCommand1(this, region);
            command.start();
            while (command.status() == 3) {
                command.start();
            }
            if (command.status() != 2 && (results = command.getResults()).size() > 0) {
                initialPgm = (Program)((Resource[])results.get(0))[3];
                this.firstPrograms.put(region, initialPgm);
            }
            if (initialPgm == null) {
                TransactionInitialProgramCommand2 command2 = new TransactionInitialProgramCommand2(this, region);
                command2.start();
                while (command2.status() == 3) {
                    command2.start();
                }
                if (command2.status() != 2 && (results = command2.getResults()).size() > 0) {
                    Program program1 = (Program)((Resource[])results.get(0))[3];
                    boolean moreThan1ProgramFound = false;
                    for (Object object : results) {
                        Resource[] row = (Resource[])object;
                        Program program = (Program)row[3];
                        if (program1.equals(program)) continue;
                        moreThan1ProgramFound = true;
                        break;
                    }
                    if (!moreThan1ProgramFound) {
                        initialPgm = (Program)((Resource[])results.get(0))[3];
                        this.firstPrograms.put(region, initialPgm);
                    }
                }
            }
        }
        Debug.exit((Logger)logger, (String)Transaction.class.getName(), (String)"getFirstProgram", (Object)("initialPgm: " + (initialPgm == null ? "null" : initialPgm.getName())));
        return initialPgm;
    }

    @Override
    public String getTypeName() {
        return "TRANSID";
    }

    @Override
    public synchronized List getSourceInteractions() {
        Debug.enter((Logger)logger, (String)Transaction.class.getName(), (String)"getSourceInteractions", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.sourceInteractions == null) {
            SourceInteractionsForResourceCommand command = new SourceInteractionsForResourceCommand(this);
            command.setAsync(false);
            command.start();
            while (command.status() == 3) {
                command.start();
            }
            this.sourceInteractions = command.getResults();
        }
        Debug.exit((Logger)logger, (String)Transaction.class.getName(), (String)"getSourceInteractions", (Object)("result size: " + this.sourceInteractions.size()));
        return this.sourceInteractions;
    }

    @Override
    public Object getAdapter(Class adapterType) {
        if (adapterType == IPropertySource.class) {
            if (this.propertySource == null) {
                this.propertySource = new TransactionPropertySource(this);
            }
            return this.propertySource;
        }
        return super.getAdapter(adapterType);
    }

    @Override
    public List getProperties() {
        Debug.enter((Logger)logger, (String)Transaction.class.getName(), (String)"getProperties", (Object)("Thread ID: " + Thread.currentThread().getId()));
        PropertiesCommand command = new PropertiesCommand(this);
        command.start();
        this.properties = command.getResults();
        Debug.exit((Logger)logger, (String)Transaction.class.getName(), (String)"getProperties", (Object)("result size: " + this.properties.size()));
        return this.properties;
    }

    @Override
    public synchronized List getSourceProgramInteractions() {
        Debug.enter((Logger)logger, (String)Transaction.class.getName(), (String)"getSourceProgramInteractions", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.sourceProgramInteractions == null) {
            SourceProgramInteractionsForResourceCommand command = new SourceProgramInteractionsForResourceCommand(this);
            command.setAsync(false);
            command.start();
            while (command.status() == 3) {
                command.start();
            }
            this.sourceProgramInteractions = command.getResults();
        }
        Debug.exit((Logger)logger, (String)Transaction.class.getName(), (String)"getSourceProgramInteractions", (Object)("result size: " + this.sourceProgramInteractions.size()));
        return this.sourceProgramInteractions;
    }

    @Override
    public synchronized List getSourceTransactionInteractions() {
        Debug.enter((Logger)logger, (String)Transaction.class.getName(), (String)"getSourceTransactionInteractions", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.sourceTransactionInteractions == null) {
            SourceTransactionInteractionsForResourceCommand command = new SourceTransactionInteractionsForResourceCommand(this);
            command.setAsync(false);
            command.start();
            while (command.status() == 3) {
                command.start();
            }
            this.sourceTransactionInteractions = command.getResults();
        }
        Debug.exit((Logger)logger, (String)Transaction.class.getName(), (String)"getSourceTransactionInteractions", (Object)("result size: " + this.sourceTransactionInteractions.size()));
        return this.sourceTransactionInteractions;
    }

    public List getTasks() {
        Debug.enter((Logger)logger, (String)Transaction.class.getName(), (String)"getTasks", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.tasks == null) {
            TransactionTasksCommand command = new TransactionTasksCommand(this);
            command.start();
            while (command.status() == 3) {
                command.start();
            }
            if (command.status() != 2) {
                this.tasks = command.getResults();
            }
        }
        Debug.exit((Logger)logger, (String)Transaction.class.getName(), (String)"getTasks", (Object)("result size: " + this.tasks.size()));
        return this.tasks;
    }

    public List<String> getOwnerUserIds() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"getOwnerUserIds", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.ownerUserIds == null) {
            TransactionOwnerUserIdsCommand command = new TransactionOwnerUserIdsCommand(this);
            command.start();
            while (command.status() == 3) {
                command.start();
            }
            if (command.status() != 2) {
                this.ownerUserIds = command.getResults();
            }
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"getOwnerUserIds");
        return this.ownerUserIds;
    }

    public QueryCommand createGetTasksCommand() {
        Debug.enter((Logger)logger, (String)Transaction.class.getName(), (String)"createGetTasksCommand", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.tasksCommand == null) {
            Presentation presentation = Query.createPresentation("", IAUtilities.getCommandFlowTableName(), "TRANSID", "TASKID");
            presentation.getSelection().appendCondition("TRANSID", IAUtilities.getCommandFlowTableName(), ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.getName()}, QueryElement.Predicate.AND, false);
            this.tasksCommand = new QueryCommand(presentation);
        }
        Debug.exit((Logger)logger, (String)Transaction.class.getName(), (String)"createGetTasksCommand", (Object)("tasksCommand: " + this.tasksCommand.getSQLString()));
        return this.tasksCommand;
    }

    public QueryCommand createGetCommandFlowRunsCommand(Region region) {
        Debug.enter((Logger)logger, (String)Transaction.class.getName(), (String)"createGetCommandFlowRunsCommand", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "region: " + (region == null ? region : region.getName())});
        Presentation presentation = this.createCommandFlowRunsCommonPart();
        if (region != null) {
            presentation.getSelection().appendCondition("APPLID", IAUtilities.getCommandFlowTableName(), ColumnReference.DataType.String, Comparator.EQ, new Object[]{region.getName()}, QueryElement.Predicate.AND, false);
        }
        Debug.exit((Logger)logger, (String)Transaction.class.getName(), (String)"createGetCommandFlowRunsCommand");
        return new QueryCommand(presentation);
    }

    public QueryCommand createGetCommandFlowRunsForSpecificUserCommand(List<String> userIds) {
        Debug.enter((Logger)logger, (String)Transaction.class.getName(), (String)"createGetCommandFlowRunsForSpecificUserCommand", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "userIds size: " + (userIds == null ? userIds : Integer.valueOf(userIds.size()))});
        Presentation presentation = this.createCommandFlowRunsCommonPart();
        if (userIds != null) {
            presentation.getSelection().appendCondition("USERID", IAUtilities.getCommandFlowTableName(), ColumnReference.DataType.String, Comparator.IN, userIds.toArray(), QueryElement.Predicate.AND, false);
        }
        Debug.exit((Logger)logger, (String)Transaction.class.getName(), (String)"createGetCommandFlowRunsForSpecificUserCommand");
        return new QueryCommand(presentation);
    }

    private Presentation createCommandFlowRunsCommonPart() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"createCommandFlowRunsCommonPart", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId()});
        String commandFlowIndexTable = IAUtilities.getCommandFlowIndexTableName();
        String commandFlowTable = IAUtilities.getCommandFlowTableName();
        Selection selection = PresentationFactory.getInstance().createSelectForTable(new String[]{commandFlowIndexTable, commandFlowTable}, new String[2]);
        selection.getSelect().setDistinct(true);
        selection.getSelect().addSelectionColumn("OWNER_USERID", commandFlowIndexTable, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        selection.getSelect().addSelectionColumn("USERID", commandFlowTable, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        selection.getSelect().addSelectionColumn("CMDFLOW_ID", commandFlowTable, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        selection.getSelect().addSelectionColumn("APPLID", commandFlowTable, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        selection.getSelect().addSelectionColumn("CMD_TIME_LOCAL", commandFlowTable, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        selection.getSelect().addSelectionColumn("TRANSID", commandFlowTable, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        selection.getSelect().addSelectionColumn("TASKID", commandFlowTable, ColumnReference.DataType.String, ColumnReference.Function.NONE);
        FindUserCommandFlowRunsCommand.joinCmdFlowAndCmdFlowIndex(selection);
        selection.appendCondition("TRANSID", commandFlowTable, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.getName()}, QueryElement.Predicate.AND, false);
        Presentation presentation = PresentationFactory.getInstance().createPresentation("", "", "", selection);
        for (ColumnReference columnRef : selection.getSelect().getColumns()) {
            selection.addOrderByCondition(columnRef.getColumnName(), columnRef.getTable(), Direction.ASC);
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"createCommandFlowRunsCommonPart", (Object)presentation.getSelection().toString());
        return presentation;
    }

    @Override
    public void clearTargetInteractions() {
        super.clearTargetInteractions();
        this.programs = null;
        this.firstPrograms = new HashMap();
    }
}

