/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.ia.model.Messages;
import com.ibm.cics.ia.model.Platform;
import com.ibm.cics.ia.model.TSApplication;
import com.ibm.cics.ia.runtime.IAUtilities;

public class TimeLineRowObject {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2014, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Platform platform;
    private TSApplication app;
    private String platformName;
    private String appName;

    public TimeLineRowObject(TSApplication app) {
        this.platform = app.getPlatform();
        if (this.platform != null) {
            this.platformName = this.platform.getName();
        }
        if (!IAUtilities.hasContent(this.platformName)) {
            this.platformName = Messages.getString("ResourceRenderer.undefinedPlatform");
        }
        this.appName = IAUtilities.hasContent(app.getName()) ? app.getFullName() : Messages.getString("ResourceRenderer.undefinedApplication");
        this.app = app;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.app == null ? 0 : this.app.hashCode());
        result = 31 * result + (this.platform == null ? 0 : this.platform.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeLineRowObject other = (TimeLineRowObject)obj;
        if (this.app == null ? other.app != null : !this.app.equals(other.app)) {
            return false;
        }
        return !(this.platform == null ? other.platform != null : !this.platform.equals(other.platform));
    }

    public String toString() {
        return String.valueOf(this.platformName) + " / " + this.appName;
    }
}

