/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.Messages;
import com.ibm.cics.ia.model.Platform;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.ResourcePropertySource;
import com.ibm.cics.ia.model.TSApplication;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.runtime.Version;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class TDQueuePropertySource
extends ResourcePropertySource {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(TDQueuePropertySource.class.getPackage().getName());
    public static final String APPLID = "APPLID";
    public static final String ATIFACILITY = "ATIFACILITY";
    public static final String ATITERMID = "ATITERMID";
    public static final String ATITRANID = "ATITRANID";
    public static final String ATIUSER = "ATIUSER";
    public static final String BLOCKFORMAT = "BLOCKFORMAT";
    public static final String BLOCKSIZE = "BLOCKSIZE";
    public static final String DATABUFFERS = "DATABUFFERS";
    public static final String DDNAME = "DDNAME";
    public static final String DISPOSITION = "DISPOSITION";
    public static final String DSNAME = "DSNAME";
    public static final String ERRORPORTION = "ERROROPTION";
    public static final String FIRST_RUN = "FIRST_RUN";
    public static final String HOMESYSID = "HOMESYSID";
    public static final String INDIRECTNAME = "INDIRECTNAME";
    public static final String INDOUBT = "INDOUBT";
    public static final String INDOUBTWAIT = "INDOUBTWAIT";
    public static final String IOTYPE = "IOTYPE";
    public static final String LAST_RUN = "LAST_RUN";
    public static final String MEMBER = "MEMBER";
    public static final String PRINTCONTROL = "PRINTCONTROL";
    public static final String RECORDFORMAT = "RECORDFORMAT";
    public static final String RECORDLENGTH = "RECORDLENGTH";
    public static final String RECOVSTATUS = "RECOVSTATUS";
    public static final String REMOTENAME = "REMOTENAME";
    public static final String REMOTESYSTEM = "REMOTESYSTEM";
    public static final String REWIND = "REWIND";
    public static final String SYSOUTCLASS = "SYSOUTCLASS";
    public static final String TDQUEUE_NAME = "TDQUEUE_NAME";
    public static final String TRIGGERLEVEL = "TRIGGERLEVEL";
    public static final String TYPE = "TYPE";
    public static final String COLLECTION_ID = "COLLECTION_ID";
    public static final String ARCHIVE_DATE = "ARCHIVE_DATE";
    private static String APPL_NAME = "APPL_NAME";
    private static String APPL_VER1 = "APPL_VER1";
    private static String APPL_VER2 = "APPL_VER2";
    private static String APPL_VER3 = "APPL_VER3";
    private static String APPL_OPER = "APPL_OPER";
    private static String PLATFORM = "PLATFORM";
    private static final String[] ia31propertyIDs = new String[]{"APPLID", "HOMESYSID", "TDQUEUE_NAME", "ATIFACILITY", "ATITERMID", "ATITRANID", "ATIUSER", "BLOCKFORMAT", "BLOCKSIZE", "DATABUFFERS", "DDNAME", "DISPOSITION", "DSNAME", "ERROROPTION", "INDIRECTNAME", "INDOUBT", "INDOUBTWAIT", "IOTYPE", "MEMBER", "PRINTCONTROL", "RECORDFORMAT", "RECORDLENGTH", "RECOVSTATUS", "REMOTENAME", "REMOTESYSTEM", "REWIND", "SYSOUTCLASS", "TRIGGERLEVEL", "TYPE", "FIRST_RUN", "LAST_RUN"};
    private static final String[] ia32propertyIDs = IAUtilities.concat(ia31propertyIDs, new String[][]{{"COLLECTION_ID", "ARCHIVE_DATE"}});
    private static final String[] ia51propertyIDs = IAUtilities.concat(ia32propertyIDs, new String[][]{{APPL_NAME, APPL_VER1, APPL_VER2, APPL_VER3, APPL_OPER}});
    private static final String[] ia52propertyIDs = IAUtilities.concat(ia51propertyIDs, new String[][]{{PLATFORM}});

    public TDQueuePropertySource(Resource resource) {
        super(resource);
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        Debug.enter((Logger)logger, (String)TDQueuePropertySource.class.getName(), (String)"getPropertyDescriptors", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.propertyDescriptors == null && !this.collectionID2Props.containsKey(IASQLCommand.getCollectionId())) {
            List properties = this.resource.getProperties();
            this.processProperties(properties);
        }
        Debug.exit((Logger)logger, (String)TDQueuePropertySource.class.getName(), (String)"getPropertyDescriptors");
        return this.getPropertiesInCurrentCollectionId();
    }

    private void processProperties(List properties) {
        Debug.enter((Logger)logger, (String)TDQueuePropertySource.class.getName(), (String)"processProperties", (Object)("Thread ID: " + Thread.currentThread().getId()));
        String[] propertyIDs = TDQueuePropertySource.getPropertyIDs();
        int i = 0;
        while (i < properties.size()) {
            String categoryName;
            Map m = (Map)properties.get(i);
            ArrayList<PropertyDescriptor> descriptors = (ArrayList<PropertyDescriptor>)this.collectionID2Props.get((String)m.get(COLLECTION_ID));
            if (descriptors == null) {
                descriptors = new ArrayList<PropertyDescriptor>();
                this.collectionID2Props.put((String)m.get(COLLECTION_ID), descriptors);
            }
            int version = Version.getInstance().getDBVersion();
            switch (version) {
                case 3200: {
                    categoryName = MessageFormat.format(Messages.getString("TDQueuePropertySource.3200"), (String)m.get(TDQUEUE_NAME), (String)m.get(COLLECTION_ID), (String)m.get(APPLID));
                    break;
                }
                case 5100: 
                case 5110: {
                    String ver1 = (String)m.get(APPL_VER1);
                    int v1 = IAUtilities.hasContent(ver1) ? Integer.parseInt(ver1) : 0;
                    String ver2 = (String)m.get(APPL_VER2);
                    int v2 = IAUtilities.hasContent(ver2) ? Integer.parseInt(ver2) : 0;
                    String ver3 = (String)m.get(APPL_VER3);
                    int v3 = IAUtilities.hasContent(ver3) ? Integer.parseInt(ver3) : 0;
                    TSApplication app1 = new TSApplication(null, (String)m.get(APPL_NAME), v1, v2, v3);
                    categoryName = String.valueOf(MessageFormat.format(Messages.getString("TDQueuePropertySource.3200"), (String)m.get(TDQUEUE_NAME), (String)m.get(COLLECTION_ID), (String)m.get(APPLID))) + ", " + app1.getFullName() + " (" + m.get(APPL_OPER) + ")";
                    break;
                }
                case 5200: 
                case 5300: 
                case 5500: 
                case 6100: {
                    String ver1 = (String)m.get(APPL_VER1);
                    int v1 = IAUtilities.hasContent(ver1) ? Integer.parseInt(ver1) : 0;
                    String ver2 = (String)m.get(APPL_VER2);
                    int v2 = IAUtilities.hasContent(ver2) ? Integer.parseInt(ver2) : 0;
                    String ver3 = (String)m.get(APPL_VER3);
                    int v3 = IAUtilities.hasContent(ver3) ? Integer.parseInt(ver3) : 0;
                    TSApplication app1 = new TSApplication(new Platform((String)m.get(PLATFORM)), (String)m.get(APPL_NAME), v1, v2, v3);
                    categoryName = String.valueOf(MessageFormat.format(Messages.getString("TDQueuePropertySource.3200"), (String)m.get(TDQUEUE_NAME), (String)m.get(COLLECTION_ID), (String)m.get(APPLID))) + ", " + m.get(PLATFORM) + ", " + app1.getFullName() + " (" + m.get(APPL_OPER) + ")";
                    break;
                }
                case 3100: {
                    categoryName = MessageFormat.format(Messages.getString("TDQueuePropertySource.3100"), (String)m.get(TDQUEUE_NAME), (String)m.get(APPLID));
                    break;
                }
                default: {
                    categoryName = MessageFormat.format(Messages.getString("TDQueuePropertySource.3100"), (String)m.get(TDQUEUE_NAME), (String)m.get(APPLID));
                }
            }
            int j = 0;
            while (j < propertyIDs.length) {
                String key = propertyIDs[j];
                String newKey = String.valueOf(key) + m.get(COLLECTION_ID) + m.get(APPLID) + "_" + Integer.toString(i);
                this.values.put(newKey, m.get(key));
                PropertyDescriptor descriptor = new PropertyDescriptor((Object)newKey, Messages.getString(propertyIDs[j]));
                descriptor.setCategory(categoryName);
                descriptors.add(descriptor);
                ++j;
            }
            ++i;
        }
        Debug.exit((Logger)logger, (String)TDQueuePropertySource.class.getName(), (String)"processProperties");
    }

    public static int getPropertyCount() {
        return TDQueuePropertySource.getPropertyIDs().length;
    }

    public static String[] getPropertyIDs() {
        int version = Version.getInstance().getDBVersion();
        switch (version) {
            case 3100: {
                return ia31propertyIDs;
            }
            case 3200: {
                return ia32propertyIDs;
            }
            case 5100: 
            case 5110: {
                return ia51propertyIDs;
            }
            case 5200: 
            case 5300: 
            case 5500: 
            case 6100: {
                return ia52propertyIDs;
            }
        }
        return ia31propertyIDs;
    }
}

