/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.ia.commands.WebServiceRequest;
import com.ibm.cics.ia.model.AtomContent;
import com.ibm.cics.ia.model.CintAlreadyInUseException;
import com.ibm.cics.ia.model.ScenarioBasedCollectionModel;
import com.ibm.cics.ia.model.webservice.CIUAWSDAClient;
import com.ibm.cics.ia.model.webservice.CIUAWSDARequestProgramInterface;
import com.ibm.cics.ia.model.webservice.CiuawsdaServiceResponse;
import com.ibm.cics.ia.model.webservice.Region;
import com.ibm.cics.ia.runtime.AtomController;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.sm.comm.IAtomConnection;
import java.net.MalformedURLException;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.xml.sax.SAXException;

public class ScenarioBasedCollectionModelImpl
implements ScenarioBasedCollectionModel {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static Logger logger = Logger.getLogger(ScenarioBasedCollectionModelImpl.class.getPackage().getName());
    private CiuawsdaServiceResponse serviceResponse;
    private CIUAWSDAClient client;
    private IConnection connection;
    private CIUAWSDARequestProgramInterface.WsInBuf wsInBuf;
    private AtomContent atomContent;

    public ScenarioBasedCollectionModelImpl(String applId, String sysId, IConnection connection) throws MalformedURLException, JAXBException, SAXException, CintAlreadyInUseException {
        this.connection = connection;
        ConnectionConfiguration connConfig = connection.getConfiguration();
        this.client = new CIUAWSDAClient(connConfig.getHost(), connConfig.getPort(), connConfig.getUserID(), connConfig.getPassword(), connConfig.getSecureHint());
        this.serviceResponse = this.client.reguestRegionPropertiesForEditing(applId, sysId);
        WebServiceRequest.showMessage(this.serviceResponse.getMessage());
        if (this.serviceResponse.getMessage().getMsgnum().trim().equals("CIU2101W")) {
            throw new CintAlreadyInUseException();
        }
        this.wsInBuf = new CIUAWSDARequestProgramInterface.WsInBuf();
        this.wsInBuf.setWsInApplid(applId);
        this.wsInBuf.setWsInSysid(sysId);
        Region region = this.serviceResponse.getRegion();
        CIUAWSDARequestProgramInterface.WsInBuf.ScnOptions scnOptions = new CIUAWSDARequestProgramInterface.WsInBuf.ScnOptions();
        scnOptions.setScnCode(ScenarioBasedCollectionModel.CollectionType.T.name());
        scnOptions.setScnDb2(region.getFlagDb2().trim());
        scnOptions.setScnIms(region.getFlagIms().trim());
        scnOptions.setScnMq(region.getFlagMq().trim());
        scnOptions.setScnCpsm(region.getFlagCpsm().trim());
        scnOptions.setScnNat(region.getFlagNat().trim());
        scnOptions.setScnOpt(region.getFlagOpt().trim());
        this.wsInBuf.setScnOptions(scnOptions);
    }

    @Override
    public void setCollectionType(ScenarioBasedCollectionModel.CollectionType type) {
        this.wsInBuf.getScnOptions().setScnCode(type.name());
    }

    @Override
    public ScenarioBasedCollectionModel.CollectionType getCollectionType() {
        return ScenarioBasedCollectionModel.CollectionType.valueOf(this.wsInBuf.getScnOptions().getScnCode().trim());
    }

    @Override
    public void startScenarioBasedCollection() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"startScenarioBasedCollection", (Object)("Thread ID: " + Thread.currentThread().getId()));
        try {
            this.serviceResponse = this.client.startScenarioBasedCollection(this.wsInBuf);
            WebServiceRequest.showMessage(this.serviceResponse.getMessage());
            if (this.serviceResponse.getMessage().getMsgnum().trim().equals("CIU2101W")) {
                return;
            }
            this.atomContent = WebServiceRequest.createAtomContent(this.connection.getConfiguration().getID(), this.serviceResponse.getRegion(), false);
        }
        catch (Exception e) {
            AtomController.getInstance().disconnect((IAtomConnection)this.connection, this.client.getLastHttpResponseCode(), this.client.getLastHttpResponseMsg());
            Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"startScenarioBasedCollection", (Object)e);
            IAPlugin.getDefault().logError("Unable to get the response from the webservice", e);
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"startScenarioBasedCollection");
    }

    @Override
    public void setDb2Enabled(Boolean enabled) {
        if (enabled == null) {
            this.wsInBuf.getScnOptions().setScnDb2(null);
        } else {
            this.wsInBuf.getScnOptions().setScnDb2(enabled != false ? YesNo.Y.name() : YesNo.N.name());
        }
    }

    @Override
    public void setMqEnabled(Boolean enabled) {
        if (enabled == null) {
            this.wsInBuf.getScnOptions().setScnMq(null);
        } else {
            this.wsInBuf.getScnOptions().setScnMq(enabled != false ? YesNo.Y.name() : YesNo.N.name());
        }
    }

    @Override
    public void setImsEnabled(Boolean enabled) {
        if (enabled == null) {
            this.wsInBuf.getScnOptions().setScnIms(null);
        } else {
            this.wsInBuf.getScnOptions().setScnIms(enabled != false ? YesNo.Y.name() : YesNo.N.name());
        }
    }

    @Override
    public boolean isDb2Enabled() {
        return this.wsInBuf.getScnOptions().getScnDb2().trim().equals(YesNo.Y.name());
    }

    @Override
    public boolean isMqEnabled() {
        return this.wsInBuf.getScnOptions().getScnMq().trim().equals(YesNo.Y.name());
    }

    @Override
    public boolean isImsEnabled() {
        return this.wsInBuf.getScnOptions().getScnIms().trim().equals(YesNo.Y.name());
    }

    @Override
    public boolean isCpsmEnabled() {
        return this.wsInBuf.getScnOptions().getScnCpsm().trim().equals(YesNo.Y.name());
    }

    @Override
    public boolean isNatEnabled() {
        return this.wsInBuf.getScnOptions().getScnNat().trim().equals(YesNo.Y.name());
    }

    @Override
    public boolean isOptEnabled() {
        return this.wsInBuf.getScnOptions().getScnOpt().trim().equals(YesNo.Y.name());
    }

    @Override
    public String getApplId() {
        return this.wsInBuf.getWsInApplid();
    }

    @Override
    public AtomContent getAtomContent() {
        return this.atomContent;
    }

    @Override
    public void setCpsmEnabled(Boolean enabled) {
        if (enabled == null) {
            this.wsInBuf.getScnOptions().setScnCpsm(null);
        } else {
            this.wsInBuf.getScnOptions().setScnCpsm(enabled != false ? YesNo.Y.name() : YesNo.N.name());
        }
    }

    @Override
    public void setNatEnabled(Boolean enabled) {
        if (enabled == null) {
            this.wsInBuf.getScnOptions().setScnNat(null);
        } else {
            this.wsInBuf.getScnOptions().setScnNat(enabled != false ? YesNo.Y.name() : YesNo.N.name());
        }
    }

    @Override
    public void setOptEnabled(Boolean enabled) {
        if (enabled == null) {
            this.wsInBuf.getScnOptions().setScnOpt(null);
        } else {
            this.wsInBuf.getScnOptions().setScnOpt(enabled != false ? YesNo.Y.name() : YesNo.N.name());
        }
    }

    static enum YesNo {
        Y,
        N;

    }
}

