/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public abstract class ResourcePropertySource
implements IPropertySource {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ResourcePropertySource.class.getPackage().getName());
    public static final String APPLID = "APPLID";
    public static final String COLLECTION_ID = "COLLECTION_ID";
    protected IPropertyDescriptor[] propertyDescriptors;
    protected Resource resource;
    protected Map values = new HashMap();
    protected HashMap<String, List<IPropertyDescriptor>> collectionID2Props = new HashMap();

    public ResourcePropertySource(Resource resource) {
        this.resource = resource;
    }

    public Object getEditableValue() {
        return null;
    }

    public abstract IPropertyDescriptor[] getPropertyDescriptors();

    protected IPropertyDescriptor[] getPropertiesInCurrentCollectionId() {
        Debug.enter((Logger)logger, (String)ResourcePropertySource.class.getName(), (String)"getPropertiesInCurrentCollectionId", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (IASQLCommand.getCollectionId().isEmpty()) {
            this.initAllProperties();
            Debug.exit((Logger)logger, (String)ResourcePropertySource.class.getName(), (String)"getPropertiesInCurrentCollectionId");
            return this.propertyDescriptors;
        }
        ArrayList descriptors = new ArrayList();
        if (this.collectionID2Props.containsKey(IASQLCommand.getCollectionId())) {
            descriptors.addAll(this.collectionID2Props.get(IASQLCommand.getCollectionId()));
        }
        Debug.exit((Logger)logger, (String)ResourcePropertySource.class.getName(), (String)"getPropertiesInCurrentCollectionId");
        return descriptors.toArray(new IPropertyDescriptor[descriptors.size()]);
    }

    protected void initAllProperties() {
        Debug.enter((Logger)logger, (String)ResourcePropertySource.class.getName(), (String)"initAllProperties", (Object)("Thread ID: " + Thread.currentThread().getId()));
        ArrayList<IPropertyDescriptor> descriptors = new ArrayList<IPropertyDescriptor>();
        for (List<IPropertyDescriptor> list : this.collectionID2Props.values()) {
            descriptors.addAll(list);
        }
        this.propertyDescriptors = descriptors.toArray(new IPropertyDescriptor[descriptors.size()]);
        Debug.exit((Logger)logger, (String)ResourcePropertySource.class.getName(), (String)"initAllProperties");
    }

    public Object getPropertyValue(Object id) {
        return this.values.get(id);
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

