/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.ia.model.AffGroup;
import com.ibm.cics.ia.model.CICSResource;
import com.ibm.cics.ia.model.CincCollector;
import com.ibm.cics.ia.model.CintCollector;
import com.ibm.cics.ia.model.DB2Resource;
import com.ibm.cics.ia.model.Exit;
import com.ibm.cics.ia.model.File;
import com.ibm.cics.ia.model.IAApplication;
import com.ibm.cics.ia.model.IAffinityBuilderInputGroup;
import com.ibm.cics.ia.model.IMSResource;
import com.ibm.cics.ia.model.MQResource;
import com.ibm.cics.ia.model.Platform;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.Service;
import com.ibm.cics.ia.model.TDQueue;
import com.ibm.cics.ia.model.TSApplication;
import com.ibm.cics.ia.model.TSQueue;
import com.ibm.cics.ia.model.Task;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.model.Webservice;
import com.ibm.cics.ia.query.SQLDefinitions;
import com.ibm.cics.ia.runtime.AtomController;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.runtime.IAtomControllerListener;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Preferences;

public class ResourceFactory
implements Serializable {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ResourceFactory.class.getPackage().getName());
    private static final long serialVersionUID = 4898870556964721925L;
    private static ResourceFactory singleton = new ResourceFactory();
    private Map<String, Map<String, Resource>> resourcesMap = new HashMap<String, Map<String, Resource>>();
    private Map<String, Map<String, DB2Resource>> DB2ResourcesMap = new HashMap<String, Map<String, DB2Resource>>();
    private Map<String, Map<String, IMSResource>> IMSResourcesMap = new HashMap<String, Map<String, IMSResource>>();
    private Map<String, Map<String, MQResource>> MQResourcesMap = new HashMap<String, Map<String, MQResource>>();
    private Map<String, Program> programs = new HashMap<String, Program>();
    private Map<String, Transaction> transactions = new HashMap<String, Transaction>();
    private Map<String, Webservice> webservices = new HashMap<String, Webservice>();
    private Map<String, Service> services = new HashMap<String, Service>();
    private Map<String, IAApplication> iaApplications = new HashMap<String, IAApplication>();
    private Map<Platform, Map<String, TSApplication>> tsApplicationsByPlatforms = new HashMap<Platform, Map<String, TSApplication>>();
    private Map<String, Region> regions = new HashMap<String, Region>();
    private Map<String, Task> tasks = new HashMap<String, Task>();
    private Map<String, AffGroup> affGroups = new HashMap<String, AffGroup>();
    private Map<String, Map<String, CintCollector>> cintCollectors = new HashMap<String, Map<String, CintCollector>>();
    private Map<String, Map<String, CincCollector>> cincCollectors = new HashMap<String, Map<String, CincCollector>>();
    private Map<String, Platform> platforms = new HashMap<String, Platform>();
    private HashMap<Transaction, Map<String, Task>> tasksForTransaction = new HashMap();

    private ResourceFactory() {
        Debug.enter((Logger)logger, (String)ResourceFactory.class.getName(), (String)"ResourceFactory", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Preferences preferenceStore = IAPlugin.getDefault().getPluginPreferences();
        preferenceStore.addPropertyChangeListener(new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent event) {
                Debug.enter((Logger)logger, (String)"ResourceFactory.PropertyChangeListener", (String)"propertyChange", (Object)("Thread ID: " + Thread.currentThread().getId()));
                String propertyName = event.getProperty();
                if ("AFFINITY_DATA".equals(propertyName) || "CICS_DATA".equals(propertyName) || "DB2_DATA".equals(propertyName) || "IMS_DATA".equals(propertyName) || "MQ_DATA".equals(propertyName)) {
                    for (Map.Entry entry : ResourceFactory.this.programs.entrySet()) {
                        Program program = (Program)entry.getValue();
                        program.clearTargetInteractions();
                    }
                }
                Debug.exit((Logger)logger, (String)"ResourceFactory.PropertyChangeListener", (String)"propertyChange");
            }
        });
        AtomController.getInstance().addAtomControllerListener(new IAtomControllerListener(){

            @Override
            public void disconnected(IConnection connection) {
                Debug.enter((Logger)logger, (String)"ResourceFactory.AtomControllerListener", (String)"disconnected", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "connection: " + connection.getName()});
                String nonActiveConnectionId = connection.getConfiguration().getID();
                for (Map.Entry entry : ResourceFactory.this.regions.entrySet()) {
                    Region region = (Region)entry.getValue();
                    CintCollector cintCollector = region.getCollector();
                    if (cintCollector == null || !nonActiveConnectionId.equals(cintCollector.getConnectionID())) continue;
                    region.setCintCollector(null);
                }
                ResourceFactory.this.cincCollectors.remove(nonActiveConnectionId);
                ResourceFactory.this.cintCollectors.remove(nonActiveConnectionId);
                Debug.exit((Logger)logger, (String)"ResourceFactory.AtomControllerListener", (String)"disconnected");
            }

            @Override
            public void connected(IConnection connection) {
            }
        });
    }

    public void clear() {
        Debug.enter((Logger)logger, (String)ResourceFactory.class.getName(), (String)"clear", (Object)("Thread ID: " + Thread.currentThread().getId()));
        this.resourcesMap = new HashMap<String, Map<String, Resource>>();
        this.DB2ResourcesMap = new HashMap<String, Map<String, DB2Resource>>();
        this.IMSResourcesMap = new HashMap<String, Map<String, IMSResource>>();
        this.MQResourcesMap = new HashMap<String, Map<String, MQResource>>();
        this.programs = new HashMap<String, Program>();
        this.transactions = new HashMap<String, Transaction>();
        this.webservices = new HashMap<String, Webservice>();
        this.services = new HashMap<String, Service>();
        this.iaApplications = new HashMap<String, IAApplication>();
        this.tsApplicationsByPlatforms = new HashMap<Platform, Map<String, TSApplication>>();
        this.regions = new HashMap<String, Region>();
        this.tasks = new HashMap<String, Task>();
        this.affGroups = new HashMap<String, AffGroup>();
        this.cintCollectors = new HashMap<String, Map<String, CintCollector>>();
        this.cincCollectors = new HashMap<String, Map<String, CincCollector>>();
        this.tasksForTransaction = new HashMap();
        Debug.exit((Logger)logger, (String)ResourceFactory.class.getName(), (String)"clear");
    }

    public static ResourceFactory getSingleton() {
        return singleton;
    }

    public Region getRegion(String applId) {
        Debug.enter((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getRegion", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "applId: " + applId});
        applId = applId.trim();
        Region result = this.regions.get(applId);
        if (result == null) {
            result = new Region(applId);
            this.regions.put(applId, result);
        }
        Debug.exit((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getRegion", (Object)("result: " + result.getName()));
        return result;
    }

    public IAApplication getIAApplication(String applicationId, String applicationName) {
        Debug.enter((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getIAApplication", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "applicationId: " + applicationId, "applicationName: " + applicationName});
        if (applicationName == null) {
            applicationName = "";
        }
        applicationName = applicationName.trim();
        IAApplication result = this.iaApplications.get(applicationId);
        if (result == null) {
            result = new IAApplication(applicationId, applicationName);
            this.iaApplications.put(applicationName, result);
        }
        Debug.exit((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getIAApplication", (Object)("result: " + result.getName()));
        return result;
    }

    public TSApplication getTSApplication(Platform platform, String applicationName, int majorVersion, int minorVersion, int microVersion) {
        TSApplication result;
        Debug.enter((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getTSApplication", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "platform: " + (platform == null ? platform : platform.getName()), "applicationName: " + applicationName, "majorVersion: " + majorVersion, "minorVersion: " + minorVersion, "microVersion: " + microVersion});
        String fullName = TSApplication.getFullName(applicationName, majorVersion, minorVersion, microVersion);
        Map<String, TSApplication> applications = this.tsApplicationsByPlatforms.get(platform);
        if (applications == null) {
            applications = new HashMap<String, TSApplication>();
            this.tsApplicationsByPlatforms.put(platform, applications);
        }
        if ((result = applications.get(fullName)) == null) {
            result = new TSApplication(platform, applicationName, majorVersion, minorVersion, microVersion);
            applications.put(fullName, result);
        }
        Debug.exit((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getTSApplication", (Object)("result: " + result.getName()));
        return result;
    }

    public Program getProgram(String programName) {
        Debug.enter((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getProgram", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "programName: " + programName});
        programName = programName.trim();
        Program result = this.programs.get(programName);
        if (result == null) {
            result = new Program(programName);
            this.programs.put(programName, result);
        }
        Debug.exit((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getProgram", (Object)("result: " + result.getName()));
        return result;
    }

    public Transaction getTransaction(String transactionID) {
        Debug.enter((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getTransaction", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "transactionID: " + transactionID});
        transactionID = transactionID.trim();
        Transaction result = this.transactions.get(transactionID);
        if (result == null) {
            result = new Transaction(transactionID);
            this.transactions.put(transactionID, result);
        }
        Debug.exit((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getTransaction", (Object)("result: " + result.getName()));
        return result;
    }

    public Webservice getWebservice(String webserviceID) {
        Debug.enter((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getWebservice", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "webserviceID: " + webserviceID});
        webserviceID = webserviceID.trim();
        Webservice result = this.webservices.get(webserviceID);
        if (result == null) {
            result = new Webservice(webserviceID);
            this.webservices.put(webserviceID, result);
        }
        Debug.exit((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getWebservice", (Object)("result: " + result.getName()));
        return result;
    }

    public IAffinityBuilderInputGroup getAffGroup(String tranGroup, HashMap<String, String> values) {
        Debug.enter((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getAffGroup", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "tranGroup: " + tranGroup, "values size: " + values.size()});
        AffGroup result = this.affGroups.get(tranGroup);
        if (result == null) {
            result = new AffGroup(tranGroup, values);
            this.affGroups.put(tranGroup, result);
        }
        Debug.exit((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getAffGroup", (Object)("result resource: " + result.getResourceName()));
        return result;
    }

    public Service getService(String serviceID) {
        Debug.enter((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getService", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "serviceID: " + serviceID});
        serviceID = serviceID.trim();
        Service result = this.services.get(serviceID);
        if (result == null) {
            result = new Service(serviceID);
            this.services.put(serviceID, result);
        }
        Debug.exit((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getService", (Object)("result: " + result.getName()));
        return result;
    }

    public DB2Resource getDB2Resource(String objectType, String objectName) {
        Debug.enter((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getDB2Resource", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "objectType: " + objectType, "objectName: " + objectName});
        objectName = objectName.trim();
        objectType = objectType.trim();
        Map<String, DB2Resource> objectsForType = this.DB2ResourcesMap.get(objectType);
        if (objectsForType == null) {
            objectsForType = new HashMap<String, DB2Resource>();
            this.DB2ResourcesMap.put(objectType, objectsForType);
            DB2Resource result = new DB2Resource(objectType, objectName);
            objectsForType.put(objectName, result);
            Debug.exit((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getDB2Resource");
            return result;
        }
        DB2Resource result = objectsForType.get(objectName);
        if (result == null) {
            result = new DB2Resource(objectType, objectName);
            objectsForType.put(objectName, result);
        }
        Debug.exit((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getDB2Resource", (Object)("result: " + result.getName()));
        return result;
    }

    public IMSResource getIMSResource(String objectType, String objectName) {
        Debug.enter((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getIMSResource", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "objectType: " + objectType, "objectName: " + objectName});
        objectName = objectName.trim();
        objectType = objectType.trim();
        Map<String, IMSResource> objectsForType = this.IMSResourcesMap.get(objectType);
        if (objectsForType == null) {
            objectsForType = new HashMap<String, IMSResource>();
            this.IMSResourcesMap.put(objectType, objectsForType);
            IMSResource result = new IMSResource(objectType, objectName);
            objectsForType.put(objectName, result);
            Debug.exit((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getIMSResource");
            return result;
        }
        IMSResource result = objectsForType.get(objectName);
        if (result == null) {
            result = new IMSResource(objectType, objectName);
            objectsForType.put(objectName, result);
        }
        Debug.exit((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getIMSResource", (Object)("result: " + result.getName()));
        return result;
    }

    public MQResource getMQResource(String objectType, String objectName) {
        Debug.enter((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getMQResource", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "objectType: " + objectType, "objectName: " + objectName});
        objectName = objectName.trim();
        objectType = objectType.trim();
        Map<String, MQResource> objectsForType = this.MQResourcesMap.get(objectType);
        if (objectsForType == null) {
            objectsForType = new HashMap<String, MQResource>();
            this.MQResourcesMap.put(objectType, objectsForType);
            MQResource result = new MQResource(objectType, objectName);
            objectsForType.put(objectName, result);
            Debug.exit((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getMQResource", (Object)("result: " + result.getName()));
            return result;
        }
        MQResource result = objectsForType.get(objectName);
        if (result == null) {
            result = new MQResource(objectType, objectName);
            objectsForType.put(objectName, result);
        }
        Debug.exit((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getMQResource", (Object)("result: " + result.getName()));
        return result;
    }

    public Resource getResource(String objectType, String objectName) {
        Debug.enter((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getResource", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "objectType: " + objectType, "objectName: " + objectName});
        objectName = IAUtilities.removeTrailingBlanks(objectName);
        objectType = objectType.trim();
        if ("TRANSID".equals(objectType)) {
            Debug.exit((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getResource");
            return this.getTransaction(objectName);
        }
        if ("PROGRAM".equals(objectType)) {
            Debug.exit((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getResource");
            return this.getProgram(objectName);
        }
        if ("IA_APPLICATION".equals(objectType)) {
            Debug.exit((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getResource");
            return this.getIAApplication(objectName, null);
        }
        if ("WEBSERVICE".equals(objectType)) {
            Debug.exit((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getResource");
            return this.getWebservice(objectName);
        }
        if ("SERVICE".equals(objectType)) {
            Debug.exit((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getResource");
            return this.getService(objectName);
        }
        Map<String, Resource> objectsForType = this.resourcesMap.get(objectType);
        if (objectsForType == null) {
            objectsForType = new HashMap<String, Resource>();
            this.resourcesMap.put(objectType, objectsForType);
            Resource result = this.createResource(objectType, objectName, objectsForType);
            Debug.exit((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getResource", (Object)("result: " + result.getName()));
            return result;
        }
        Resource result = objectsForType.get(objectName);
        if (result == null) {
            result = this.createResource(objectType, objectName, objectsForType);
        }
        Debug.exit((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getResource", (Object)("result: " + (result == null ? result : result.getName())));
        return result;
    }

    private Resource createResource(String objectType, String objectName, Map<String, Resource> objectsForType) {
        Debug.enter((Logger)logger, (String)ResourceFactory.class.getName(), (String)"createResource", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "objectType: " + objectType, "objectName: " + objectName, "objectsForType size: " + objectsForType.size()});
        Resource result = "FILE".equals(objectType) ? new File(objectName) : ("TDQUEUE".equals(objectType) ? new TDQueue(objectName) : ("TSQUEUE".equals(objectType) ? new TSQueue("TSQUEUE", objectName) : ("TSQUEUE SHARED".equals(objectType) ? new TSQueue("TSQUEUE SHARED", objectName) : ("TSQUEUE AUX".equals(objectType) ? new TSQueue("TSQUEUE AUX", objectName) : ("EXIT".equals(objectType) ? new Exit(objectName) : ("APPLID".equals(objectType) ? new Region(objectName) : (this.isMQType(objectType) ? new MQResource(objectType, objectName) : (this.isDB2Type(objectType) ? new DB2Resource(objectType, objectName) : (this.isIMSType(objectType) ? new IMSResource(objectType, objectName) : new CICSResource(objectType, objectName))))))))));
        objectsForType.put(objectName, result);
        Debug.exit((Logger)logger, (String)ResourceFactory.class.getName(), (String)"createResource", (Object)("result: " + result.getName()));
        return result;
    }

    private boolean isIMSType(String objectType) {
        return this.contains(SQLDefinitions.IMS_TYPES, objectType);
    }

    private boolean isDB2Type(String objectType) {
        return this.contains(SQLDefinitions.DB2_TYPES, objectType);
    }

    private boolean isMQType(String objectType) {
        return this.contains(SQLDefinitions.MQ_TYPES, objectType);
    }

    private boolean contains(String[] types, String objectType) {
        return Arrays.asList(types).contains(objectType);
    }

    public static void setSingleton(ResourceFactory factory) {
        singleton = factory;
    }

    public Map<String, Program> getPrograms() {
        return this.programs;
    }

    public Map<String, Transaction> getTransactions() {
        return this.transactions;
    }

    public Map<String, Region> getRegions() {
        return this.regions;
    }

    public Task getTask(Transaction transaction, String taskName, String applId) {
        String taskKey;
        Task result;
        Debug.enter((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getTask", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "taskName: " + taskName, "transaction: " + (transaction == null ? transaction : transaction.getName())});
        taskName = taskName.trim();
        this.tasks = this.tasksForTransaction.get(transaction);
        if (this.tasks == null) {
            this.tasks = new HashMap<String, Task>();
            this.tasksForTransaction.put(transaction, this.tasks);
        }
        if ((result = this.tasks.get(taskKey = String.valueOf(taskName) + (applId == null ? "" : applId))) == null) {
            result = new Task(taskName, transaction, applId);
            this.tasks.put(taskKey, result);
        }
        Debug.exit((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getTask", (Object)("result: " + result.getName()));
        return result;
    }

    public CintCollector getCintCollector(String connectionId, String applid) {
        Debug.enter((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getCintCollector", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "connectionId: " + connectionId, "applid: " + applid});
        Map<String, CintCollector> collectors = this.cintCollectors.get(connectionId);
        if (collectors == null) {
            collectors = new HashMap<String, CintCollector>();
            this.cintCollectors.put(connectionId, collectors);
        }
        CintCollector result = collectors.get(applid);
        Debug.exit((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getCintCollector", (Object)("result: " + (result == null ? "" : result.getName())));
        return result;
    }

    public Map<String, CintCollector> getCintCollectors(String connectionId) {
        Debug.enter((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getCintCollectors", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "connectionId: " + connectionId});
        Map<String, CintCollector> collectors = this.cintCollectors.get(connectionId);
        if (collectors == null) {
            collectors = new HashMap<String, CintCollector>();
            this.cintCollectors.put(connectionId, collectors);
        }
        Debug.exit((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getCintCollectors", (Object)("result size: " + collectors.size()));
        return collectors;
    }

    public void putCintCollector(String connectionId, String applid, CintCollector collector) {
        Debug.enter((Logger)logger, (String)ResourceFactory.class.getName(), (String)"putCintCollector", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "connectionId: " + connectionId, "applId: " + applid, "collector: " + (collector == null ? collector : collector.getName())});
        Map<String, CintCollector> collectors = this.cintCollectors.get(connectionId);
        if (collectors == null) {
            collectors = new HashMap<String, CintCollector>();
            this.cintCollectors.put(connectionId, collectors);
        }
        collectors.put(applid, collector);
        Debug.exit((Logger)logger, (String)ResourceFactory.class.getName(), (String)"putCintCollector");
    }

    public CincCollector getCincCollector(String connectionId, String userId) {
        Debug.enter((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getCincCollector", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "connectionId: " + connectionId, "userId: " + userId});
        Map<String, CincCollector> collectors = this.cincCollectors.get(connectionId);
        if (collectors == null) {
            collectors = new HashMap<String, CincCollector>();
            this.cincCollectors.put(connectionId, collectors);
        }
        CincCollector result = collectors.get(userId);
        Debug.exit((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getCincCollector", (Object)("result connectionId: " + (result == null ? "" : result.getConnectionID())));
        return result;
    }

    public void putCincCollector(String connectionId, String userId, CincCollector collector) {
        Debug.enter((Logger)logger, (String)ResourceFactory.class.getName(), (String)"putCincCollector", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "connectionId: " + connectionId, "userId: " + userId, "collector state: " + (collector == null ? collector : collector.getState())});
        Map<String, CincCollector> collectors = this.cincCollectors.get(connectionId);
        if (collectors == null) {
            collectors = new HashMap<String, CincCollector>();
            this.cincCollectors.put(connectionId, collectors);
        }
        collectors.put(userId, collector);
        Debug.exit((Logger)logger, (String)ResourceFactory.class.getName(), (String)"putCincCollector");
    }

    public Platform getPlatform(String platformName) {
        Debug.enter((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getPlatform", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "platform: " + platformName});
        Platform platform = this.platforms.get(platformName);
        if (platform == null) {
            platform = new Platform(platformName.trim());
            this.platforms.put(platformName, platform);
        }
        Debug.exit((Logger)logger, (String)ResourceFactory.class.getName(), (String)"getPlatform", (Object)("platform: " + platform.getName()));
        return platform;
    }

    public static interface Listener {
        public void reset();
    }
}

