/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.ResourceFactory;
import com.ibm.cics.ia.runtime.IAUtilities;
import java.util.logging.Logger;

public class ResourceAndVerb {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ResourceAndVerb.class.getPackage().getName());
    private String resourceName;
    private String resourceType;
    private String verb;
    private Resource resource;

    public ResourceAndVerb(String resourceName, String resourceType, String functionName) {
        Debug.enter((Logger)logger, (String)ResourceAndVerb.class.getName(), (String)"ResourceAndVerb", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "resourceName: " + resourceName, "resourceType: " + resourceType, "functionName: " + functionName});
        this.resourceName = resourceName;
        this.resourceType = resourceType;
        this.verb = functionName;
        if (!StringUtil.isEmpty((String)resourceType) && !IAUtilities.hasContent(resourceName) && resourceType.matches("TEXT")) {
            this.resourceName = String.valueOf(this.verb) + " " + resourceType;
        }
        this.resource = ResourceFactory.getSingleton().getResource(this.resourceType, this.resourceName);
        Debug.exit((Logger)logger, (String)ResourceAndVerb.class.getName(), (String)"ResourceAndVerb");
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public String getVerb() {
        return this.verb;
    }

    public Object getData() {
        return this.resource != null ? this.resource : this.verb;
    }

    public String getName() {
        return this.resourceName;
    }

    public String getType() {
        return this.resourceType;
    }
}

