/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.Messages;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.ResourcePropertySource;
import com.ibm.cics.ia.runtime.Version;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class RegionPropertySource
extends ResourcePropertySource {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(RegionPropertySource.class.getPackage().getName());
    public static final String AFF_COLL_LASTSTART = "AFF_COLL_LASTSTART";
    public static final String AFF_COLL_LASTSAVE = "AFF_COLL_LASTSAVE";
    public static final String APPLID = "APPLID";
    public static final String CICS_RELEASE = "CICS_RELEASE";
    public static final String CSD_NAME = "CSD_NAME";
    public static final String CSD_GROUP_LIST1 = "CSD_GROUP_LIST1";
    public static final String CSD_GROUP_LIST2 = "CSD_GROUP_LIST2";
    public static final String CSD_GROUP_LIST3 = "CSD_GROUP_LIST3";
    public static final String CSD_GROUP_LIST4 = "CSD_GROUP_LIST4";
    public static final String DEP_COLL_LASTSTART = "DEP_COLL_LASTSTART";
    public static final String DEP_COLL_LASTSAVE = "DEP_COLL_LASTSAVE";
    public static final String HOMESYSID = "HOMESYSID";
    public static final String STORAGE_PROTECT = "STORAGE_PROTECT";
    public static final String COLLECTION_ID = "COLLECTION_ID";
    public static final String ARCHIVE_DATE = "ARCHIVE_DATE";
    private static final String[] ia31propertyIDs = new String[]{"APPLID", "HOMESYSID", "CICS_RELEASE", "CSD_NAME", "CSD_GROUP_LIST1", "CSD_GROUP_LIST2", "CSD_GROUP_LIST3", "CSD_GROUP_LIST4", "STORAGE_PROTECT", "DEP_COLL_LASTSTART", "DEP_COLL_LASTSAVE", "AFF_COLL_LASTSTART", "AFF_COLL_LASTSAVE"};
    private static final String[] ia32propertyIDs = new String[]{"APPLID", "HOMESYSID", "CICS_RELEASE", "CSD_NAME", "CSD_GROUP_LIST1", "CSD_GROUP_LIST2", "CSD_GROUP_LIST3", "CSD_GROUP_LIST4", "STORAGE_PROTECT", "DEP_COLL_LASTSTART", "DEP_COLL_LASTSAVE", "AFF_COLL_LASTSTART", "AFF_COLL_LASTSAVE", "COLLECTION_ID", "ARCHIVE_DATE"};

    public RegionPropertySource(Resource resource) {
        super(resource);
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        Debug.enter((Logger)logger, (String)RegionPropertySource.class.getName(), (String)"getPropertyDescriptors", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.propertyDescriptors == null && !this.collectionID2Props.containsKey(IASQLCommand.getCollectionId())) {
            List properties = this.resource.getProperties();
            this.processProperties(properties);
        }
        Debug.exit((Logger)logger, (String)RegionPropertySource.class.getName(), (String)"getPropertyDescriptors");
        return this.getPropertiesInCurrentCollectionId();
    }

    private void processProperties(List properties) {
        Debug.enter((Logger)logger, (String)RegionPropertySource.class.getName(), (String)"processProperties", (Object)("Thread ID: " + Thread.currentThread().getId()));
        ArrayList<PropertyDescriptor> descriptors = null;
        String[] propertyIDs = RegionPropertySource.getPropertyIDs();
        int i = 0;
        while (i < properties.size()) {
            String categoryName;
            Map m = (Map)properties.get(i);
            descriptors = (ArrayList<PropertyDescriptor>)this.collectionID2Props.get((String)m.get(COLLECTION_ID));
            if (descriptors == null) {
                descriptors = new ArrayList<PropertyDescriptor>();
                this.collectionID2Props.put((String)m.get(COLLECTION_ID), descriptors);
            }
            int version = Version.getInstance().getDBVersion();
            switch (version) {
                case 3200: 
                case 5100: 
                case 5110: 
                case 5200: 
                case 5300: 
                case 5500: 
                case 6100: {
                    categoryName = MessageFormat.format(Messages.getString("RegionPropertySource.3200"), (String)m.get(APPLID), (String)m.get(COLLECTION_ID));
                    break;
                }
                case 3100: {
                    categoryName = MessageFormat.format(Messages.getString("RegionPropertySource.3100"), (String)m.get(APPLID));
                    break;
                }
                default: {
                    categoryName = MessageFormat.format(Messages.getString("RegionPropertySource.3100"), (String)m.get(APPLID));
                }
            }
            int j = 0;
            while (j < propertyIDs.length) {
                String key = propertyIDs[j];
                String newKey = String.valueOf(key) + m.get(COLLECTION_ID) + m.get(APPLID) + "_" + Integer.toString(i);
                this.values.put(newKey, m.get(key));
                PropertyDescriptor descriptor = new PropertyDescriptor((Object)newKey, Messages.getString(propertyIDs[j]));
                descriptor.setCategory(categoryName);
                descriptors.add(descriptor);
                ++j;
            }
            ++i;
        }
        Debug.exit((Logger)logger, (String)RegionPropertySource.class.getName(), (String)"processProperties");
    }

    public static int getPropertyCount() {
        return RegionPropertySource.getPropertyIDs().length;
    }

    public static String[] getPropertyIDs() {
        int version = Version.getInstance().getDBVersion();
        switch (version) {
            case 3200: 
            case 5100: 
            case 5110: 
            case 5200: 
            case 5300: 
            case 5500: 
            case 6100: {
                return ia32propertyIDs;
            }
            case 3100: {
                return ia31propertyIDs;
            }
        }
        return ia31propertyIDs;
    }
}

