/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.StoredProcedureCommand;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.model.Messages;
import com.ibm.cics.ia.model.PurgeDataCollector;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.storedproc.ProcedureCIUSPDPG;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class PurgeRunnable
implements IRunnableWithProgress {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(PurgeRunnable.class.getPackage().getName());
    private PurgeDataCollector data;

    public PurgeDataCollector getData() {
        return this.data;
    }

    public void setData(PurgeDataCollector data) {
        this.data = data;
    }

    public PurgeRunnable(PurgeDataCollector data) {
        this.data = data;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        Debug.enter((Logger)logger, (String)PurgeRunnable.class.getName(), (String)"run", (Object[])new String[]{"ThreadID = " + Thread.currentThread().getId(), "regions: " + this.data.getRegions().toString(), "tables: " + this.data.getSelectedTables().toString()});
        monitor.beginTask(this.data.getProgram().getName(), -1);
        for (Region region : this.data.getRegions()) {
            for (String table : this.data.getSelectedTables()) {
                this.storedProcedureExecute("L", region, table);
                this.storedProcedureExecute("D", region, table);
            }
        }
        monitor.done();
        Debug.exit((Logger)logger, (String)PurgeRunnable.class.getName(), (String)"run");
    }

    public void storedProcedureExecute(final String executionType, final Region region, final String table) {
        Debug.enter((Logger)logger, (String)PurgeRunnable.class.getName(), (String)"storedProcedureExecute", (Object[])new String[]{"ThreadID = " + Thread.currentThread().getId(), "execution type: " + executionType, "region: " + region.getName(), "table: " + table});
        StoredProcedureCommand command = new StoredProcedureCommand(){

            public Object processRow(ResultSet resultSet) throws SQLException {
                return resultSet.getString(1);
            }

            public SelectionObject getSelectionObject() {
                return new ProcedureCIUSPDPG().getSelectionObject(executionType, region.getName(), PurgeRunnable.this.data.getProgram().getName(), table);
            }
        };
        command.setCategory("com.ibm.cics.ia.connection.db2");
        command.setAsync(false);
        command.start();
        if (command.status() != 1 && command.status() != 3 && command.status() == 2) {
            MessageDialog.open((int)1, null, (String)"Error", (String)Messages.getString("PurgeWizard.procedureExecuteError.message"), (int)1);
            Debug.exit((Logger)logger, (String)PurgeRunnable.class.getName(), (String)"storedProcedureExecute", (Object)"SQL error");
            return;
        }
        Debug.exit((Logger)logger, (String)PurgeRunnable.class.getName(), (String)"storedProcedureExecute");
    }
}

