/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.StoredProcedureCommand;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.ia.commands.GetIdenticalProgramFlowsCommand;
import com.ibm.cics.ia.commands.GetProgramFlowCommand;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.model.Messages;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.ProgramFlowsModel;
import com.ibm.cics.ia.model.ProgramFlowsModelListener;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.model.TreeNode;
import com.ibm.cics.ia.storedproc.ProcedureCIUSPTF1;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class ProgramFlowsModelImpl
implements ProgramFlowsModel {
    private static ProgramFlowsModelImpl instance;
    private List<ProgramFlowsModelListener> listeners;
    private String cmdFlowId;
    private String regionName;
    private String transactionName;
    private Transaction transaction;
    private List<Object[]> programFlows = new ArrayList<Object[]>();
    private static final Logger logger;
    protected static final String SOURCE_FUNCTION_START_OF_TRANSACTION = "S";
    protected static final String NODE_TYPE_PROGRAM = "P";
    protected static final String SOURCE_FUNCTION_LINK = "L";

    static {
        logger = Logger.getLogger(ProgramFlowsModelImpl.class.getPackage().getName());
    }

    private ProgramFlowsModelImpl() {
        this.listeners = new ArrayList<ProgramFlowsModelListener>();
    }

    public static ProgramFlowsModelImpl getInstance() {
        if (instance == null) {
            instance = new ProgramFlowsModelImpl();
        }
        return instance;
    }

    @Override
    public void addListener(ProgramFlowsModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ProgramFlowsModelListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Transaction getTransaction() {
        return this.transaction;
    }

    @Override
    public Job runSearch() {
        final String taskName = Messages.getString("ProgramFlowsModelImpl.getProgramFlows");
        Job job = new Job(taskName){

            protected IStatus run(IProgressMonitor monitor) {
                Debug.enter((Logger)logger, (String)"ProgramFlowsModelImpl.runSearch().ProgressMonitorDialog", (String)"run", (Object)("Thread ID: " + Thread.currentThread().getId()));
                monitor.beginTask(taskName, -1);
                StoredProcedureCommand command = new StoredProcedureCommand(){
                    private SelectionObject selectionObject;

                    public Object processRow(ResultSet rs) throws SQLException {
                        return null;
                    }

                    public SelectionObject getSelectionObject() {
                        return this.selectionObject == null ? (this.selectionObject = new ProcedureCIUSPTF1().getSelectionObject(ProgramFlowsModelImpl.this.cmdFlowId, ProgramFlowsModelImpl.this.regionName, ProgramFlowsModelImpl.this.transactionName)) : this.selectionObject;
                    }
                };
                command.setCategory("com.ibm.cics.ia.connection.db2");
                command.setAsync(false);
                command.start();
                ProgramFlowsModelImpl.this.programFlows = new ArrayList();
                List treeInfos = IASQLCommand.runCommandSynch(new GetIdenticalProgramFlowsCommand());
                HashMap<Integer, Integer[]> treeGroupId2CountAndRootTaskId = new HashMap<Integer, Integer[]>();
                for (Object e : treeInfos) {
                    Object[] treeInfo = (Object[])e;
                    treeGroupId2CountAndRootTaskId.put((Integer)treeInfo[0], new Integer[]{(Integer)treeInfo[1], (Integer)treeInfo[2]});
                }
                for (Map.Entry entry : treeGroupId2CountAndRootTaskId.entrySet()) {
                    Integer treeId = (Integer)entry.getKey();
                    Integer identicalTrees = ((Integer[])entry.getValue())[0];
                    Integer rootTaskId = ((Integer[])entry.getValue())[1];
                    List programFlowNodeInfos = IASQLCommand.runCommandSynch(new GetProgramFlowCommand(rootTaskId));
                    HashMap<Integer, TreeNode> id2Node = new HashMap<Integer, TreeNode>();
                    for (Object e : programFlowNodeInfos) {
                        TreeNode parent;
                        Object[] programFlowNodeInfo = (Object[])e;
                        TreeNode<Resource> node = null;
                        if (ProgramFlowsModelImpl.NODE_TYPE_PROGRAM.equals(programFlowNodeInfo[3])) {
                            node = new TreeNode<Program>(new Program(((String)programFlowNodeInfo[2]).trim()));
                            id2Node.put((Integer)programFlowNodeInfo[0], node);
                        } else if (ProgramFlowsModelImpl.SOURCE_FUNCTION_START_OF_TRANSACTION.equals(programFlowNodeInfo[4])) {
                            node = new TreeNode<Transaction>(new Transaction(((String)programFlowNodeInfo[2]).trim()));
                            id2Node.put((Integer)programFlowNodeInfo[0], node);
                        } else if (ProgramFlowsModelImpl.SOURCE_FUNCTION_LINK.equals(programFlowNodeInfo[4])) {
                            node = new TreeNode();
                            id2Node.put((Integer)programFlowNodeInfo[0], node);
                        }
                        Integer parentId = (Integer)programFlowNodeInfo[1];
                        if (parentId == null) {
                            ProgramFlowsModelImpl.this.programFlows.add(new Object[]{node, identicalTrees});
                            continue;
                        }
                        if (node == null || (parent = (TreeNode)id2Node.get(parentId)) == null) continue;
                        if (parent.getData() != null) {
                            parent.addChild(node);
                            node.setParent(parent);
                            continue;
                        }
                        parent.setData(node.getData());
                        id2Node.put((Integer)programFlowNodeInfo[0], parent);
                    }
                    for (Map.Entry entry2 : id2Node.entrySet()) {
                        TreeNode treeNode = (TreeNode)entry2.getValue();
                        if (treeNode.getData() != null) continue;
                        treeNode.getParent().removeChild(treeNode);
                    }
                    ProgramFlowsModelImpl.this.programFlows.sort(new Comparator<Object[]>(){

                        @Override
                        public int compare(Object[] o1, Object[] o2) {
                            if ((Integer)o1[1] < (Integer)o2[1]) {
                                return 1;
                            }
                            if ((Integer)o1[1] == (Integer)o2[1]) {
                                return 0;
                            }
                            return -1;
                        }
                    });
                }
                Debug.exit((Logger)logger, (String)"ProgramFlowsModelImpl.runSearch().ProgressMonitorDialog", (String)"run");
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    for (ProgramFlowsModelListener listener : ProgramFlowsModelImpl.this.listeners) {
                        listener.onProgramFlowsAvailable();
                    }
                }
            }
        });
        job.schedule();
        return job;
    }

    @Override
    public List<Object[]> getProgramFlows() {
        return this.programFlows;
    }

    @Override
    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    @Override
    public void setCmdFlowId(String cmdFlowId) {
        this.cmdFlowId = cmdFlowId;
    }

    @Override
    public void setTransactionName(String transactionName) {
        this.transactionName = transactionName;
    }

    @Override
    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
        this.transactionName = transaction.getName();
    }
}

