/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.dbfunc.command.SQLCommand;
import com.ibm.cics.ia.commands.FindCSectsOfProgramCommand;
import com.ibm.cics.ia.commands.FindScanSummaryCommand;
import com.ibm.cics.ia.commands.FrontTransactionsForProgramCommand;
import com.ibm.cics.ia.commands.IASQLCommand;
import com.ibm.cics.ia.commands.PlatformsForResourceCommand;
import com.ibm.cics.ia.commands.PropertiesCommand;
import com.ibm.cics.ia.commands.RegionsForProgramCommand;
import com.ibm.cics.ia.commands.SourceInteractionsForResourceCommand;
import com.ibm.cics.ia.commands.SourceProgramInteractionsForResourceCommand;
import com.ibm.cics.ia.commands.SourceTransactionInteractionsForProgramCommand;
import com.ibm.cics.ia.commands.SourceTransactionInteractionsForResourceCommand;
import com.ibm.cics.ia.commands.TargetCICSInteractionsForProgramCommand;
import com.ibm.cics.ia.commands.TargetDB2InteractionsForProgramCommand;
import com.ibm.cics.ia.commands.TargetIMSInteractionsForProgramCommand;
import com.ibm.cics.ia.commands.TargetMQInteractionsForProgramCommand;
import com.ibm.cics.ia.model.Interaction;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.runtime.IAPlugin;
import com.ibm.cics.ia.runtime.IAUtilities;
import com.ibm.cics.ia.runtime.Version;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class Program
extends Resource {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(Program.class.getPackage().getName());
    private static final long serialVersionUID = -7752328353154229301L;
    public static final String ACCESS = "ACCESS";
    public static final String APIST = "APIST";
    public static final String APPLID = "APPLID";
    public static final String CONCURRENCY = "CONCURRENCY";
    public static final String DATA_LOCATION = "DATA_LOCATION";
    public static final String DYNAMIC_STATUS = "DYNAMIC_STATUS";
    public static final String EXECUTION_KEY = "EXECUTION_KEY";
    public static final String EXECUTION_SET = "EXECUTION_SET";
    public static final String FIRST_RUN = "FIRST_RUN";
    public static final String HOLD_STATUS = "HOLD_STATUS";
    public static final String HOMESYSID = "HOMESYSID";
    public static final String INSTALL_TYPE = "INSTALL_TYPE";
    public static final String LANGUAGE_DEDUCED = "LANGUAGE_DEDUCED";
    public static final String LANGUAGE_DEFINED = "LANGUAGE_DEFINED";
    public static final String LAST_RUN = "LAST_RUN";
    public static final String LIB_DATASET_NAME = "LIB_DATASET_NAME";
    public static final String LIB_NAME = "LIB_NAME";
    public static final String LOAD_STATUS = "LOAD_STATUS";
    public static final String LOCATION = "LOCATION";
    public static final String MODULE_TYPE = "MODULE_TYPE";
    public static final String PROGRAM_ATTRIBUTE = "PROGRAM_ATTRIBUTE";
    public static final String PROGRAM_LENGTH = "PROGRAM_LENGTH";
    public static final String PROGRAM_TYPE = "PROGRAM_TYPE";
    public static final String PROGRAM_USAGE = "PROGRAM_USAGE";
    public static final String REMOTE_DEFINITION = "REMOTE_DEFINITION";
    public static final String REMOTE_PROGID = "REMOTE_PROGID";
    public static final String REMOTE_SYSID = "REMOTE_SYSID";
    public static final String REMOTE_TRANID = "REMOTE_TRANID";
    public static final String SPECIFIED_AMODE = "SPECIFIED_AMODE";
    public static final String SPECIFIED_RMODE = "SPECIFIED_RMODE";
    public static String COLLECTION_ID = "COLLECTION_ID";
    private List targetInteractions;
    private Map<Transaction, List> targetInteractionsForTransaction;
    private List frontTransactions;
    private List properties;
    private List summaryProperties;
    private List sourceProgramInteractions;
    private List sourceTransactionInteractions;
    private static final String[] ia31propertyIDs = new String[]{"ACCESS", "APIST", "APPLID", "CONCURRENCY", "DATA_LOCATION", "DYNAMIC_STATUS", "EXECUTION_KEY", "EXECUTION_SET", "FIRST_RUN", "HOLD_STATUS", "HOMESYSID", "INSTALL_TYPE", "LANGUAGE_DEDUCED", "LANGUAGE_DEFINED", "LAST_RUN", "LIB_DATASET_NAME", "LIB_NAME", "LOAD_STATUS", "LOCATION", "MODULE_TYPE", "PROGRAM_ATTRIBUTE", "PROGRAM_LENGTH", "PROGRAM_TYPE", "PROGRAM_USAGE", "REMOTE_DEFINITION", "REMOTE_PROGID", "REMOTE_SYSID", "REMOTE_TRANID", "SPECIFIED_AMODE", "SPECIFIED_RMODE"};
    private static final String[] ia32propertyIDs = IAUtilities.concat(new String[]{COLLECTION_ID}, new String[][]{ia31propertyIDs});
    private static final String[] ia51propertyIDs = IAUtilities.concat(new String[]{"APPL_NAME", "APPL_OPER", "APPL_VER1", "APPL_VER2", "APPL_VER3"}, new String[][]{ia32propertyIDs});
    private static final String[] ia52propertyIDs = IAUtilities.concat(new String[]{"PLATFORM"}, new String[][]{ia51propertyIDs});

    public Program(String resourceName) {
        super("PROGRAM", resourceName);
        if (resourceName.equals("MWARCCIC")) {
            resourceName.toString();
        }
    }

    @Override
    public Command createGetRegionsCommand() {
        return new RegionsForProgramCommand(this);
    }

    @Override
    public Command createGetPlatformsCommand() {
        return new PlatformsForResourceCommand(this);
    }

    public List getFrontTransaction(Region aRegion) {
        return IASQLCommand.runCommandSynch(new FrontTransactionsForProgramCommand(this, aRegion));
    }

    public List getFrontTransactions() {
        if (this.frontTransactions == null) {
            this.frontTransactions = IASQLCommand.runCommandSynch(new FrontTransactionsForProgramCommand(this, null));
        }
        return this.frontTransactions;
    }

    public synchronized List getTargetInteractions(Transaction aTransaction) {
        ArrayList interactionsForTransaction;
        Debug.enter((Logger)logger, (String)Program.class.getName(), (String)"getTargetInteractions", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.targetInteractionsForTransaction == null) {
            this.targetInteractionsForTransaction = new HashMap<Transaction, List>();
        }
        if ((interactionsForTransaction = this.targetInteractionsForTransaction.get(aTransaction)) != null) {
            Debug.exit((Logger)logger, (String)Program.class.getName(), (String)"getTargetInteractions", (Object)("interactionsForTransaction.size(): " + interactionsForTransaction.size()));
            return interactionsForTransaction;
        }
        interactionsForTransaction = new ArrayList();
        IASQLCommand command = new TargetCICSInteractionsForProgramCommand(this, aTransaction);
        if (!this.executeAndSaveResults(interactionsForTransaction, command)) {
            Debug.exit((Logger)logger, (String)Program.class.getName(), (String)"getTargetInteractions", (Object)"return null");
            return null;
        }
        if (IAPlugin.getDefault().getPluginPreferences().getBoolean("DB2_DATA") && !this.executeAndSaveResults(interactionsForTransaction, command = new TargetDB2InteractionsForProgramCommand(this, aTransaction))) {
            Debug.exit((Logger)logger, (String)Program.class.getName(), (String)"getTargetInteractions", (Object)"return null");
            return null;
        }
        if (IAPlugin.getDefault().getPluginPreferences().getBoolean("IMS_DATA") && !this.executeAndSaveResults(interactionsForTransaction, command = new TargetIMSInteractionsForProgramCommand(this, aTransaction))) {
            Debug.exit((Logger)logger, (String)Program.class.getName(), (String)"getTargetInteractions", (Object)"return null");
            return null;
        }
        if (IAPlugin.getDefault().getPluginPreferences().getBoolean("MQ_DATA") && !this.executeAndSaveResults(interactionsForTransaction, command = new TargetMQInteractionsForProgramCommand(this, aTransaction))) {
            Debug.exit((Logger)logger, (String)Program.class.getName(), (String)"getTargetInteractions", (Object)"return null");
            return null;
        }
        this.targetInteractionsForTransaction.put(aTransaction, interactionsForTransaction);
        Debug.exit((Logger)logger, (String)Program.class.getName(), (String)"getTargetInteractions", (Object)("interactionsForTransaction.size(): " + interactionsForTransaction.size()));
        return interactionsForTransaction;
    }

    private boolean executeAndSaveResults(List interactionsForTransaction, SQLCommand command) {
        Debug.enter((Logger)logger, (String)Program.class.getName(), (String)"executeAndSaveResults", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "interactionsForTransaction size: " + interactionsForTransaction.size(), "command: " + command.getSQLString()});
        command.setAsync(false);
        command.start();
        while (command.status() == 3) {
            command.start();
        }
        if (command.status() == 2) {
            Debug.exit((Logger)logger, (String)Program.class.getName(), (String)"executeAndSaveResults", (Object)"return false");
            return false;
        }
        interactionsForTransaction.addAll(command.getResults());
        Debug.exit((Logger)logger, (String)Program.class.getName(), (String)"executeAndSaveResults", (Object)"return true");
        return true;
    }

    public synchronized List getTargetInteractions() {
        Debug.enter((Logger)logger, (String)Program.class.getName(), (String)"getTargetInteractions", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.targetInteractions == null) {
            this.targetInteractions = new ArrayList();
            this.runCommand(new TargetCICSInteractionsForProgramCommand(this));
            if (IAPlugin.getDefault().getPluginPreferences().getBoolean("DB2_DATA")) {
                this.runCommand(new TargetDB2InteractionsForProgramCommand(this));
            }
            if (IAPlugin.getDefault().getPluginPreferences().getBoolean("IMS_DATA")) {
                this.runCommand(new TargetIMSInteractionsForProgramCommand(this));
            }
            if (IAPlugin.getDefault().getPluginPreferences().getBoolean("MQ_DATA")) {
                this.runCommand(new TargetMQInteractionsForProgramCommand(this));
            }
        }
        Debug.exit((Logger)logger, (String)Program.class.getName(), (String)"getTargetInteractions", (Object)("targetInteractions size: " + this.targetInteractions.size()));
        return this.targetInteractions;
    }

    private void runCommand(SQLCommand command) {
        Debug.enter((Logger)logger, (String)Program.class.getName(), (String)"runCommand", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "command: " + command.getSQLString()});
        command.setAsync(false);
        command.start();
        while (command.status() == 3) {
            command.start();
        }
        this.targetInteractions.addAll(command.getResults());
        Debug.exit((Logger)logger, (String)Program.class.getName(), (String)"runCommand");
    }

    public List getTargetsForVerbAndTypeAndTransaction(String verbName, String resourceType, Region aRegion, Transaction aTransaction) {
        Map types;
        Debug.enter((Logger)logger, (String)Program.class.getName(), (String)"getTargetsForVerbAndTypeAndTransaction", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "verbName: " + verbName, "resourceType: " + resourceType, "aRegion: " + (aRegion == null ? aRegion : aRegion.getName()), "aTransaction: " + (aTransaction == null ? aTransaction : aTransaction.getName())});
        Map verbsAndTypes = this.getTargetsForVerbAndTransaction(verbName, aRegion, aTransaction);
        if (verbsAndTypes != null && (types = (Map)verbsAndTypes.get(verbName)) != null && types.get(resourceType) != null) {
            Debug.exit((Logger)logger, (String)Program.class.getName(), (String)"getTargetsForVerbAndTypeAndTransaction", (Object)("list size: " + ((List)types.get(resourceType)).size()));
            return (List)types.get(resourceType);
        }
        Debug.exit((Logger)logger, (String)Program.class.getName(), (String)"getTargetsForVerbAndTypeAndTransaction", (Object)"return EMPTY_LIST ");
        return Collections.EMPTY_LIST;
    }

    public List getTargetsForVerbAndType(String verbName, String resourceType, Region aRegion) {
        Map types;
        Debug.enter((Logger)logger, (String)Program.class.getName(), (String)"getTargetsForVerbAndType", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "verbName: " + verbName, "resourceType: " + resourceType, "aRegion: " + (aRegion == null ? aRegion : aRegion.getName())});
        Map verbsAndTypes = this.getTargetsForVerb(verbName, aRegion);
        if (verbsAndTypes != null && (types = (Map)verbsAndTypes.get(verbName)) != null && types.get(resourceType) != null) {
            Debug.exit((Logger)logger, (String)Program.class.getName(), (String)"getTargetsForVerbAndType", (Object)("list size: " + ((List)types.get(resourceType)).size()));
            return (List)types.get(resourceType);
        }
        Debug.exit((Logger)logger, (String)Program.class.getName(), (String)"getTargetsForVerbsAndType", (Object)"return EMPTY_LIST");
        return Collections.EMPTY_LIST;
    }

    public List getTargetsForVerbsAndType(String[] verbs, String resourceType, Region aRegion) {
        Debug.enter((Logger)logger, (String)Program.class.getName(), (String)"getTargetsForVerbsAndType", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "verbs length: " + verbs.length, "resourceType: " + resourceType, "aRegion: " + (aRegion == null ? aRegion : aRegion.getName())});
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < verbs.length) {
            result.addAll(this.getTargetsForVerbAndType(verbs[i], resourceType, aRegion));
            ++i;
        }
        Debug.exit((Logger)logger, (String)Program.class.getName(), (String)"getTargetsForVerbsAndType", (Object)("result size(): " + result.size()));
        return result;
    }

    public Map getTargetsForVerbAndTransaction(String verbName, Region aRegion, Transaction aTransaction) {
        Debug.enter((Logger)logger, (String)Program.class.getName(), (String)"getTargetsForVerbAndTransaction", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "verbName: " + verbName, "aRegion: " + (aRegion == null ? aRegion : aRegion.getName()), "aTransaction: " + (aTransaction == null ? aTransaction : aTransaction.getName())});
        List targetInteractionsForTransaction = this.getTargetInteractions(aTransaction);
        if (targetInteractionsForTransaction == null) {
            Debug.exit((Logger)logger, (String)Program.class.getName(), (String)"getTargetsForVerbAndTransaction", (Object)"return null");
            return null;
        }
        if (aRegion != null) {
            List filteredInteractions = Interaction.filterByRegion(targetInteractionsForTransaction, aRegion);
            Debug.exit((Logger)logger, (String)Program.class.getName(), (String)"getTargetsForVerbAndTransaction", (Object)("result size: " + Interaction.getTypesAndTargetsByVerb(filteredInteractions).size()));
            return Interaction.getTypesAndTargetsByVerb(filteredInteractions);
        }
        Debug.exit((Logger)logger, (String)Program.class.getName(), (String)"getTargetsForVerbAndTransaction", (Object)("result size: " + Interaction.getTypesAndTargetsByVerb(targetInteractionsForTransaction).size()));
        return Interaction.getTypesAndTargetsByVerb(targetInteractionsForTransaction);
    }

    public Map<Transaction, List> getTargetInteractionsForTransaction() {
        Debug.enter((Logger)logger, (String)Program.class.getName(), (String)"getTargetInteractionsForTransaction", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.targetInteractionsForTransaction == null) {
            this.targetInteractionsForTransaction = new HashMap<Transaction, List>();
        }
        Debug.exit((Logger)logger, (String)Program.class.getName(), (String)"getTargetInteractionsForTransaction", (Object)("result size: " + this.targetInteractionsForTransaction.size()));
        return this.targetInteractionsForTransaction;
    }

    public Map getTargetsForVerb(String verbName, Region aRegion) {
        Debug.enter((Logger)logger, (String)Program.class.getName(), (String)"getTargetsForVerb", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "verbName: " + verbName, "aRegion: " + (aRegion == null ? aRegion : aRegion)});
        List targetInteractions = this.getTargetInteractions();
        if (targetInteractions == null) {
            Debug.exit((Logger)logger, (String)Program.class.getName(), (String)"getTargetsForVerb", (Object)"return null");
            return null;
        }
        if (aRegion != null) {
            List filteredInteractions = Interaction.filterByRegion(targetInteractions, aRegion);
            Debug.exit((Logger)logger, (String)Program.class.getName(), (String)"getTargetsForVerb", (Object)("result size: " + Interaction.getTypesAndTargetsByVerb(filteredInteractions).size()));
            return Interaction.getTypesAndTargetsByVerb(filteredInteractions);
        }
        Debug.exit((Logger)logger, (String)Program.class.getName(), (String)"getTargetsForVerb", (Object)("result size: " + Interaction.getTypesAndTargetsByVerb(targetInteractions).size()));
        return Interaction.getTypesAndTargetsByVerb(targetInteractions);
    }

    @Override
    public String getTypeName() {
        return "PROGRAM";
    }

    @Override
    public synchronized List getSourceInteractions() {
        Debug.enter((Logger)logger, (String)Program.class.getName(), (String)"getSourceInteractions", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.sourceInteractions == null) {
            SourceInteractionsForResourceCommand command = new SourceInteractionsForResourceCommand(this);
            command.setAsync(false);
            command.start();
            while (command.status() == 3) {
                command.start();
            }
            this.sourceInteractions = command.getResults();
        }
        Debug.exit((Logger)logger, (String)Program.class.getName(), (String)"getSourceInteractions", (Object)("result size: " + this.sourceInteractions.size()));
        return this.sourceInteractions;
    }

    @Override
    public void clearTargetInteractions() {
        super.clearTargetInteractions();
        this.targetInteractions = null;
        this.targetInteractionsForTransaction = null;
    }

    @Override
    public List getProperties() {
        this.properties = IASQLCommand.runCommandSynch(new PropertiesCommand(this));
        return this.properties;
    }

    public List getSummaryProperties() {
        Debug.enter((Logger)logger, (String)Program.class.getName(), (String)"getSummaryProperties", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (!IAUtilities.hasContent(this.getName())) {
            return new ArrayList();
        }
        if (this.summaryProperties == null) {
            FindScanSummaryCommand command = new FindScanSummaryCommand();
            command.setProgramName(this.getName());
            this.summaryProperties = IASQLCommand.runCommandSynch(command);
        }
        Debug.exit((Logger)logger, (String)Program.class.getName(), (String)"getSummaryProperties", (Object)("result size: " + this.summaryProperties.size()));
        return this.summaryProperties;
    }

    public List<Map<String, String>> getCsectProperties() {
        Debug.enter((Logger)logger, (String)Program.class.getName(), (String)"getCsectProperties", (Object)("Thread ID: " + Thread.currentThread().getId()));
        FindCSectsOfProgramCommand command = new FindCSectsOfProgramCommand(this);
        Debug.exit((Logger)logger, (String)Program.class.getName(), (String)"getCsectProperties", (Object)("result size: " + IASQLCommand.runCommandSynch(command).size()));
        return IASQLCommand.runCommandSynch(command);
    }

    @Override
    public List getSourceProgramInteractions() {
        Debug.enter((Logger)logger, (String)Program.class.getName(), (String)"getSourceProgramInteractions", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.sourceProgramInteractions == null) {
            SourceProgramInteractionsForResourceCommand command = new SourceProgramInteractionsForResourceCommand(this);
            command.start();
            while (command.status() == 3) {
                command.start();
            }
            if (command.status() != 2) {
                this.sourceProgramInteractions = command.getResults();
            }
        }
        Debug.exit((Logger)logger, (String)Program.class.getName(), (String)"getSourceProgramInteractions", (Object)("result size: " + this.sourceProgramInteractions.size()));
        return this.sourceProgramInteractions;
    }

    @Override
    public synchronized List getSourceTransactionInteractions() {
        Debug.enter((Logger)logger, (String)Program.class.getName(), (String)"getSourceTransactionInteractions", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (this.sourceTransactionInteractions == null) {
            SourceTransactionInteractionsForResourceCommand command = new SourceTransactionInteractionsForResourceCommand(this);
            command.start();
            while (command.status() == 3) {
                command.start();
            }
            if (command.status() == 2) {
                Debug.exit((Logger)logger, (String)Program.class.getName(), (String)"getSourceTransactionInteractions", (Object)("result size: " + this.sourceTransactionInteractions.size()));
                return this.sourceTransactionInteractions;
            }
            this.sourceTransactionInteractions = command.getResults();
            SourceTransactionInteractionsForProgramCommand command2 = new SourceTransactionInteractionsForProgramCommand(this);
            command2.start();
            while (command2.status() == 3) {
                command2.start();
            }
            if (command2.status() == 2) {
                this.sourceTransactionInteractions = null;
                Debug.exit((Logger)logger, (String)Program.class.getName(), (String)"getSourceTransactionInteractions", (Object)("result size: " + this.sourceTransactionInteractions.size()));
                return this.sourceTransactionInteractions;
            }
            this.sourceTransactionInteractions.addAll(command2.getResults());
        }
        Debug.exit((Logger)logger, (String)Program.class.getName(), (String)"getSourceTransactionInteractions", (Object)("result size: " + this.sourceTransactionInteractions.size()));
        return this.sourceTransactionInteractions;
    }

    public static String[] getPropertyIDs() {
        int version = Version.getInstance().getDBVersion();
        switch (version) {
            case 3100: {
                return ia31propertyIDs;
            }
            case 3200: {
                return ia32propertyIDs;
            }
            case 5100: 
            case 5110: {
                return ia51propertyIDs;
            }
            case 5200: 
            case 5300: 
            case 5500: 
            case 6100: {
                return ia52propertyIDs;
            }
        }
        return ia31propertyIDs;
    }
}

