/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.RegionAndResource;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.Verb;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class Interaction
extends RegionAndResource {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(Interaction.class.getPackage().getName());
    private static final long serialVersionUID = 8940709917530179268L;
    private final Region sourceRegion;
    private final Resource source;
    private final String verb;
    private final String remoteSysid;
    private final String remoteName;

    public Interaction(Region sourceRegion, Resource source, String verb, Resource target, Region targetRegion) {
        super(targetRegion == null ? sourceRegion : targetRegion, target);
        this.source = source;
        this.verb = verb;
        this.remoteName = null;
        this.remoteSysid = null;
        this.sourceRegion = sourceRegion;
    }

    public Interaction(Region sourceRegion, Resource source, String verb, Resource target, Region targetRegion, String remoteSysid, String remoteName) {
        super(targetRegion == null ? sourceRegion : targetRegion, target);
        this.source = source;
        this.verb = verb;
        this.sourceRegion = sourceRegion;
        this.remoteSysid = remoteSysid;
        this.remoteName = remoteName;
    }

    @Override
    public String getAsTitleCopyString() {
        return "Region,Resource,Function,Object";
    }

    @Override
    public String getAsCopyString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.sourceRegion.getName());
        buffer.append(',');
        buffer.append(this.source.getName());
        buffer.append(',');
        buffer.append(this.verb);
        buffer.append(',');
        buffer.append(this.resource.getName());
        return buffer.toString();
    }

    public String toString() {
        return "Interaction(" + this.sourceRegion.getName() + ":" + this.source.toString() + ";" + this.verb + ";" + this.region.getName() + ":" + this.resource.toString() + ")";
    }

    public static Map getTargetsAndVerbsByType(Collection interactions) {
        Debug.enter((Logger)logger, (String)Interaction.class.getName(), (String)"getTargetsAndVerbsByType", (Object)("Thread ID: " + Thread.currentThread().getId()));
        HashMap types = new HashMap();
        Iterator iter = interactions.iterator();
        while (iter.hasNext()) {
            Interaction.processInteraction((Interaction)iter.next(), types);
        }
        Debug.exit((Logger)logger, (String)Interaction.class.getName(), (String)"getTargetsAndVerbsByType");
        return types;
    }

    public static Map getSourcesAndVerbsByType(Collection interactions) {
        Debug.enter((Logger)logger, (String)Interaction.class.getName(), (String)"getSourcesAndVerbsByType", (Object)("Thread ID: " + Thread.currentThread().getId()));
        HashMap types = new HashMap();
        for (Interaction interaction : interactions) {
            ArrayList<String> verbsForSource;
            HashMap<Resource, ArrayList<String>> sourcesAndVerbs = (HashMap<Resource, ArrayList<String>>)types.get(interaction.getSource().getTypeName());
            if (sourcesAndVerbs == null) {
                sourcesAndVerbs = new HashMap<Resource, ArrayList<String>>();
                types.put(interaction.getSource().getTypeName(), sourcesAndVerbs);
            }
            if ((verbsForSource = (ArrayList<String>)sourcesAndVerbs.get(interaction.getSource())) == null) {
                verbsForSource = new ArrayList<String>();
                verbsForSource.add(interaction.getVerb());
                sourcesAndVerbs.put(interaction.getSource(), verbsForSource);
                continue;
            }
            verbsForSource.add(interaction.getVerb());
        }
        Debug.exit((Logger)logger, (String)Interaction.class.getName(), (String)"getSourcesAndVerbsByType");
        return types;
    }

    public static Map getTargetsAndVerbsAndSourcesByType(Collection interactions) {
        Debug.enter((Logger)logger, (String)Interaction.class.getName(), (String)"getTargetsAndVerbsAndSourcesByType", (Object)("Thread ID: " + Thread.currentThread().getId()));
        HashMap types = new HashMap();
        for (Interaction interaction : interactions) {
            Verb verb = new Verb(interaction.getSource(), interaction.getVerb(), interaction.getResource(), interaction.getRemoteSysid(), interaction.getRemoteName());
            HashMap targetsAndVerbs = (HashMap)types.get(interaction.getResource().getTypeName());
            if (targetsAndVerbs == null) {
                targetsAndVerbs = new HashMap();
                types.put(interaction.getResource().getTypeName(), targetsAndVerbs);
            }
            HashMap verbsForTarget = (HashMap)targetsAndVerbs.get(interaction.getResource());
            ArrayList<Resource> sources = null;
            if (verbsForTarget == null) {
                verbsForTarget = new HashMap();
                sources = new ArrayList<Resource>();
                sources.add(interaction.getSource());
                verbsForTarget.put(verb, sources);
                targetsAndVerbs.put(interaction.getResource(), verbsForTarget);
                continue;
            }
            sources = (ArrayList<Resource>)verbsForTarget.get(verb);
            if (sources == null) {
                sources = new ArrayList();
                sources.add(interaction.getSource());
                verbsForTarget.put(verb, sources);
                continue;
            }
            if (sources.contains(interaction.getSource())) continue;
            sources.add(interaction.getSource());
        }
        Debug.exit((Logger)logger, (String)Interaction.class.getName(), (String)"getTargetsAndVerbsAndSourcesByType");
        return types;
    }

    public static Map getTypesAndTargetsByVerb(Collection interactions) {
        Debug.enter((Logger)logger, (String)Interaction.class.getName(), (String)"getTypesAndTargetsByVerb", (Object)("Thread ID: " + Thread.currentThread().getId()));
        HashMap verbs = new HashMap();
        for (Interaction interaction : interactions) {
            ArrayList<Resource> types;
            HashMap typesAndTargets = (HashMap)verbs.get(interaction.getVerb());
            if (typesAndTargets == null) {
                typesAndTargets = new HashMap();
                verbs.put(interaction.getVerb(), typesAndTargets);
            }
            if ((types = (ArrayList<Resource>)typesAndTargets.get(interaction.getResource().getTypeName())) == null) {
                types = new ArrayList<Resource>();
                types.add(interaction.getResource());
                typesAndTargets.put(interaction.getResource().getTypeName(), types);
                continue;
            }
            if (types.contains(interaction.getResource())) continue;
            types.add(interaction.getResource());
        }
        Debug.exit((Logger)logger, (String)Interaction.class.getName(), (String)"getTypesAndTargetsByVerb");
        return verbs;
    }

    public static Map getTypesAndTargetsAndSourcesByVerb(Collection interactions) {
        Debug.enter((Logger)logger, (String)Interaction.class.getName(), (String)"getTypesAndTargetsAndSourcesByVerb", (Object)("Thread ID: " + Thread.currentThread().getId()));
        HashMap verbs = new HashMap();
        for (Interaction interaction : interactions) {
            HashMap typesAndTargets = (HashMap)verbs.get(interaction.getVerb());
            if (typesAndTargets == null) {
                typesAndTargets = new HashMap();
                verbs.put(interaction.getVerb(), typesAndTargets);
            }
            HashMap typesAndSources = (HashMap)typesAndTargets.get(interaction.getResource().getTypeName());
            ArrayList<Resource> sources = null;
            if (typesAndSources == null) {
                typesAndSources = new HashMap();
                sources = new ArrayList<Resource>();
                sources.add(interaction.getSource());
                typesAndSources.put(interaction.getResource(), sources);
                typesAndTargets.put(interaction.getResource().getTypeName(), typesAndSources);
                continue;
            }
            sources = (ArrayList<Resource>)typesAndSources.get(interaction.getResource());
            if (sources.contains(interaction.getSource())) continue;
            sources.add(interaction.getSource());
        }
        Debug.exit((Logger)logger, (String)Interaction.class.getName(), (String)"getTypesAndTargetsAndSourcesByVerb");
        return verbs;
    }

    public static Map getVerbsAndTargetsByType(Collection interactions) {
        Debug.enter((Logger)logger, (String)Interaction.class.getName(), (String)"getVerbsAndTargetsByType", (Object)("Thread ID: " + Thread.currentThread().getId()));
        HashMap types = new HashMap();
        for (Interaction interaction : interactions) {
            ArrayList<Resource> verbsForTarget;
            HashMap<String, ArrayList<Resource>> verbsAndTargets = (HashMap<String, ArrayList<Resource>>)types.get(interaction.getResource().getTypeName());
            if (verbsAndTargets == null) {
                verbsAndTargets = new HashMap<String, ArrayList<Resource>>();
                types.put(interaction.getResource().getTypeName(), verbsAndTargets);
            }
            if ((verbsForTarget = (ArrayList<Resource>)verbsAndTargets.get(interaction.getVerb())) == null) {
                verbsForTarget = new ArrayList<Resource>();
                verbsForTarget.add(interaction.getResource());
                verbsAndTargets.put(interaction.getVerb(), verbsForTarget);
                continue;
            }
            verbsForTarget.add(interaction.getResource());
        }
        Debug.exit((Logger)logger, (String)Interaction.class.getName(), (String)"getVerbsAndTargetsByType");
        return types;
    }

    public static Map getVerbsAndTargetsAndSourcesByType(Collection interactions) {
        Debug.enter((Logger)logger, (String)Interaction.class.getName(), (String)"getVerbsAndTargetsAndSourcesByType", (Object)("Thread ID: " + Thread.currentThread().getId()));
        HashMap types = new HashMap();
        for (Interaction interaction : interactions) {
            Verb verb = new Verb(interaction.getSource(), interaction.getVerb(), interaction.getResource(), interaction.getRemoteSysid(), interaction.getRemoteName());
            HashMap verbsAndTargets = (HashMap)types.get(interaction.getResource().getTypeName());
            if (verbsAndTargets == null) {
                verbsAndTargets = new HashMap();
                types.put(interaction.getResource().getTypeName(), verbsAndTargets);
            }
            ArrayList<Resource> sources = null;
            HashMap targetsAndSources = (HashMap)verbsAndTargets.get(verb);
            if (targetsAndSources == null) {
                targetsAndSources = new HashMap();
                verbsAndTargets.put(verb, targetsAndSources);
                sources = new ArrayList();
                sources.add(interaction.getSource());
                targetsAndSources.put(interaction.getResource(), sources);
                continue;
            }
            sources = (ArrayList<Resource>)targetsAndSources.get(interaction.getResource());
            if (sources == null) {
                sources = new ArrayList<Resource>();
                sources.add(interaction.getSource());
                targetsAndSources.put(interaction.getResource(), sources);
                continue;
            }
            if (sources.contains(interaction.getSource())) continue;
            sources.add(interaction.getSource());
        }
        Debug.exit((Logger)logger, (String)Interaction.class.getName(), (String)"getVerbsAndTargetsAndSourcesByType");
        return types;
    }

    public static Map getTargetsAndVerbsByTypeAndRegion(Collection interactions) {
        Debug.enter((Logger)logger, (String)Interaction.class.getName(), (String)"getTargetsAndVerbsByTypeAndRegion", (Object)("Thread ID: " + Thread.currentThread().getId()));
        HashMap regions = new HashMap();
        for (Interaction interaction : interactions) {
            HashMap types = (HashMap)regions.get(interaction.getRegion());
            if (types == null) {
                types = new HashMap();
                regions.put(interaction.getRegion(), types);
            }
            Interaction.processInteraction(interaction, types);
        }
        Debug.exit((Logger)logger, (String)Interaction.class.getName(), (String)"getTargetsAndVerbsByTypeAndRegion");
        return regions;
    }

    private static void processInteraction(Interaction interaction, Map types) {
        ArrayList<String> verbsForTarget;
        Debug.enter((Logger)logger, (String)Interaction.class.getName(), (String)"processInteraction", (Object)("Thread ID: " + Thread.currentThread().getId()));
        HashMap<Resource, ArrayList<String>> targetsAndVerbs = (HashMap<Resource, ArrayList<String>>)types.get(interaction.getResource().getTypeName());
        if (targetsAndVerbs == null) {
            targetsAndVerbs = new HashMap<Resource, ArrayList<String>>();
            types.put(interaction.getResource().getTypeName(), targetsAndVerbs);
        }
        if ((verbsForTarget = (ArrayList<String>)targetsAndVerbs.get(interaction.getResource())) == null) {
            verbsForTarget = new ArrayList<String>();
            verbsForTarget.add(interaction.getVerb());
            targetsAndVerbs.put(interaction.getResource(), verbsForTarget);
        } else {
            verbsForTarget.add(interaction.getVerb());
        }
        Debug.exit((Logger)logger, (String)Interaction.class.getName(), (String)"processInteraction");
    }

    public static Map getTargetsByType(Collection interactions) {
        Debug.enter((Logger)logger, (String)Interaction.class.getName(), (String)"getTargetsByType", (Object)("Thread ID: " + Thread.currentThread().getId()));
        HashMap types = new HashMap();
        for (RegionAndResource interaction : interactions) {
            ArrayList<Resource> resources = (ArrayList<Resource>)types.get(interaction.getResource().getTypeName());
            if (resources == null) {
                resources = new ArrayList<Resource>();
                resources.add(interaction.getResource());
                types.put(interaction.getResource().getTypeName(), resources);
                continue;
            }
            if (resources.contains(interaction.getResource())) continue;
            resources.add(interaction.getResource());
        }
        Debug.exit((Logger)logger, (String)Interaction.class.getName(), (String)"getTargetsByType");
        return types;
    }

    public static Map getTargetsByTypeAndRegion(Collection interactions) {
        Debug.enter((Logger)logger, (String)Interaction.class.getName(), (String)"getTargetsByTypeAndRegion", (Object)("Thread ID: " + Thread.currentThread().getId()));
        HashMap regions = new HashMap();
        for (RegionAndResource interaction : interactions) {
            ArrayList<Resource> types;
            HashMap typesInRegion = (HashMap)regions.get(interaction.getRegion());
            if (typesInRegion == null) {
                typesInRegion = new HashMap();
                regions.put(interaction.getRegion(), typesInRegion);
            }
            if ((types = (ArrayList<Resource>)typesInRegion.get(interaction.getResource().getTypeName())) == null) {
                types = new ArrayList<Resource>();
                types.add(interaction.getResource());
                typesInRegion.put(interaction.getResource().getTypeName(), types);
                continue;
            }
            if (types.contains(interaction.getResource())) continue;
            types.add(interaction.getResource());
        }
        Debug.exit((Logger)logger, (String)Interaction.class.getName(), (String)"getTargetsByTypeAndRegion");
        return regions;
    }

    public static List getTargets(Collection interactions) {
        Debug.enter((Logger)logger, (String)Interaction.class.getName(), (String)"getTargets", (Object)("Thread ID: " + Thread.currentThread().getId()));
        ArrayList<Resource> result = new ArrayList<Resource>(interactions.size());
        for (RegionAndResource regionAndResource : interactions) {
            if (result.contains(regionAndResource.getResource())) continue;
            result.add(regionAndResource.getResource());
        }
        Debug.exit((Logger)logger, (String)Interaction.class.getName(), (String)"getTargets");
        return result;
    }

    public Resource getSource() {
        return this.source;
    }

    public String getVerb() {
        return this.verb;
    }

    public Region getSourceRegion() {
        return this.sourceRegion;
    }

    public String getRemoteSysid() {
        return this.remoteSysid;
    }

    public String getRemoteName() {
        return this.remoteName;
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = super.hashCode();
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + (this.sourceRegion == null ? 0 : this.sourceRegion.hashCode());
        result = 31 * result + (this.verb == null ? 0 : this.verb.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Interaction other = (Interaction)obj;
        if (this.region == null ? other.region != null : !this.region.equals(other.region)) {
            return false;
        }
        if (this.resource == null ? other.resource != null : !this.resource.equals(other.resource)) {
            return false;
        }
        if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
            return false;
        }
        if (this.sourceRegion == null ? other.sourceRegion != null : !this.sourceRegion.equals(other.sourceRegion)) {
            return false;
        }
        return !(this.verb == null ? other.verb != null : !this.verb.equals(other.verb));
    }

    public static Collection toUnique(Collection sourceInteractions) {
        Debug.enter((Logger)logger, (String)Interaction.class.getName(), (String)"toUnique", (Object)("Thread ID: " + Thread.currentThread().getId()));
        ArrayList<Interaction> result = new ArrayList<Interaction>();
        block0: for (Interaction interaction : sourceInteractions) {
            if (result.isEmpty()) {
                result.add(interaction);
                continue;
            }
            ArrayList<Interaction> resultCopy = new ArrayList<Interaction>(result);
            resultCopy.addAll(result);
            for (Interaction resultInteraction : resultCopy) {
                if (resultInteraction.getSource() == interaction.getSource() && resultInteraction.getVerb().equals(interaction.getVerb())) continue block0;
            }
            result.add(interaction);
        }
        Debug.exit((Logger)logger, (String)Interaction.class.getName(), (String)"toUnique");
        return result;
    }

    public static List filterByRegion(List interactions, Region region) {
        Debug.enter((Logger)logger, (String)Interaction.class.getName(), (String)"filterByRegion", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Iterator iter = interactions.iterator();
        ArrayList<RegionAndResource> result = new ArrayList<RegionAndResource>(interactions.size());
        while (iter.hasNext()) {
            RegionAndResource interaction = (RegionAndResource)iter.next();
            if (interaction.getRegion() != region) continue;
            result.add(interaction);
        }
        Debug.exit((Logger)logger, (String)Interaction.class.getName(), (String)"filterByRegion");
        return result;
    }

    public static List filterByProgram(List interactions, Program program) {
        Debug.enter((Logger)logger, (String)Interaction.class.getName(), (String)"filterByProgram", (Object)("Thread ID: " + Thread.currentThread().getId()));
        Iterator iter = interactions.iterator();
        ArrayList<RegionAndResource> result = new ArrayList<RegionAndResource>(interactions.size());
        while (iter.hasNext()) {
            RegionAndResource interaction = (RegionAndResource)iter.next();
            if (interaction.getResource() instanceof Program) {
                if (!interaction.getResource().equals(program)) continue;
                result.add(interaction);
                continue;
            }
            result.add(interaction);
        }
        Debug.exit((Logger)logger, (String)Interaction.class.getName(), (String)"filterByProgram");
        return result;
    }
}

