/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.ia.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.ia.model.Interaction;
import com.ibm.cics.ia.model.Program;
import com.ibm.cics.ia.model.Region;
import com.ibm.cics.ia.model.Resource;
import com.ibm.cics.ia.model.Transaction;
import com.ibm.cics.ia.model.Webservice;
import com.ibm.cics.ia.runtime.IAPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class ExecutionAnalyzer
extends Command {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-YB1 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(Listener.class.getPackage().getName());
    protected Region region;
    private Resource root;
    private ArrayList<Resource> completedResources = new ArrayList();
    public List<ResourceAnalysis> totalResourcesAnalyzed = new ArrayList<ResourceAnalysis>();
    protected ArrayList<Listener> listeners;
    public List totalInteractions = new ArrayList();
    private Transaction scopingTransaction;
    private LinkedList transactionQueue;
    private LinkedList programQueue;
    private boolean multiRegion = false;

    public void start() {
        Debug.enter((Logger)logger, (String)ExecutionAnalyzer.class.getName(), (String)"start", (Object)("Thread ID: " + Thread.currentThread().getId()));
        if (IAPlugin.getDefault().isCommandLoggingActive()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.root.toString());
            if (this.region != null) {
                buffer.append(" for " + this.region.toString());
            }
            IAPlugin.getDefault().logInformation(">Uses Resources: " + buffer.toString());
        }
        if (this.status == 1) {
            Debug.exit((Logger)logger, (String)ExecutionAnalyzer.class.getName(), (String)"start");
            return;
        }
        this.status = 0;
        ArrayList recursionList = new ArrayList();
        HashMap recursionMap = new HashMap();
        if (this.region == null) {
            this.multiRegion = true;
            List regions = this.root.getRegions();
            if (regions != null) {
                for (Region next : regions) {
                    this.setRegion(next);
                    this.addTargetsFor(this.root, recursionList, recursionMap, 0);
                    recursionList.clear();
                    recursionMap.clear();
                    this.scopingTransaction = null;
                }
            }
        } else {
            this.multiRegion = false;
            this.addTargetsFor(this.root, recursionList, recursionMap, 0);
        }
        if (this.multiRegion) {
            this.setRegion(null);
        }
        List copyOfListeners = (List)this.listeners.clone();
        for (Object o : copyOfListeners) {
            ((Listener)o).completed();
        }
        if (this.status != 4) {
            this.status = 1;
        }
        IAPlugin.getDefault().taskEnded();
        Debug.exit((Logger)logger, (String)ExecutionAnalyzer.class.getName(), (String)"start");
    }

    private void addTargetsFor(Resource rootResource, List recursionList, Map programRecursionMap, int depth) {
        List invokedByPrograms;
        Debug.enter((Logger)logger, (String)ExecutionAnalyzer.class.getName(), (String)"addTargetsFor", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "rootResource: " + (rootResource == null ? rootResource : rootResource.getName()), "recursionList size: " + (recursionList == null ? recursionList : Integer.valueOf(recursionList.size())), "programRecursionMap size: " + programRecursionMap.size(), "depth: " + depth});
        this.transactionQueue = new LinkedList();
        this.programQueue = new LinkedList();
        if (rootResource instanceof Webservice) {
            invokedByPrograms = ((Webservice)rootResource).getImplementingPrograms(this.region);
            this.programQueue.addAll(invokedByPrograms);
        } else if (rootResource instanceof Program) {
            this.programQueue.addLast(rootResource);
        } else {
            this.transactionQueue.addLast(rootResource);
        }
        while (!this.transactionQueue.isEmpty() || !this.programQueue.isEmpty()) {
            if (!this.programQueue.isEmpty()) {
                Program program = (Program)this.programQueue.removeFirst();
                ArrayList<Transaction> transactions = (ArrayList<Transaction>)programRecursionMap.get(program);
                if (transactions == null) {
                    transactions = new ArrayList<Transaction>();
                }
                if (transactions.contains(null) || transactions.contains(this.scopingTransaction)) continue;
                transactions.add(this.scopingTransaction);
                programRecursionMap.put(program, transactions);
                this.addTargetInteractionsFor(program, depth);
                ++depth;
                continue;
            }
            Transaction transaction = (Transaction)this.transactionQueue.removeFirst();
            if (recursionList.contains(transaction)) continue;
            recursionList.add(transaction);
            this.scopingTransaction = transaction;
            this.addProgramsFor(transaction, programRecursionMap, depth);
            ++depth;
        }
        if (rootResource instanceof Webservice) {
            invokedByPrograms = ((Webservice)rootResource).getImplementingPrograms(this.region);
            this.programQueue.addAll(invokedByPrograms);
            if (this.listeners != null) {
                List copyOfListeners = (List)this.listeners.clone();
                Iterator iter = copyOfListeners.iterator();
                while (iter.hasNext()) {
                    if (this.status == 4) {
                        Debug.exit((Logger)logger, (String)ExecutionAnalyzer.class.getName(), (String)"addTargetsFor");
                        return;
                    }
                    Listener listener = (Listener)iter.next();
                    ResourceAnalysis resourceAnalysis = new ResourceAnalysis(rootResource, this.region, "INIT", invokedByPrograms, 0);
                    listener.resourceAnalyzed(resourceAnalysis);
                    this.totalResourcesAnalyzed.add(resourceAnalysis);
                }
            }
            if (!this.completedResources.contains(rootResource)) {
                this.completedResources.add(rootResource);
                this.notifyListenersResourceCompleted(rootResource);
            }
        }
        Debug.exit((Logger)logger, (String)ExecutionAnalyzer.class.getName(), (String)"addTargetsFor");
    }

    private List getProgramTargetsFor(Program aProgram, String aVerb, String aResourceType) {
        return this.scopingTransaction == null ? aProgram.getTargetsForVerbAndType(aVerb, aResourceType, this.region) : aProgram.getTargetsForVerbAndTypeAndTransaction(aVerb, aResourceType, this.region, this.scopingTransaction);
    }

    private void addTargetInteractionsFor(Program program, int depth) {
        List targetInteractions;
        Debug.enter((Logger)logger, (String)ExecutionAnalyzer.class.getName(), (String)"addTargetInteractionsFor", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "program: " + (program == null ? program : program.getName()), "depth: " + depth});
        if (this.status == 4) {
            Debug.exit((Logger)logger, (String)ExecutionAnalyzer.class.getName(), (String)"addTargetInteractionsFor");
            return;
        }
        List list = targetInteractions = this.scopingTransaction == null ? program.getTargetInteractions() : program.getTargetInteractions(this.scopingTransaction);
        if (targetInteractions == null) {
            this.status = 4;
            Debug.exit((Logger)logger, (String)ExecutionAnalyzer.class.getName(), (String)"addTargetInteractionsFor", (Object)"targetInteractions == null");
            return;
        }
        if (this.region != null) {
            targetInteractions = Interaction.filterByRegion(targetInteractions, this.region);
        }
        if (this.status == 4) {
            Debug.exit((Logger)logger, (String)ExecutionAnalyzer.class.getName(), (String)"addTargetInteractionsFor", (Object)"status == CANCELLED");
            return;
        }
        List linkedPrograms = this.getProgramTargetsFor(program, "LINK", "PROGRAM");
        List xctlPrograms = this.getProgramTargetsFor(program, "XCTL", "PROGRAM");
        List calledPrograms = this.getProgramTargetsFor(program, "CALL", "PROGRAM");
        List loadPrograms = this.getProgramTargetsFor(program, "LOAD", "PROGRAM");
        List startedTransactions = this.getProgramTargetsFor(program, "START", "TRANSID");
        List startReqTransactions = this.getProgramTargetsFor(program, "START REQID", "TRANSID");
        List returnedTransactions = this.getProgramTargetsFor(program, "RETURN", "TRANSID");
        if (this.listeners != null) {
            List copyOfListeners = (List)this.listeners.clone();
            Iterator iter = copyOfListeners.iterator();
            while (iter.hasNext()) {
                if (this.status == 4) {
                    Debug.exit((Logger)logger, (String)ExecutionAnalyzer.class.getName(), (String)"addTargetInteractionsFor", (Object)"status == CANCELLED");
                    return;
                }
                Listener listener = (Listener)iter.next();
                this.addAnalyzedResource(program, "LINK", linkedPrograms, depth, listener);
                this.addAnalyzedResource(program, "CALL", calledPrograms, depth, listener);
                this.addAnalyzedResource(program, "XCTL", xctlPrograms, depth, listener);
                this.addAnalyzedResource(program, "LOAD", loadPrograms, depth, listener);
                this.addAnalyzedResource(program, "START", startedTransactions, depth, listener);
                this.addAnalyzedResource(program, "START REQID", startReqTransactions, depth, listener);
                this.addAnalyzedResource(program, "RETURN", returnedTransactions, depth, listener);
                listener.itemsAdded(targetInteractions);
                this.getResults().addAll(targetInteractions);
            }
        }
        if (!this.completedResources.contains(program)) {
            this.completedResources.add(program);
            this.notifyListenersResourceCompleted(program);
        }
        if (this.addPrograms(linkedPrograms, calledPrograms, xctlPrograms) == 1) {
            Debug.exit((Logger)logger, (String)ExecutionAnalyzer.class.getName(), (String)"addTargetInteractionsFor", (Object)"addPrograms == 1");
            return;
        }
        if (this.addTransactions(startedTransactions, startReqTransactions, returnedTransactions) == 1) {
            Debug.exit((Logger)logger, (String)ExecutionAnalyzer.class.getName(), (String)"addTargetInteractionsFor", (Object)"addTransactions() == 1");
            return;
        }
        targetInteractions = null;
        calledPrograms = null;
        linkedPrograms = null;
        loadPrograms = null;
        returnedTransactions = null;
        startedTransactions = null;
        xctlPrograms = null;
        Debug.exit((Logger)logger, (String)ExecutionAnalyzer.class.getName(), (String)"addTargetInteractionsFor");
    }

    private int addPrograms(List<Program> ... lists) {
        Debug.enter((Logger)logger, (String)ExecutionAnalyzer.class.getName(), (String)"addPrograms", (Object)new String[]{"Thread ID: " + Thread.currentThread().getId()}, (Object)("lists length: " + lists.length));
        List<Program>[] listArray = lists;
        int n = lists.length;
        int n2 = 0;
        while (n2 < n) {
            List<Program> list = listArray[n2];
            for (Program program : list) {
                if (this.status == 4) {
                    Debug.exit((Logger)logger, (String)ExecutionAnalyzer.class.getName(), (String)"addPrograms", (Object)"return 1");
                    return 1;
                }
                this.programQueue.addLast(program);
            }
            ++n2;
        }
        Debug.exit((Logger)logger, (String)ExecutionAnalyzer.class.getName(), (String)"addPrograms", (Object)"return 0");
        return 0;
    }

    private int addTransactions(List<Transaction> ... lists) {
        Debug.enter((Logger)logger, (String)ExecutionAnalyzer.class.getName(), (String)"addTransactions", (Object)new String[]{"Thread ID: " + Thread.currentThread().getId()}, (Object)("lists length: " + lists.length));
        List<Transaction>[] listArray = lists;
        int n = lists.length;
        int n2 = 0;
        while (n2 < n) {
            List<Transaction> list = listArray[n2];
            for (Transaction transaction : list) {
                if (this.status == 4) {
                    Debug.exit((Logger)logger, (String)ExecutionAnalyzer.class.getName(), (String)"addTransactions", (Object)"return 1");
                    return 1;
                }
                this.transactionQueue.addLast(transaction);
            }
            ++n2;
        }
        Debug.exit((Logger)logger, (String)ExecutionAnalyzer.class.getName(), (String)"addTransactions", (Object)"return 0");
        return 0;
    }

    private void addProgramsFor(Transaction transaction, Map programRecursionMap, int depth) {
        Program firstProgram;
        Debug.enter((Logger)logger, (String)ExecutionAnalyzer.class.getName(), (String)"addProgramsFor", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "transaction: " + (transaction == null ? transaction : transaction.getName()), "programRecursionMap size: " + programRecursionMap.size(), "depth: " + depth});
        if (this.status == 4) {
            Debug.exit((Logger)logger, (String)ExecutionAnalyzer.class.getName(), (String)"addProgramsFor", (Object)"status == CANCELLED");
            return;
        }
        List interactions = transaction.getUsesPrograms();
        if (interactions == null) {
            Debug.exit((Logger)logger, (String)ExecutionAnalyzer.class.getName(), (String)"addProgramsFor", (Object)"interactions == null");
            this.status = 4;
            return;
        }
        if (this.region != null) {
            interactions = Interaction.filterByRegion(interactions, this.region);
        }
        if ((firstProgram = transaction.getFirstProgram(this.region)) != null) {
            interactions = Interaction.filterByProgram(interactions, firstProgram);
        }
        ArrayList<Resource> usedPrograms = new ArrayList<Resource>(interactions.size());
        Iterator iter = interactions.iterator();
        while (iter.hasNext()) {
            if (this.status == 4) {
                Debug.exit((Logger)logger, (String)ExecutionAnalyzer.class.getName(), (String)"addProgramsFor", (Object)"status == CANCELLED");
                return;
            }
            Resource program = ((Interaction)iter.next()).resource;
            usedPrograms.add(program);
        }
        if (this.listeners != null) {
            List copyOfListeners = (List)this.listeners.clone();
            iter = copyOfListeners.iterator();
            while (iter.hasNext()) {
                if (this.status == 4) {
                    Debug.exit((Logger)logger, (String)ExecutionAnalyzer.class.getName(), (String)"addProgramsFor", (Object)"status == CANCELLED");
                    return;
                }
                Listener listener = (Listener)iter.next();
                ResourceAnalysis resourceAnalysis = new ResourceAnalysis(transaction, this.region, "START", usedPrograms, depth);
                listener.resourceAnalyzed(resourceAnalysis);
                listener.itemsAdded(interactions);
                this.getResults().addAll(interactions);
                this.totalResourcesAnalyzed.add(resourceAnalysis);
            }
        }
        if (!this.completedResources.contains(transaction)) {
            this.completedResources.add(transaction);
            this.notifyListenersResourceCompleted(transaction);
        }
        iter = usedPrograms.iterator();
        while (iter.hasNext()) {
            if (this.status == 4) {
                Debug.exit((Logger)logger, (String)ExecutionAnalyzer.class.getName(), (String)"addProgramsFor", (Object)"status == CANCELLED");
                return;
            }
            Program usedProgram = (Program)iter.next();
            this.programQueue.addLast(usedProgram);
        }
        Debug.exit((Logger)logger, (String)ExecutionAnalyzer.class.getName(), (String)"addProgramsFor");
    }

    public void removeListener(Listener executionAnalyzerListener) {
        if (this.listeners != null) {
            this.listeners.remove(executionAnalyzerListener);
        }
    }

    public Resource getRoot() {
        return this.root;
    }

    public void addListener(Listener aListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(aListener);
    }

    public void setRoot(Resource aResource) {
        Debug.enter((Logger)logger, (String)ExecutionAnalyzer.class.getName(), (String)"setRoot", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "aResource: " + (aResource == null ? aResource : aResource.getName())});
        this.root = aResource;
        if (aResource instanceof Transaction) {
            this.scopingTransaction = (Transaction)this.root;
        }
        Debug.exit((Logger)logger, (String)ExecutionAnalyzer.class.getName(), (String)"setRoot");
    }

    public void setRegion(Region aRegion) {
        this.region = aRegion;
    }

    public Region getRegion() {
        return this.region;
    }

    public synchronized boolean isResourceCompleted(Resource r) {
        return this.completedResources.contains(r);
    }

    public void reset(Resource resource, Region region) {
        Debug.enter((Logger)logger, (String)ExecutionAnalyzer.class.getName(), (String)"reset", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "resource: " + (resource == null ? resource : resource.getName()), "region: " + (region == null ? region : region.getName())});
        this.status = -1;
        this.setRegion(region);
        this.setRoot(resource);
        this.clear();
        Debug.exit((Logger)logger, (String)ExecutionAnalyzer.class.getName(), (String)"reset");
    }

    public void clear() {
        if (this.transactionQueue != null) {
            this.transactionQueue.clear();
        }
        if (this.programQueue != null) {
            this.programQueue.clear();
        }
        this.totalInteractions.clear();
        this.totalResourcesAnalyzed.clear();
        this.completedResources.clear();
        this.scopingTransaction = null;
    }

    public void clearInteractions() {
        for (Resource completedResource : this.completedResources) {
            completedResource.clearTargetInteractions();
        }
    }

    public void cancel() {
        super.cancel();
    }

    public String[] getColumns() {
        return null;
    }

    private void notifyListenersResourceCompleted(Resource r) {
        for (Listener l : this.listeners) {
            l.resourceComplete(r);
        }
    }

    private void addAnalyzedResource(Resource resource, String verb, List<Resource> resources, int depth, Listener listener) {
        Debug.enter((Logger)logger, (String)ExecutionAnalyzer.class.getName(), (String)"addAnalyzedResource", (Object[])new String[]{"Thread ID: " + Thread.currentThread().getId(), "resource: " + (resource == null ? resource : resource.getName()), "verb: " + verb, "resources size: " + (resources == null ? resources : Integer.valueOf(resources.size())), "depth: " + depth});
        ResourceAnalysis resourceAnalysis = new ResourceAnalysis(resource, this.region, verb, resources, depth);
        listener.resourceAnalyzed(resourceAnalysis);
        this.totalResourcesAnalyzed.add(resourceAnalysis);
        Debug.exit((Logger)logger, (String)ExecutionAnalyzer.class.getName(), (String)"addAnalyzedResource");
    }

    public static interface Listener {
        public void resourceComplete(Resource var1);

        public void resourceAnalyzed(ResourceAnalysis var1);

        public void itemsAdded(Collection var1);

        public void completed();
    }

    public static class ResourceAnalysis {
        public Resource resource;
        public String verb;
        public List<Resource> resources;
        public int depth;
        public Region region;

        ResourceAnalysis(Resource resource, Region region, String verb, List<Resource> resources, int depth) {
            this.resource = resource;
            this.region = region;
            this.verb = verb;
            this.resources = resources;
            this.depth = depth;
        }
    }
}

